/* arm64-darwin.macho-entry.h
   created from arm64-darwin.macho-entry.bin, 7897 (0x1ed9) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2020 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2020 Laszlo Molnar
   Copyright (C) 2000-2020 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_ARM64_DARWIN_MACHO_ENTRY_SIZE    7897
#define STUB_ARM64_DARWIN_MACHO_ENTRY_ADLER32 0x49d29f40
#define STUB_ARM64_DARWIN_MACHO_ENTRY_CRC32   0xe5a4355a

unsigned char stub_arm64_darwin_macho_entry[7897] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,183,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,160, 22,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */ 226,  3,  0,145,  0,  0,  0,148,254, 15, 31,248,226, 15,191,169,
/* 0x0050 */   7, 64, 33,139,  5,  0,128, 18,  4,  0,176, 82, 24,  0,  0, 20,
/* 0x0060 */ 227, 19,193,168,  0,  0,  7,203, 66,  0,  3,203,130,  0,  0,185,
/* 0x0070 */ 228,  3,  0,170,224,  3,  3,170, 97,  0,  2,139, 32,123, 11,213,
/* 0x0080 */  32,117, 11,213,  0,  0,  1,145, 31,  0,  1,235,131,255,255, 84,
/* 0x0090 */ 224,  3,  4,170,254,  7, 65,248,192,  3, 95,214,132,  0,  4, 43,
/* 0x00a0 */  68,  0,  0, 52,192,  3, 95,214,  4, 68, 64,184,132,  0,  4, 58,
/* 0x00b0 */ 192,  3, 95,214,  3, 20, 64, 56, 67, 20,  0, 56,248,255,255,151,
/* 0x00c0 */ 162,255,255, 84, 33,  0,128, 82,  4,  0,  0, 20, 33,  4,  0, 81,
/* 0x00d0 */ 243,255,255,151, 33,  0,  1, 26,241,255,255,151, 33,  0,  1, 26,
/* 0x00e0 */ 239,255,255,151, 67,255,255, 84, 35, 12,  0,113,  1,  0,128, 82,
/* 0x00f0 */  35,  1,  0, 84,  5, 20, 64, 56,165, 32,  3, 42,229,  3, 37, 42,
/* 0x0100 */   5,251,255, 52,191,  0,  0,114,165,124,  1, 19,161,  1,  0, 84,
/* 0x0110 */   3,  0,  0, 20,226,255,255,151, 66,  1,  0, 84, 33,  0,128, 82,
/* 0x0120 */ 223,255,255,151,226,  0,  0, 84,221,255,255,151, 33,  0,  1, 26,
/* 0x0130 */ 219,255,255,151,163,255,255, 84, 33, 16,  0, 17,  4,  0,  0, 20,
/* 0x0140 */ 215,255,255,151, 33,  0,  1, 26, 33,  8,  0, 17,191,  0, 20, 49,
/* 0x0150 */  33, 36,129, 26, 67, 64, 33,139, 99,240, 95, 56, 67,200,101, 56,
/* 0x0160 */  67, 20,  0, 56, 33,  4,  0,113,161,255,255, 84,212,255,255, 23,
/* 0x0170 */ 226, 15,190,169,254, 11,  0,249,  7, 64, 33,139,  5,  0,128, 18,
/* 0x0180 */   4,  0,176, 82, 24,  0,  0, 20,227, 19,193,168,  0,  0,  7,203,
/* 0x0190 */  66,  0,  3,203,130,  0,  0,185,228,  3,  0,170,224,  3,  3,170,
/* 0x01a0 */  97,  0,  2,139, 32,123, 11,213, 32,117, 11,213,  0,  0,  1,145,
/* 0x01b0 */  31,  0,  1,235,131,255,255, 84,224,  3,  4,170,254,  7, 65,248,
/* 0x01c0 */ 192,  3, 95,214,132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,
/* 0x01d0 */   4, 68, 64,184,132,  0,  4, 58,192,  3, 95,214,  3, 20, 64, 56,
/* 0x01e0 */  67, 20,  0, 56,248,255,255,151,162,255,255, 84, 33,  0,128, 82,
/* 0x01f0 */   4,  0,  0, 20, 33,  4,  0, 81,243,255,255,151, 33,  0,  1, 58,
/* 0x0200 */ 241,255,255,151, 33,  0,  1, 58,239,255,255,151, 67,255,255, 84,
/* 0x0210 */  35, 12,  0,113,  1,  0,128, 82, 35,  1,  0, 84,  5, 20, 64, 56,
/* 0x0220 */ 165, 32,  3, 42,229,  3, 37, 42,  5,251,255, 52,163,  0,  1, 83,
/* 0x0230 */ 165,124,  1, 83, 99,  0,  3, 43,  2,  0,  0, 20,226,255,255,151,
/* 0x0240 */  33,  0,  1, 58,224,255,255,151, 33,  0,  1, 58,225,  0,  0, 84,
/* 0x0250 */  33,  0,128, 82,220,255,255,151, 33,  0,  1, 58,218,255,255,151,
/* 0x0260 */ 163,255,255, 84, 33,  8,  0, 17, 33,  4,  0, 17,191,  0, 20, 49,
/* 0x0270 */  33, 52,129, 26, 67,  0, 64, 57, 67,200,101, 56, 67, 20,  0, 56,
/* 0x0280 */  33,  4,  0,113,161,255,255, 84,215,255,255, 23,  1, 64, 33,139,
/* 0x0290 */ 225, 11,190,169,227,123,  1,169,  5,  0,128, 18,  4,  0,176, 82,
/* 0x02a0 */  31,  0,  0, 20,228,123, 65,169,225, 15,194,168,  0,  0,  1,203,
/* 0x02b0 */  66,  0,  3,203,130,  0,  0,185,228,  3,  0,170,224,  3,  3,170,
/* 0x02c0 */  97,  0,  2,139, 32,123, 11,213, 32,117, 11,213,  0,  0,  1,145,
/* 0x02d0 */  31,  0,  1,235,131,255,255, 84,224,  3,  4,170,192,  3, 95,214,
/* 0x02e0 */ 132,  0,  4, 43, 68,  0,  0, 52,192,  3, 95,214,  4, 68, 64,184,
/* 0x02f0 */ 132,  0,  4, 58,192,  3, 95,214, 33,  0,128, 82,240,  3, 30,170,
/* 0x0300 */ 248,255,255,151, 33,  0,  1, 58,246,255,255,151,163,255,255, 84,
/* 0x0310 */   0,  2, 31,214,  3, 20, 64, 56, 67, 20,  0, 56,241,255,255,151,
/* 0x0320 */ 162,255,255, 84,245,255,255,151, 35, 12,  0,113,  1,  0,128, 82,
/* 0x0330 */ 163,  0,  0, 84,  5, 20, 64, 56,165, 32,  3, 42,229,  3, 37, 42,
/* 0x0340 */  37,251,255, 52,231,255,255,151, 33,  0,  1, 58,229,255,255,151,
/* 0x0350 */  33,  0,  1, 58, 97,  0,  0, 84,232,255,255,151, 33,  8,  0, 17,
/* 0x0360 */ 191,  0, 52, 49, 33, 36,129, 26, 67,200,101, 56, 33,  4,  0,113,
/* 0x0370 */  67, 20,  0, 56,162,255,255, 84,233,255,255, 23,159, 56,  0,113,
/* 0x0380 */   1,  0,  0, 84,226, 15,190,169,253,123,  1,169,253,  3,  0,145,
/* 0x0390 */   8,  0, 64, 57,  7,192,128, 82,  8,125,  3, 83,231, 32,200, 26,
/* 0x03a0 */ 231,192, 57, 17,232,  3,  0,145,255, 67, 39,203,228,  3,  0,145,
/* 0x03b0 */ 159,124,129,168,159,  0,  8,235,195,255,255, 84,255,127,191,169,
/* 0x03c0 */ 230,  3,  3,170,197,  0, 64,185,228,  3,  2,170,227, 35,  0,145,
/* 0x03d0 */  34,  8,  0, 81,225,  3,  0,170,224,  3,  0,145, 39, 20, 64, 56,
/* 0x03e0 */ 231,  8,  0, 18,  7,  8,  0, 57, 39, 20, 64, 56,232,124,  4, 83,
/* 0x03f0 */   8,  4,  0, 57,231, 12,  0, 18,  7,  0,  0, 57, 14,  0,  0,148,
/* 0x0400 */ 191,  3,  0,145,228,  3,  0,170,253,123, 65,169,224,  7,194,168,
/* 0x0410 */  33,  0, 64,249, 33,  0,  0,139, 32,123, 11,213, 32,117, 11,213,
/* 0x0420 */   0,  0,  1,145, 31,  0,  1,235,131,255,255, 84,224,  3,  4,170,
/* 0x0430 */ 192,  3, 95,214,255, 67,  1,209, 39,  0,128, 82, 17, 16,  0,145,
/* 0x0440 */   9,128,128, 82,243, 83,  0,169,245, 91,  1,169,247, 99,  2,169,
/* 0x0450 */ 249,107,  3,169,251,115,  4,169, 20,  8, 64, 57, 19,  4, 64, 57,
/* 0x0460 */  22,  0, 64, 57,244, 32,212, 26,127,  0,  0,185,243, 32,211, 26,
/* 0x0470 */ 223,  0,  0,185,  7,  0,128,210,148,  6,  0, 81,  8,  4, 64, 57,
/* 0x0480 */  10,  1, 22, 11,104,  6,  0, 81, 18,  1, 39, 30,  8, 96,128, 82,
/* 0x0490 */   8, 33,202, 26,  8,217, 28, 49,160,  0,  0, 84, 41,122, 39,120,
/* 0x04a0 */ 231,  4,  0,145, 31,  1,  7,107,168,255,255, 84, 34, 64, 34,139,
/* 0x04b0 */  63,  0,  2,235, 64, 16,  0, 84,235,  3,  1,170, 40,  4,  0,145,
/* 0x04c0 */ 103, 85, 64, 56, 31,  1,  2,235,160, 15,  0, 84,  9, 21, 64, 56,
/* 0x04d0 */  31,  1, 11,235, 39, 33,  7, 42, 97,255,255, 84,229, 69,  0, 52,
/* 0x04e0 */   8,  1,128, 82, 53,  0,128, 82, 18,  0,128, 82,  9,  0,128, 18,
/* 0x04f0 */  20,  1, 39, 30,104,  0,128, 82,177,  2, 39, 30,247,  3, 21, 42,
/* 0x0500 */   7,  1, 39, 30,  8, 86,128,210,165,  2, 39, 30,252,  3, 21, 42,
/* 0x0510 */   3,  1,103,158,104,  1,128, 82,234,  3, 18, 42,240,  3, 18, 42,
/* 0x0520 */   0,  1, 39, 30,  8,176, 41,145, 14,224,191, 18, 15,  0,129, 82,
/* 0x0530 */   1,  1,103,158, 40,  1,128, 82,  2,  1, 39, 30,136,  2, 38, 30,
/* 0x0540 */   8,  1, 22, 75, 16,  1, 39, 30, 72,110, 28, 83, 63,  1, 14,107,
/* 0x0550 */  25,  2, 20, 10, 13,125, 64,147,173,193, 57,139,173,249,127,211,
/* 0x0560 */ 232,  0,  0, 84,127,  1,  2,235,160, 10,  0, 84,104,  1, 64, 57,
/* 0x0570 */  41, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42, 59,106,109,120,
/* 0x0580 */  40,125, 11, 83,  8,125, 27, 27,255,  0,  8,107,130, 10,  0, 84,
/* 0x0590 */  73,  2, 38, 30, 19, 62,  1, 14, 95, 26,  0,113, 12,  2,  9, 10,
/* 0x05a0 */  73, 41,211, 26,140, 33,214, 26,234,  1, 27, 75, 41,  1, 12, 11,
/* 0x05b0 */ 106, 23,138, 11, 42,106, 45,120, 41,  5,  9, 11, 41, 93,120,211,
/* 0x05c0 */  41,217, 28,145, 58,  6,  9,139,109, 31,  0, 84, 10,  2, 28, 75,
/* 0x05d0 */  41,  0,128, 82,153,104,106, 56,  7,  0,  0, 20, 91,107, 42,120,
/* 0x05e0 */  41,121, 31, 83,232,  3, 13, 42, 83, 57,  0, 53, 63,253,  3,113,
/* 0x05f0 */ 236,  3,  0, 84, 57,123, 31, 83, 31,  1, 14,107, 51,  3, 24, 18,
/* 0x0600 */  56,121, 31, 83,106,126, 64,147, 74,  1,  4,145, 74,193, 41,139,
/* 0x0610 */  74,249,127,211,232,  0,  0, 84,127,  1,  2,235,  8, 93, 24, 83,
/* 0x0620 */ 224,  4,  0, 84,108,  1, 64, 57,107,  5,  0,145,135, 33,  7, 42,
/* 0x0630 */  76,107,106,120, 13,125, 11, 83,251,  1, 12, 75,173,125, 12, 27,
/* 0x0640 */ 155, 21,155, 11,140, 21, 76, 75,255,  0, 13,107,  8,  1, 13, 75,
/* 0x0650 */  99,252,255, 84, 76,107, 42,120,  9,  7,  0, 17,231,  0, 13, 75,
/* 0x0660 */ 115,252,255, 53, 63,253,  3,113, 77, 27,  0, 84, 42, 29,  0, 83,
/* 0x0670 */ 233,  3,  8, 42,138, 72, 48, 56, 16,  6,  0, 17, 95, 38,  0,113,
/* 0x0680 */ 236, 49,  0, 84, 82, 14,  0, 81,191,  0, 16,107,232,245,255, 84,
/* 0x0690 */   0,224,191, 18, 63,  1,  0,107,136,  0,  0, 84,127,  1,  2,235,
/* 0x06a0 */ 224,  0,  0, 84,107,  5,  0,145, 97,  1,  1,203, 97,  0,  0,185,
/* 0x06b0 */ 208,  0,  0,185,  0,  0,128, 82,  2,  0,  0, 20, 32,  0,128, 82,
/* 0x06c0 */ 243, 83, 64,169,245, 91, 65,169,247, 99, 66,169,249,107, 67,169,
/* 0x06d0 */ 251,115, 68,169,255, 67,  1,145,192,  3, 95,214, 58,  1,  8, 75,
/* 0x06e0 */  74,126, 64,147,105, 23, 91, 75, 95,  3, 14,107, 41,106, 45,120,
/* 0x06f0 */  76,  1,  3,145,231,  0,  8, 75,140,249,127,211,232,  0,  0, 84,
/* 0x0700 */ 127,  1,  2,235,192,253,255, 84,104,  1, 64, 57, 90, 95, 24, 83,
/* 0x0710 */ 107,  5,  0,145,  7, 33,  7, 42, 40,106,108,120, 74,127, 11, 83,
/* 0x0720 */  74,125,  8, 27,255,  0, 10,107,130, 25,  0, 84,237,  0, 38, 30,
/* 0x0730 */ 233,  1,  8, 75, 95, 30,  0,113, 53,  2, 38, 30,  8, 21,137, 11,
/* 0x0740 */ 241,  2, 39, 30, 40,106, 44,120,242,179,141, 26, 12,160, 25,145,
/* 0x0750 */ 247,  3, 28, 42, 95,  1, 14,107,232,  0,  0, 84,127,  1,  2,235,
/* 0x0760 */ 224,250,255, 84,104,  1, 64, 57, 74, 93, 24, 83,107,  5,  0,145,
/* 0x0770 */   7, 33,  7, 42,141,  1, 64,121, 73,125, 11, 83, 41,125, 13, 27,
/* 0x0780 */ 255,  0,  9,107, 98, 31,  0, 84, 40,115, 29, 83,115,  0,128, 82,
/* 0x0790 */ 234,  1, 13, 75,  8,125, 64,147,  8,  9,  0,145,173, 21,138, 11,
/* 0x07a0 */ 228,  3, 39, 30,141,  1,  0,121,102,  2, 39, 30,153,  5,  8,139,
/* 0x07b0 */ 218,  0, 38, 30, 44,  0,128, 82,  6,  0,  0, 20, 13,  3,  0,121,
/* 0x07c0 */  90,  7,  0,113,140,121, 31, 83,233,  3,  8, 42, 32,  3,  0, 84,
/* 0x07d0 */  63,  1, 14,107,147,121, 31, 83, 56,199, 44,139,232,  0,  0, 84,
/* 0x07e0 */ 127,  1,  2,235, 41, 93, 24, 83,160,246,255, 84,104,  1, 64, 57,
/* 0x07f0 */ 107,  5,  0,145,  7, 33,  7, 42,  8,  3, 64,121, 42,125, 11, 83,
/* 0x0800 */ 237,  1,  8, 75, 27, 21, 72, 75, 13, 21,141, 11, 72,125,  8, 27,
/* 0x0810 */ 255,  0,  8,107, 41,  1,  8, 75, 35,253,255, 84, 27,  3,  0,121,
/* 0x0820 */  90,  7,  0,113,231,  0,  8, 75,108,  6,  0, 17, 33,253,255, 84,
/* 0x0830 */ 166, 68,166, 46,138,  0, 38, 30, 95, 14,  0,113,200,  0, 38, 30,
/* 0x0840 */  72,  1,  8, 75,  8,  1, 12, 11,  6,  1, 39, 30,236, 22,  0, 84,
/* 0x0850 */ 234,  0, 38, 30, 31, 13,  0,113,220,  0,128, 82, 10,209,138, 26,
/* 0x0860 */  40,  0,128, 82, 74,101, 26, 83, 74,125, 64,147, 74,193,  6,145,
/* 0x0870 */  91,249,127,211,  6,  0,  0, 20, 44,106, 57,120,156,  7,  0,113,
/* 0x0880 */   8,121, 31, 83,233,  3, 10, 42, 32,  3,  0, 84, 63,  1, 14,107,
/* 0x0890 */  19,121, 31, 83,121,199, 40,139,232,  0,  0, 84,127,  1,  2,235,
/* 0x08a0 */  41, 93, 24, 83,192,240,255, 84,106,  1, 64, 57,107,  5,  0,145,
/* 0x08b0 */  71, 33,  7, 42, 42,106,121,120, 45,125, 11, 83,236,  1, 10, 75,
/* 0x08c0 */  90, 21, 74, 75, 76, 21,140, 11,170,125, 10, 27,255,  0, 10,107,
/* 0x08d0 */  41,  1, 10, 75, 35,253,255, 84, 58,106, 57,120,156,  7,  0,113,
/* 0x08e0 */ 231,  0, 10, 75,104,  6,  0, 17, 33,253,255, 84, 10,  1,  1, 81,
/* 0x08f0 */  95, 13,  0,113, 45, 17,  0, 84, 95, 53,  0,113, 72,  1,  0, 18,
/* 0x0900 */  77,125,  1, 19, 12,  1, 31, 50,140, 32,  0, 84,104,  0,102,158,
/* 0x0910 */ 187,  5,  0, 81,152, 33,219, 26,  8,193, 42,203,  8, 65, 56,139,
/* 0x0920 */  40,  6,  8,139,  8,  9,  0,209, 19,  1,103,158, 40,  0,128, 82,
/* 0x0930 */ 252,  3,  8, 42,  7,  0,  0, 20, 83,  3,  0,121,  8,121, 31, 83,
/* 0x0940 */ 233,  3, 10, 42,123,  7,  0,113,156,123, 31, 83,128, 14,  0, 84,
/* 0x0950 */ 106,  2,102,158, 63,  1, 14,107, 25,121, 31, 83, 90,197, 40,139,
/* 0x0960 */ 232,  0,  0, 84,127,  1,  2,235, 41, 93, 24, 83,128,234,255, 84,
/* 0x0970 */ 106,  1, 64, 57,107,  5,  0,145, 71, 33,  7, 42, 74,  3, 64,121,
/* 0x0980 */  45,125, 11, 83,243,  1, 10, 75, 76, 21, 74, 75, 83, 21,147, 11,
/* 0x0990 */ 170,125, 10, 27,255,  0, 10,107, 41,  1, 10, 75,227,252,255, 84,
/* 0x09a0 */  76,  3,  0,121, 24,  3, 28, 42,231,  0, 10, 75, 40,  7,  0, 17,
/* 0x09b0 */ 229,255,255, 23, 41,  0,128, 82,  6,  0,  0, 20, 41,121, 31, 83,
/* 0x09c0 */  74,107, 56,120, 63,253,  3,113,232,  3, 12, 42, 44,  3,  0, 84,
/* 0x09d0 */  31,  1, 14,107, 51,121, 31, 83, 56,125,127,147,232,  0,  0, 84,
/* 0x09e0 */ 127,  1,  2,235,  8, 93, 24, 83,160,230,255, 84,106,  1, 64, 57,
/* 0x09f0 */ 107,  5,  0,145, 71, 33,  7, 42, 74,107,120,120, 12,125, 11, 83,
/* 0x0a00 */ 237,  1, 10, 75,140,125, 10, 27, 89, 21, 74, 75, 74, 21,141, 11,
/* 0x0a10 */ 255,  0, 12,107,  8,  1, 12, 75, 35,253,255, 84,105,  6,  0, 17,
/* 0x0a20 */  89,107, 56,120, 63,253,  3,113,231,  0, 12, 75, 45,253,255, 84,
/* 0x0a30 */  42, 29,  0, 83, 95, 14,  0,113,138, 72, 48, 56,233,  3,  8, 42,
/* 0x0a40 */  16,  6,  0, 17,204,225,255, 84,191,  0, 16,107, 18,  0,128, 82,
/* 0x0a50 */ 200,215,255, 84, 15,255,255, 23, 73,  3, 10, 75,  8, 21, 72, 75,
/* 0x0a60 */  63,  1, 14,107, 40,106, 44,120,231,  0, 10, 75,154, 97,  0,145,
/* 0x0a70 */ 232,  0,  0, 84,127,  1,  2,235, 32,226,255, 84,104,  1, 64, 57,
/* 0x0a80 */  41, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42, 40,106,122,120,
/* 0x0a90 */  42,125, 11, 83, 74,125,  8, 27,255,  0, 10,107, 66, 10,  0, 84,
/* 0x0aa0 */ 233,  1,  8, 75, 95,  1, 14,107,173,129,  7,145,  8, 21,137, 11,
/* 0x0ab0 */  40,106, 58,120,232,  0,  0, 84,127,  1,  2,235,  0,224,255, 84,
/* 0x0ac0 */ 104,  1, 64, 57, 74, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0ad0 */  40,106,109,120, 73,125, 11, 83, 41,125,  8, 27,255,  0,  9,107,
/* 0x0ae0 */ 226, 16,  0, 84,234,  1,  8, 75,  8, 21,138, 11, 40,106, 45,120,
/* 0x0af0 */ 112,222,255, 52, 74,  0, 38, 30,  8,  2, 28, 75, 12,  0, 38, 30,
/* 0x0b00 */  95, 30,  0,113, 82,177,140, 26,138,104,104, 56,138, 72, 48, 56,
/* 0x0b10 */  16,  6,  0, 17,221,254,255, 23,248,  3, 10, 42, 28,  7,  0, 49,
/* 0x0b20 */ 128,219,255, 84, 82, 30,  0, 17,200,  0, 38, 30,159,  3, 16,107,
/* 0x0b30 */  12,  9,  0, 17, 72,220,255, 84,232,  3, 16, 42,  2,  0,  0, 20,
/* 0x0b40 */  76,218,255, 52, 10,  2, 28, 75, 16,  6,  0, 17, 31,  2,  5,107,
/* 0x0b50 */ 140,  5,  0, 81,138,104,106, 56,138, 72, 40, 56,232,  3, 16, 42,
/* 0x0b60 */   3,255,255, 84,191,  0, 16,107,  8,207,255, 84,201,254,255, 23,
/* 0x0b70 */  74,  1,  9, 75,173, 21, 77, 75, 95,  1, 14,107,141,  1,  0,121,
/* 0x0b80 */ 231,  0,  9, 75,232,  0,  0, 84,127,  1,  2,235,128,217,255, 84,
/* 0x0b90 */ 104,  1, 64, 57, 74, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0ba0 */ 141,  5, 64,121, 73,125, 11, 83, 41,125, 13, 27,255,  0,  9,107,
/* 0x0bb0 */  34,  7,  0, 84, 40,115, 29, 83, 19,  1,128, 82,234,  1, 13, 75,
/* 0x0bc0 */   8,125, 64,147,100,  2, 39, 30,  8,  9,  2,145,115,  0,128, 82,
/* 0x0bd0 */ 173, 21,138, 11,153,  5,  8,139,141,  5,  0,121,102,  2, 39, 30,
/* 0x0be0 */ 244,254,255, 23, 41,  1, 10, 75,  8, 21, 72, 75, 63,  1, 14,107,
/* 0x0bf0 */  40,106, 58,120,231,  0, 10, 75,154,193,  0,145,232,  0,  0, 84,
/* 0x0c00 */ 127,  1,  2,235,192,213,255, 84,104,  1, 64, 57, 41, 93, 24, 83,
/* 0x0c10 */ 107,  5,  0,145,  7, 33,  7, 42, 45,106,122,120, 40,125, 11, 83,
/* 0x0c20 */  10,125, 13, 27,255,  0, 10,107, 35,  5,  0, 84, 41,  1, 10, 75,
/* 0x0c30 */ 173, 21, 77, 75, 63,  1, 14,107, 45,106, 58,120,231,  0, 10, 75,
/* 0x0c40 */ 140, 33,  1,145,232,  0,  0, 84,127,  1,  2,235,128,211,255, 84,
/* 0x0c50 */ 104,  1, 64, 57, 41, 93, 24, 83,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0c60 */  45,106,108,120, 40,125, 11, 83, 10,125, 13, 27,255,  0, 10,107,
/* 0x0c70 */   2,  8,  0, 84,232,  1, 13, 75,233,  3, 28, 42, 60,  2, 38, 30,
/* 0x0c80 */ 173, 21,136, 11, 45,106, 44,120,241,  2, 39, 30,247,  3,  9, 42,
/* 0x0c90 */  21,  0,  0, 20,  8,  2,128, 82,231,  0,  9, 75,173, 21, 77, 75,
/* 0x0ca0 */ 153, 17,  8,145,  4,  1, 39, 30,  8,  1,128, 82,141,  5,  0,121,
/* 0x0cb0 */  73,  1,  9, 75,  6,  1, 39, 30,190,254,255, 23,191,  0, 16,107,
/* 0x0cc0 */  82, 26,  0, 81, 40,196,255, 84,114,254,255, 23,232,  1, 13, 75,
/* 0x0cd0 */ 233,  3, 28, 42,252,  3, 23, 42,247,  3,  9, 42,173, 21,136, 11,
/* 0x0ce0 */  45,106, 58,120,136,  2, 38, 30, 95, 30,  0,113,  9,  0, 38, 30,
/* 0x0cf0 */  44,  0,102,158, 18,177,137, 26,151,254,255, 23,  8, 21, 72, 75,
/* 0x0d00 */  74,  1,  9, 75,231,  0,  9, 75, 40,106, 45,120,246,255,255, 23,
/* 0x0d10 */ 232,  3, 13, 42, 84,254,255, 23,170, 21,  0, 81, 63,  1, 14,107,
/* 0x0d20 */ 140,121, 31, 83,232,  0,  0, 84,127,  1,  2,235, 41, 93, 24, 83,
/* 0x0d30 */  96,204,255, 84,104,  1, 64, 57,107,  5,  0,145,  7, 33,  7, 42,
/* 0x0d40 */  41,125,  1, 83,255,  0,  9,107, 99,  0,  0, 84,231,  0,  9, 75,
/* 0x0d50 */ 140,  1,  0, 50, 74,  5,  0,113, 33,254,255, 84,  8, 32, 25,145,
/* 0x0d60 */ 152,109, 28, 83,155,  0,128, 82, 19,  1,103,158,240,254,255, 23,
/* 0x0d70 */ 232,  3, 28, 42,231,  0, 10, 75,173, 21, 77, 75,252,  3, 21, 42,
/* 0x0d80 */  45,106, 44,120, 42,  1, 10, 75, 53,  2, 38, 30,241,  2, 39, 30,
/* 0x0d90 */ 247,  3,  8, 42,212,255,255, 23,240,  3,  5, 42,227, 19,189,169,
/* 0x0da0 */ 229, 27,  1,169,254, 19,  0,249,232,  3,  1,170, 45, 64, 34,139,
/* 0x0db0 */ 233,  3,  4,170,142, 64, 37,139, 11, 16,  0,145,  6,  0, 64, 57,
/* 0x0dc0 */   5,  4, 64, 57,  4,  8, 64, 57,174,  0,  6, 11,  7,  0,128, 18,
/* 0x0dd0 */ 229, 32,197, 26,229,  3, 37, 42,228, 32,196, 26,228,  3, 36, 42,
/* 0x0de0 */  35,  0,128, 82, 34,  0,128, 82, 33,  0,128, 82, 32,  0,128, 82,
/* 0x0df0 */   6,  0,128, 82,230, 31,  0,185,  2, 96,128, 82,192,230,128, 82,
/* 0x0e00 */  66, 32,206, 26, 66,  0,  0, 11,  0,128,128,210,225,  3, 11,170,
/* 0x0e10 */   0, 64,  0,170,  0,128,  0,170, 32,132,  0,248, 66, 16,  0,113,
/* 0x0e20 */ 204,255,255, 84,  0, 21,  0,145,231,  0,  0,148, 31,  0,  8,235,
/* 0x0e30 */ 193,255,255, 84,227, 67, 66,248,226, 19, 64,185, 36,  1,  3,203,
/* 0x0e40 */ 128,  0,  2, 10,224, 47,  0,185,  0, 16,  6, 11, 97,  1,  0,145,
/* 0x0e50 */ 225,  0,  0,148,129,  5,  0, 84,227, 23, 64,185,226, 27, 64,185,
/* 0x0e60 */  99,  0,  4, 10,224,115, 64, 57, 99, 32,194, 26,226,  3,  2, 75,
/* 0x0e70 */  66, 32,  0, 17,  2, 36,194, 26, 99,  0,  2, 11,106,177, 57,145,
/* 0x0e80 */  99,  4,  3, 11,227,  3,  3, 42, 32,  0,128, 82, 74, 37,  3,139,
/* 0x0e90 */ 223, 28,  0,113,  3,  2,  0, 84,227,125, 64,147,227,  3,  3,203,
/* 0x0ea0 */  37,105, 99, 56,165,120, 31, 83, 65,  1,  8,145,164,  0, 24, 18,
/* 0x0eb0 */ 227,  3,  4, 42, 33,  4,  3,139,201,  0,  0,148,  3,  0,  0, 18,
/* 0x0ec0 */ 127, 32, 68,107,193,  0,  0, 84, 31,  0,  4,113,195,254,255, 84,
/* 0x0ed0 */   5,  0,  0, 20,225,  3, 10,170,193,  0,  0,148, 31,  0,  4,113,
/* 0x0ee0 */ 163,255,255, 84, 98,  0,128, 82,195,  0,128, 82,223, 40,  0,113,
/* 0x0ef0 */  67, 48,131, 26,223, 16,  0,113,195, 48,131, 26,198,  0,  3, 75,
/* 0x0f00 */  34,  0,  0, 20, 97,  1,  6,145,178,  0,  0,148,129,  1,  0, 84,
/* 0x0f10 */ 227, 11, 64,185,226,  7, 64,185,227, 15,  0,185,226, 11,  0,185,
/* 0x0f20 */ 239,  7,  0,185,  3,  0,128, 82,223, 28,  0,113,102,  0,128, 82,
/* 0x0f30 */ 102, 48,134, 26,106,145, 25,145, 42,  0,  0, 20, 97, 97,  6,145,
/* 0x0f40 */ 164,  0,  0,148, 97,  2,  0, 84,227, 47, 64,185, 97,129,  7,145,
/* 0x0f50 */  96, 16,  6, 11,160,  0,  0,148,161,  3,  0, 84, 35,  1,128, 82,
/* 0x0f60 */ 223, 28,  0,113,102,  1,128, 82,102, 48,134, 26,227, 67, 66,248,
/* 0x0f70 */  36,  1,  3,203,159,  0, 15,107,131, 17,  0, 84,227,125, 64,147,
/* 0x0f80 */ 227,  3,  3,203, 32,105, 99, 56, 32, 21,  0, 56,121,  0,  0, 20,
/* 0x0f90 */  97,193,  6,145,143,  0,  0,148,228,  7, 64,185, 64,  1,  0, 84,
/* 0x0fa0 */  97, 33,  7,145,139,  0,  0,148,228, 11, 64,185,128,  0,  0, 84,
/* 0x0fb0 */ 227, 11, 64,185,228, 15, 64,185,227, 15,  0,185,227,  7, 64,185,
/* 0x0fc0 */ 227, 11,  0,185,239,  7,  0,185,239,  3,  4, 42,  3,  1,128, 82,
/* 0x0fd0 */ 223, 28,  0,113,102,  1,128, 82,102, 48,134, 26,106,161, 41,145,
/* 0x0fe0 */  65,  1,  0,145,125,  0,  0,148,  1,  1,  0, 84,227, 47, 64,185,
/* 0x0ff0 */  69, 17,  0,145,227,  3,  3, 42,  2,  0,128, 82,165, 16,  3,139,
/* 0x1000 */   4,  1,128, 82, 14,  0,  0, 20, 65,  9,  0,145,115,  0,  0,148,
/* 0x1010 */   1,  1,  0, 84,227, 47, 64,185, 69, 17,  4,145,227,  3,  3, 42,
/* 0x1020 */   2,  1,128, 82,165, 16,  3,139,  4,  1,128, 82,  4,  0,  0, 20,
/* 0x1030 */  69, 17,  8,145,  2,  2,128, 82,  4, 32,128, 82,226, 55,  0,185,
/* 0x1040 */  32,  0,128, 82,225,  3,  5,170,101,  0,  0,148,  3,  0,  4,107,
/* 0x1050 */ 163,255,255, 84,229, 55, 64,185,165,  0,  3, 11,229, 55,  0,185,
/* 0x1060 */ 223, 16,  0,113,194,  6,  0, 84,198, 28,  0, 17, 99,  0,128, 82,
/* 0x1070 */ 191, 16,  0,113,101, 32,133, 26,227,  3,  5, 42,101, 29,  3,139,
/* 0x1080 */ 165,128, 13,145, 32,  0,128, 82,  4,  8,128, 82,225,  3,  5,170,
/* 0x1090 */  83,  0,  0,148,  3,  0,  4,107,163,255,255, 84,227, 47,  0,185,
/* 0x10a0 */ 127, 16,  0,113, 99,  4,  0, 84,100,124,  1, 83,132,  4,  0, 81,
/* 0x10b0 */ 111,  0,  0, 18,239,  1, 31, 50,127, 56,  0,113,226,  0,  0, 84,
/* 0x10c0 */ 239, 33,196, 26,106,121, 21,145,227,  1,  3, 75,227,  3,  3, 42,
/* 0x10d0 */  74,  5,  3,139, 12,  0,  0, 20,132, 16,  0, 81, 53,  0,  0,148,
/* 0x10e0 */ 231,124,  1, 83,131,  1,  7,107,108, 32,140, 26,239,  1, 15, 26,
/* 0x10f0 */ 132,  4,  0,113, 65,255,255, 84,106, 17, 25,145,239,109, 28, 83,
/* 0x1100 */ 132,  0,128, 82, 37,  0,128, 82, 32,  0,128, 82,225,  3, 10,170,
/* 0x1110 */  51,  0,  0,148, 31,  0,  0,114, 64,  0,  0, 84,239,  1,  5, 42,
/* 0x1120 */ 165,120, 31, 83,132,  4,  0,113, 33,255,255, 84,  2,  0,  0, 20,
/* 0x1130 */ 239, 47, 64,185,239,  5,  0, 49,229, 55, 64,185,227, 67, 66,248,
/* 0x1140 */ 165,  8,  0, 17, 35,  1,  3,203,255,  1,  3,107,232,  2,  0, 84,
/* 0x1150 */ 227,125, 64,147,227,  3,  3,203, 32,105, 99, 56, 32, 21,  0, 56,
/* 0x1160 */  63,  1, 14,235,194,  0,  0, 84,165,  4,  0,113, 97,255,255, 84,
/* 0x1170 */ 224,115,  0, 57, 63,  1, 14,235,227,229,255, 84, 13,  0,  0,148,
/* 0x1180 */   0,  0,128, 82,226, 19, 64,249,  3,  1,  2,203,226, 31, 64,249,
/* 0x1190 */  67,  0,  0,185,226, 67, 66,248, 35,  1,  2,203,226, 55, 64,249,
/* 0x11a0 */  67,  0,  0,185,255,243,  0,145, 32,  0,128, 82,246,255,255, 23,
/* 0x11b0 */ 227,124, 24, 83,195,  0,  0, 53, 31,  1, 13,235,231, 92, 24, 83,
/* 0x11c0 */  66,255,255, 84,  3, 21, 64, 56,108, 32, 12, 42,192,  3, 95,214,
/* 0x11d0 */ 224,  3,  6, 42, 33, 68, 32,139,  0,  0,128, 82, 33, 68, 32,139,
/* 0x11e0 */ 227,124, 24, 83,241,  3, 30,170, 94,  0,  0, 16, 99,254,255, 52,
/* 0x11f0 */  35,  0, 64,121,226,124, 11, 83, 98,124,  2, 27,159,  1,  2,107,
/* 0x1200 */   2,  1,  0, 84,231,  3,  2, 42,  2,  0,129, 82, 66,  0,  3, 75,
/* 0x1210 */   0,  0,  0, 58, 99, 20, 66, 11, 35,  0,  0,121, 32,  2, 95,214,
/* 0x1220 */ 140,  1,  2, 75,231,  0,  2, 75, 99, 20, 67, 75,  0,  0,  0, 58,
/* 0x1230 */  35,  0,  0,121, 32,  2, 95,214,251,  3, 30,170,103,  3, 64,185,
/* 0x1240 */  98,  3, 22,203, 66, 64, 39,139,226, 11,  0,249,225,  3,  2,170,
/* 0x1250 */   5,  0,128, 82,  4,  0,128, 18, 67,  4,128, 82, 98,  0,128, 82,
/* 0x1260 */   0,  0,128,210,168, 24,128, 82,  1,  0,  0,212,224,  7,  0,249,
/* 0x1270 */ 148,  2, 22,203,148,  2,  0,139,  5,  0,128,210,228,  3, 64,185,
/* 0x1280 */  67,  2,128, 82, 98,  0,128, 82, 97,  3, 22,203,168, 24,128, 82,
/* 0x1290 */   1,  0,  0,212,226, 11, 64,249,227, 19, 64,249, 66,  0,  0,139,
/* 0x12a0 */  23,  0,  3,203,131,  3, 23,139,227, 15, 30,248, 96,204,116,146,
/* 0x12b0 */ 224,  7,  0,249, 66,  0,  0,203,226, 11,  0,249,103,  3, 64,185,
/* 0x12c0 */ 227, 99,  0,145,231, 15,  0,249, 98,  3, 23,139,243,  3,  2,170,
/* 0x12d0 */ 103,  7, 64,185,100, 11, 64,185, 96, 51,  0,145,225,  3,  7,170,
/* 0x12e0 */ 128,  3, 63,214,225, 11, 64,249,224,  7, 64,249,252,  7, 66,248,
/* 0x12f0 */ 162,  0,128, 82, 72,  9,128, 82,  1,  0,  0,212, 96,  2, 31,214,
/* 0x1300 */ 101,120,101, 99,117,116, 97, 98,108,101, 95,112, 97,116,104, 61,
/* 0x1310 */   0,  0, 32,212,252,  3, 30,170, 64,132, 64,248,224,255,255,181,
/* 0x1320 */  64,132, 64,248,224,255,255,181, 64,132, 64,248, 32,255,255,180,
/* 0x1330 */ 129,254,255, 16,  3,  2,128, 82,  4, 20, 64, 56, 37, 20, 64, 56,
/* 0x1340 */  99,  4,  0, 81,159,  0,  5,107,  1,255,255, 84, 99,255,255, 53,
/* 0x1350 */   1,  0,128,210,168,  0,128, 82,  1,  0,  0,212,224, 15, 29,248,
/* 0x1360 */   1,  0,  0, 16,246,  3,  1,170, 32, 68, 64,184,214, 66, 32,203,
/* 0x1370 */ 246, 19,  0,249,244,  3,  1,170, 32, 68, 64,184,148, 66, 32,203,
/* 0x1380 */  21, 32,  0,209,173,255,255,151,102,105,108,101, 32,102,111,114,
/* 0x1390 */ 109, 97,116, 32,101,108,102, 54, 52, 45,108,105,116,116,108,101,
/* 0x13a0 */  97, 97,114, 99,104, 54, 52, 10, 10, 83,101, 99,116,105,111,110,
/* 0x13b0 */ 115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32, 32, 32, 32,
/* 0x13c0 */  32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32, 32, 32, 86,
/* 0x13d0 */  77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x13e0 */  32, 76, 77, 65, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x13f0 */  32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32, 65,108,103,
/* 0x1400 */ 110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32, 77, 65, 67,
/* 0x1410 */  72, 77, 65, 73, 78, 88, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1420 */  48, 48, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1430 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1440 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,
/* 0x1450 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1460 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1470 */  76, 89, 10, 32, 32, 49, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32,
/* 0x1480 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1490 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x14a0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x14b0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32, 50, 42, 42,
/* 0x14c0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x14d0 */  68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 78, 82, 86, 50, 69, 32,
/* 0x14e0 */  32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49, 50, 56,
/* 0x14f0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1500 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1510 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 56, 32, 32,
/* 0x1520 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1530 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 51, 32, 78, 82, 86,
/* 0x1540 */  50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1550 */  49, 49, 99, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1560 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1570 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49, 55,
/* 0x1580 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1590 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32,
/* 0x15a0 */  78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x15b0 */  48, 48, 48, 48,102, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x15c0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x15d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x15e0 */  48, 50, 56, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x15f0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1600 */  32, 53, 32, 78, 82, 86, 95, 84, 65, 73, 76, 32, 32, 32, 32, 32,
/* 0x1610 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1620 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1630 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1640 */  48, 48, 48, 48, 51, 55, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1650 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1660 */  89, 10, 32, 32, 54, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x1670 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 98, 56, 32, 32, 48, 48,
/* 0x1680 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1690 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16a0 */  32, 32, 48, 48, 48, 48, 48, 51, 55, 99, 32, 32, 50, 42, 42, 48,
/* 0x16b0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x16c0 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32,
/* 0x16d0 */  76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 48,
/* 0x16e0 */  48, 48, 48, 57, 54, 56, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x16f0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1700 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1710 */  48, 52, 51, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x1720 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1730 */  32, 56, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32,
/* 0x1740 */  32, 48, 48, 48, 48, 48, 52, 57, 99, 32, 32, 48, 48, 48, 48, 48,
/* 0x1750 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1760 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1770 */  48, 48, 48, 48,100, 57, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1780 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x1790 */  89, 10, 32, 32, 57, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x17a0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x17b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x17c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x17d0 */  32, 32, 48, 48, 48, 48, 49, 50, 51, 56, 32, 32, 50, 42, 42, 48,
/* 0x17e0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x17f0 */  79, 78, 76, 89, 10, 32, 49, 48, 32, 77, 65, 67, 72, 77, 65, 73,
/* 0x1800 */  78, 89, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1810 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1820 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1830 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 50, 51, 56, 32, 32, 50,
/* 0x1840 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1850 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 77, 65, 67, 72,
/* 0x1860 */  77, 65, 73, 78, 90, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 49,
/* 0x1870 */  53, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1880 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1890 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 50, 51, 56,
/* 0x18a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x18b0 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x18c0 */  89, 10, 83, 89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10,
/* 0x18d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x18e0 */  32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x18f0 */  67, 51, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1900 */  48, 48, 48, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10,
/* 0x1910 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1920 */  32,108, 32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73,
/* 0x1930 */  78, 90,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1940 */  48, 48, 48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 90, 10, 48, 48,
/* 0x1950 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1960 */  32, 32, 32, 32,100, 32, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88,
/* 0x1970 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1980 */  48, 32, 77, 65, 67, 72, 77, 65, 73, 78, 88, 10, 48, 48, 48, 48,
/* 0x1990 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x19a0 */  32, 32,100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48,
/* 0x19b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78,
/* 0x19c0 */  82, 86, 95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x19d0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x19e0 */  32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48, 48,
/* 0x1a00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x1a10 */  32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50, 68,  9, 48, 48, 48,
/* 0x1a20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82,
/* 0x1a30 */  86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a40 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86,
/* 0x1a50 */  50, 66,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 48, 48, 32, 78, 82, 86, 50, 66, 10, 48, 48, 48, 48, 48, 48,
/* 0x1a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x1a80 */ 100, 32, 32, 78, 82, 86, 95, 84, 65, 73, 76,  9, 48, 48, 48, 48,
/* 0x1a90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x1aa0 */  95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x1ac0 */  90, 77, 65, 95, 69, 76, 70, 48, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x1ad0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x1ae0 */  69, 76, 70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1af0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x1b00 */  90, 77, 65, 95, 68, 69, 67, 50, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x1b10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x1b20 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76,
/* 0x1b40 */  90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48, 48,
/* 0x1b50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76, 90, 77, 65, 95,
/* 0x1b60 */  68, 69, 67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b70 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 77,
/* 0x1b80 */  65, 67, 72, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 77, 65, 67, 72, 77, 65,
/* 0x1ba0 */  73, 78, 89, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bb0 */  48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32, 77, 65, 67,
/* 0x1bc0 */  72, 77, 65, 73, 78, 88,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bd0 */  48, 48, 48, 48, 48, 48, 48, 32, 95,115,116, 97,114,116, 10, 48,
/* 0x1be0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1bf0 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 69,  9, 48, 48,
/* 0x1c00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 50, 56, 32,117,
/* 0x1c10 */  99,108, 95,110,114,118, 50,101, 95,100,101, 99,111,109,112,114,
/* 0x1c20 */ 101,115,115, 95, 51, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c30 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 70, 32,
/* 0x1c40 */  78, 82, 86, 50, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c50 */  48, 48, 48, 49, 49, 99, 32,117, 99,108, 95,110,114,118, 50,100,
/* 0x1c60 */  95,100,101, 99,111,109,112,114,101,115,115, 95, 51, 50, 10, 48,
/* 0x1c70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1c80 */ 103, 32, 32, 32, 32, 32, 70, 32, 78, 82, 86, 50, 66,  9, 48, 48,
/* 0x1c90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,102, 48, 32,117,
/* 0x1ca0 */  99,108, 95,110,114,118, 50, 98, 95,100,101, 99,111,109,112,114,
/* 0x1cb0 */ 101,115,115, 95, 51, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cc0 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1cd0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48,  9, 48, 48, 48, 48, 48,
/* 0x1ce0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,122,109, 97,
/* 0x1cf0 */  68,101, 99,111,100,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d00 */  48, 48, 48, 48, 48, 48, 48, 32,103, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d10 */  77, 65, 67, 72, 77, 65, 73, 78, 89,  9, 48, 48, 48, 48, 48, 48,
/* 0x1d20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,101,110,100, 95,100,
/* 0x1d30 */ 101, 99,111,109,112,114,101,115,115, 10, 10, 82, 69, 76, 79, 67,
/* 0x1d40 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x1d50 */  82, 32, 91, 77, 65, 67, 72, 77, 65, 73, 78, 88, 93, 58, 10, 79,
/* 0x1d60 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d70 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1d80 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d90 */  48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 65, 82, 67, 72,
/* 0x1da0 */  54, 52, 95, 67, 65, 76, 76, 50, 54, 32, 32, 77, 65, 67, 72, 77,
/* 0x1db0 */  65, 73, 78, 90, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1dc0 */  48, 48, 48, 48, 48,100, 99, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x1dd0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x1de0 */  91, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 93, 58, 10, 79, 70,
/* 0x1df0 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x1e00 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x1e10 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e20 */  48, 48, 48, 48, 48, 48, 52, 32, 82, 95, 65, 65, 82, 67, 72, 54,
/* 0x1e30 */  52, 95, 67, 79, 78, 68, 66, 82, 49, 57, 32, 32, 76, 90, 77, 65,
/* 0x1e40 */  95, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x1e50 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x1e60 */  77, 65, 67, 72, 77, 65, 73, 78, 90, 93, 58, 10, 79, 70, 70, 83,
/* 0x1e70 */  69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80,
/* 0x1e80 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x1e90 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ea0 */  48, 48, 49, 50, 56, 32, 82, 95, 65, 65, 82, 67, 72, 54, 52, 95,
/* 0x1eb0 */  65, 68, 82, 95, 80, 82, 69, 76, 95, 76, 79, 50, 49, 32, 32, 95,
/* 0x1ec0 */ 115,116, 97,114,116, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 48, 48, 48, 48, 48, 56, 10
};
