/*
 *   DIS/x : An implementation of the IEEE 1278.1 protocol
 *
 *   Copyright (C) 1996, Riley Rainey (rainey@netcom.com)
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of either:
 *
 *   a) the GNU Library General Public License as published by the Free
 *   Software Foundation; either version 2 of the License, or (at your
 *   option) any later version.  A description of the terms and conditions
 *   of the GLPL may be found in the "COPYING.LIB" file.
 *
 *   b) the "Artistic License" which comes with this Kit.  Information
 *   about this license may be found in the "Artistic" file.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Library General Public License or the Artistic License for more details.
 *
 *   You should have received a copy of the GNU Library General Public
 *   License along with this library; if not, write to the Free
 *   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *   Information describing how to contact the author can be found in the
 *   README file.
 */

#define datum_IMPORT
#include "datum.h"
#undef datum_IMPORT

typedef struct {
	datum_Type id;
	char     *name;
} datum_info;

/*
 * This list was originally generated with
 *
 *   $ perl datumtbl.pl < datum.h > datumtbl.h
 *
 * FIXME: restore automatic generation from datumtbl.h [2017-03-26 Umberto Salsi]
 */
static datum_info lookup[] =  {
	{ 10000, "Identification" },
	{ 11000, "Entity Type" },
	{ 11100, "Concatenated" },
	{ 11110, "Kind" },
	{ 11120, "Domain" },
	{ 11130, "Country" },
	{ 11140, "Category" },
	{ 11150, "Subcategory" },
	{ 11160, "Specific" },
	{ 11170, "Extra" },
	{ 11200, "Force ID" },
	{ 11300, "Description" },
	{ 12000, "Alternative Entity Type" },
	{ 12110, "Alternate Kind" },
	{ 12120, "Alternate Domain" },
	{ 12130, "Alternate Country" },
	{ 12140, "Alternate Category" },
	{ 12150, "Alternate Subcategory" },
	{ 12160, "Alternate Specific" },
	{ 12170, "Alternate Extra" },
	{ 12300, "Alternate Description" },
	{ 13000, "Entity Marking" },
	{ 13100, "Entity Marking Characters" },
	{ 13200, "Crew ID" },
	{ 14000, "Task Organization" },
	{ 14200, "Regiment Name" },
	{ 14300, "Battalion Name" },
	{ 14400, "Company Name" },
	{ 14500, "Platoon Name" },
	{ 14520, "Squad Name" },
	{ 14540, "Team Name" },
	{ 14600, "Bumper Number" },
	{ 14700, "Vehicle Number" },
	{ 14800, "Unit Number" },
	{ 15000, "DIS Identity" },
	{ 15100, "DIS Site ID" },
	{ 15200, "DIS Host ID" },
	{ 15300, "DIS Entity ID" },
	{ 20000, "Loads" },
	{ 21000, "Crew Members" },
	{ 21100, "Crew Member ID" },
	{ 21200, "Health" },
	{ 21300, "Job Assignment" },
	{ 23000, "Fuel" },
	{ 23100, "Quantity" },
	{ 23105, "Quantity Gallons" },
	{ 24000, "Ammunition" },
	{ 24001, "120mm HEAT Quantity" },
	{ 24002, "120mm Sabot Quantity" },
	{ 24003, "127mm M8Quantity" },
	{ 24004, "127mm M20Quantity" },
	{ 24005, "762mm M62Quantity" },
	{ 24006, "M250 U K L8 A1Quantity" },
	{ 24007, "M250 U K L8 A3Quantity" },
	{ 24008, "762mm M80Quantity" },
	{ 24009, "12mm Quantity" },
	{ 24010, "76mm Quantity" },
	{ 24060, "MinesQuantity" },
	{ 24100, "Ammunition Type" },
	{ 24110, "Ammunition Kind" },
	{ 24120, "Ammunition Domain" },
	{ 24130, "Ammunition Country" },
	{ 24140, "Ammunition Category" },
	{ 24150, "Ammunition Subcategory" },
	{ 24160, "Ammunition Extra" },
	{ 24300, "Ammunition Description" },
	{ 25000, "Cargo" },
	{ 26000, "Vehicle Mass" },
	{ 27000, "Supply Quantity" },
	{ 28000, "Armament" },
	{ 30000, "Status" },
	{ 31000, "Position" },
	{ 31100, "Mil Grid10" },
	{ 31200, "Geocentric Coordinates" },
	{ 31210, "Geocentric Coordinates X" },
	{ 31220, "Geocentric Coordinates Y" },
	{ 31230, "Geocentric Coordinates Z" },
	{ 31300, "Latitude" },
	{ 31400, "Longitude" },
	{ 32000, "Orientation" },
	{ 32100, "Hull Heading Angle" },
	{ 32200, "Hull Pitch Angle" },
	{ 32300, "Roll Angle" },
	{ 32500, "Orientation X" },
	{ 32600, "Orientation Y" },
	{ 32700, "Orientation Z" },
	{ 33000, "Appearance" },
	{ 33100, "Ambient Lighting" },
	{ 33101, "Lights" },
	{ 33200, "Paint Scheme" },
	{ 33300, "Smoke" },
	{ 33400, "Trailing Effects" },
	{ 33500, "Flaming" },
	{ 33600, "Marking" },
	{ 33710, "Mine Plows Attached" },
	{ 33720, "Mine Rollers Attached" },
	{ 33730, "Tank Turret Azimuth" },
	{ 34000, "Failuresand Malfunctions" },
	{ 34100, "Age" },
	{ 34110, "Kilometers" },
	{ 35000, "Damage" },
	{ 35050, "Cause" },
	{ 35100, "Mobility Kill" },
	{ 35200, "Fire_ Power Kill" },
	{ 35300, "Personnel Casualties" },
	{ 36000, "Velocity" },
	{ 36100, "X Velocity" },
	{ 36200, "Y Velocity" },
	{ 36300, "Z Velocity" },
	{ 37000, "Acceleration" },
	{ 37100, "X Acceleration" },
	{ 37200, "Y Acceleration" },
	{ 37300, "Z Acceleration" },
	{ 38100, "Engine Status" },
	{ 40000, "Exercise" },
	{ 41000, "Terrain Database" },
	{ 42000, "Missions" },
	{ 42100, "Mission ID" },
	{ 42200, "Mission Type" },
	{ 42300, "Mission Request Time Stamp" },
	{ 43000, "Exercise Description" },
	{ 43100, "Name" },
	{ 43200, "Entities" },
	{ 43300, "Version" },
	{ 50000, "Environment" },
	{ 51000, "Weather" },
	{ 51100, "Thermal Condition" },
	{ 52000, "Time" },
	{ 52100, "Timeof Day Discrete" },
	{ 52200, "Timeof Day Continuous" },
	{ 52300, "Time Mode" },
	{ 52305, "Time Scene" },
	{ 52310, "Current Hour" },
	{ 52320, "Current Minute" },
	{ 52330, "Current Second" },
	{ 52340, "Azimuth" },
	{ 52350, "Maximum Elevation" },
	{ 52360, "Time Zone" },
	{ 52400, "Time Sunrise Enabled" },
	{ 52410, "Sunrise Hour" },
	{ 52420, "Sunrise Minute" },
	{ 52430, "Sunrise Second" },
	{ 52440, "Sunrise Azimuth" },
	{ 52500, "Time Sunset Enabled" },
	{ 52510, "Sunset Hour" },
	{ 52520, "Sunset Minute" },
	{ 52530, "Sunset Second" },
	{ 52600, "Date" },
	{ 52610, "Month" },
	{ 52620, "Day" },
	{ 52630, "Year" },
	{ 53000, "Clouds" },
	{ 53050, "Cloud Layer Enable" },
	{ 53060, "Cloud Layer Selection" },
	{ 53100, "Cloud Visibility" },
	{ 53200, "Cloud Base Altitude" },
	{ 53250, "Cloud Base Altitude Feet" },
	{ 53300, "Cloud Ceiling" },
	{ 53350, "cloud Ceiling Feet" },
	{ 53400, "Characteristics" },
	{ 54000, "Precipitation" },
	{ 54100, "Rain" },
	{ 55000, "Fog" },
	{ 55100, "Visibility" },
	{ 55105, "Visibility Miles" },
	{ 55200, "Density" },
	{ 55300, "Base" },
	{ 55401, "View Layer From Above" },
	{ 55410, "Transition Range" },
	{ 55420, "Bottom" },
	{ 55425, "Bottom Feet" },
	{ 55430, "Ceiling" },
	{ 55435, "Ceiling Feet" },
	{ 56000, "Heavenly Bodies" },
	{ 56100, "Sun" },
	{ 56110, "Sun Position" },
	{ 56120, "Sun Position Azimuth" },
	{ 56130, "Sun Position Elevation" },
	{ 56140, "Sun Position Intensity" },
	{ 56200, "Moon" },
	{ 56210, "Moon Position" },
	{ 56220, "Moon Position Azimuth" },
	{ 56230, "Moon Position Elevation" },
	{ 56240, "Moon Position Intensity" },
	{ 56310, "Horizon" },
	{ 56320, "Horizon Azimuth" },
	{ 56330, "Horizon Elevation" },
	{ 56340, "Horizon Heading" },
	{ 56350, "Horizon Intensity" },
	{ 57000, "Meteorological" },
	{ 57100, "Meteorological Temperature" },
	{ 57200, "Meteorological Humidity" },
	{ 57300, "Meteorological Visibility" },
	{ 57400, "Meteorological Winds" },
	{ 57410, "Meteorological Speed" },
	{ 57500, "Meteorological Rainsoak" },
	{ 58000, "Haze" },
	{ 58100, "Haze Visibility" },
	{ 58105, "Haze Visibility Miles" },
	{ 58200, "Haze Density" },
	{ 58430, "Haze Ceiling" },
	{ 58435, "Haze Ceiling Feet" },
	{ 60000, "Communications" },
	{ 61100, "Channel Type" },
	{ 61101, "Channel Type1" },
	{ 61200, "Channel Identification" },
	{ 61300, "Alpha Identification" },
	{ 61400, "Radio Identification" },
	{ 61500, "Land Line Identification" },
	{ 61600, "Intercom Identification" },
	{ 61700, "Group Network Channel Number" },
	{ 62100, "Radio Communications Status" },
	{ 62200, "Stationary Radio Transmitters Default Time" },
	{ 62300, "Moving Radio Transmitters Default Time" },
	{ 62400, "Stationary Radio Signals Default Time" },
	{ 62500, "Moving Radio Signal Default Time" },
	{ 63101, "Radio Init Transec Security Key" },
	{ 63102, "Radio Init Internal Noise Level" },
	{ 63103, "Radio Init Squelch Threshold" },
	{ 63104, "Radio Init Antenna Location" },
	{ 63105, "Radio Init Antenna Pattern Type" },
	{ 63106, "Radio Init Antenna Pattern Length" },
	{ 63107, "Radio Init Beam Definition" },
	{ 63108, "Radio Init Transmit Heartbeat Time" },
	{ 63109, "Radio Init Transmit Distance Threshold" },
	{ 63110, "Radio Channel Init Lockout ID" },
	{ 63111, "Radio Channel Init Hopset ID" },
	{ 63112, "Radio Channel Init Preset Frequency" },
	{ 63113, "Radio Channel Init Frequency Sync Time" },
	{ 63114, "Radio Channel Init Comsec Key" },
	{ 63115, "Radio Channel Init Alpha" },
	{ 70000, "Algorithm Parameters" },
	{ 71000, "Dead Reckoning Algorithm" },
	{ 71100, "D R A Location Threshold" },
	{ 71200, "D R A Orientation Threshold" },
	{ 71300, "D R A Time Threshold" },
	{ 72000, "Simulation Management Parameters" },
	{ 72100, "Checkpoint Interval" },
	{ 72600, "Transmitter Time Threshold" },
	{ 72700, "Receiver Time Threshold" },
	{ 73000, "Interoperability Mode" },
	{ 74000, "S I M N E T Data Collection" },
	{ 75000, "Event ID" },
	{ 75100, "Source Site ID" },
	{ 75200, "Source Host ID" },
	{ 90000, "Articulated Part" },
	{ 90050, "Articulated Part ID" },
	{ 90070, "Articulated Part Index" },
	{ 90100, "Articulated Part Position" },
	{ 90200, "Articulated Part Position Rate" },
	{ 90300, "Articulated Part Extension" },
	{ 90400, "Articulated Part Extension Rate" },
	{ 90500, "Articulated Part X" },
	{ 90600, "Articulated Part X Rate" },
	{ 90700, "Articulated Part Y" },
	{ 90800, "Articulated Part Y Rate" },
	{ 90900, "Articulated Part Z" },
	{ 91000, "Articulated Part Z Rate" },
	{ 91100, "Articulated Part Azimuth" },
	{ 91200, "Articulated Part Azimuth Rate" },
	{ 91300, "Articulated Part Elevation" },
	{ 91400, "Articulated Part Elevation Rate" },
	{ 91500, "Articulated Part Rotation" },
	{ 91600, "Articulated Part Rotation Rate" },
	{ 100001, "D R A Angular X Velocity" },
	{ 100002, "D R A Angular Y Velocity" },
	{ 100003, "D R A Angular Z Velocity" },
	{ 100004, "Appearance Trailing Effects" },
	{ 100005, "Appearance Hatch" },
	{ 100008, "Appearance Character Set" },
	{ 100010, "Capability Ammunition Supplier" },
	{ 100011, "Capability Miscellaneous Supplier" },
	{ 100012, "Capability Repair Provider" },
	{ 100014, "Articulation Parameter" },
	{ 100047, "Articulation Parameter Type" },
	{ 100048, "Articulation Parameter Value" },
	{ 100058, "Timeof Day Scene" },
};


char * datum_lookupDatumIDName(datum_Type id)
{
	int i;

	for (i = 0; lookup[i].id != 0; ++i) {
		if (lookup[i].id == id) {
			return lookup[i].name;
		}
	}
	return (char *) 0;
}


/*
dis_variable_datum *
DISCreateVariableDatumString(datum_Type id, char *s, int str_len)
{
	dis_variable_datum *p;
	int       len = ((str_len + 7) / 8) * 8;

	p = (dis_variable_datum *)
		memory_allocate(sizeof(dis_variable_datum) + len, NULL);

	if (!p) {
		return p;
	}

	p->datum_id = id;
	p->value_length = str_len * 8;
	p->value.ptr_value = (unsigned char *) (p + 1);

	memset(p->value.ptr_value, 0, len);
	memcpy(p->value.ptr_value, s, str_len);
	return p;
}
*/