/*
Copyright (©) 2003-2025 Teus Benschop.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/


#include <stylesv2/logic.h>


namespace stylesv2 { // Todo styles version 2 logic.


const std::list<Style> styles {
  {
    .marker = "id",
    .type = Type::book_id,
    .name = "Identification",
    .info = "File identification information (name of file, book name, language, last edited, date, etc.)",
    .capabilities = {Capability::starts_new_page},
    .parameters = {},
    .implemented = false,
  },
};






} // Namespace.


// Here below are the styles These are the old ones, to be moved to the new system.
//typedef struct
//{
//  const char * marker;
//  std::string name;
//  std::string info;
//  const char * category;
//  int type;
//  int subtype;
//  float fontsize;
//  int italic;
//  int bold;
//  int underline;
//  int smallcaps;
//  int superscript;
//  int justification;
//  float spacebefore;
//  float spaceafter;
//  float leftmargin;
//  float rightmargin;
//  float firstlineindent;
//  int spancolumns;
//  const char * color;
//  bool print;
//  bool userbool1;
//  bool userbool2;
//  bool userbool3;
//  int userint1;
//  int userint2;
//  int userint3;
//  const char * userstring1;
//  const char * userstring2;
//  const char * userstring3;
//  const char * backgroundcolor;
//}
//style_record;
//
//
//// Default stylesheet values.
//// In English.
//style_record styles_table [] =
//{
//  {
//    /* marker */ "add",
//    /* name */ "Translator’s addition",
//    /* info */ "A translator’s explanation - words added by the translator for clarity – text which is not literally a part of the original language, but which was supplied to make the meaning of the original clear.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "addpn",
//    /* name */ "Combined add and pn style",
//    /* info */ "Support for overlapping pn ...pn* and add ...add* occurrences. Deprecated.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "b",
//    /* name */ "Blank line",
//    /* info */ "May be used to explicitly indicate additional white space between paragraphs. Poetry text stanza break.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "bd",
//    /* name */ "Bold text",
//    /* info */ "Bold text",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "bdit",
//    /* name */ "Bold-italic text",
//    /* info */ "A character style, use bold + italic text",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "bk",
//    /* name */ "Quoted book title",
//    /* info */ "For the quoted name of a book",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "c",
//    /* name */ "Chapter number",
//    /* info */ "Chapter number",
//    /* category */ "cv",
//    /* type */ 5,
//    /* subtype */ 0,
//    /* fontsize */ 18,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 1,
//    /* userbool2 */ 1,
//    /* userbool3 */ 1,
//    /* userint1 */ 90,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ca",
//    /* name */ "Alternate chapter number",
//    /* info */ "Second or alternate chapter number. For coding dual versification. Useful for places where different traditions of chapter breaks need to be supported in the same translation. Bibledit does nothing with this marker yet.",
//    /* category */ "cv",
//    /* type */ 0,
//    /* subtype */ 4,
//    /* fontsize */ 16,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 20,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "cat",
//    /* name */ "Category tag",
//    /* info */ "Extended note or sidebar category tag.",
//    /* category */ "id",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "cd",
//    /* name */ "Chapter description",
//    /* info */ "Chapter description",
//    /* category */ "cv",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 11,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "cl",
//    /* name */ "Chapter label",
//    /* info */ "Chapter label used for translations that add a word such as 'Chapter' before chapter numbers, e.g. Psalms.",
//    /* category */ "cv",
//    /* type */ 0,
//    /* subtype */ 7,
//    /* fontsize */ 18,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "cls",
//    /* name */ "Closure of an epistle",
//    /* info */ "Closure of an epistle",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "cp",
//    /* name */ "Published chapter character",
//    /* info */ "Published chapter number. This is a chapter marking that would be used in the published text.",
//    /* category */ "cv",
//    /* type */ 0,
//    /* subtype */ 8,
//    /* fontsize */ 18,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "d",
//    /* name */ "Descriptive title or Hebrew subtitle",
//    /* info */ "A Hebrew text heading, to provide description, e.g. Psalms",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 4,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "dc",
//    /* name */ "Deuterocanonical",
//    /* info */ "Deuterocanonical / LXX additions or insertions in the Protocanonical text",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ef",
//    /* name */ "Extended footnote",
//    /* info */ "Extended footnote element.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 2,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "em",
//    /* name */ "Emphasized text",
//    /* info */ "A character style, use emphasized text style.",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "esb",
//    /* name */ "Sidebar start",
//    /* info */ "Beginning or opening of the sidebar content section",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "esbe",
//    /* name */ "Sidebar end",
//    /* info */ "End or closing of the sidebar content section",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ex",
//    /* name */ "Extended cross reference",
//    /* info */ "Extended cross reference element.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 2,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "f",
//    /* name */ "Footnote",
//    /* info */ "A footnote text item.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 2,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fdc",
//    /* name */ "Footnote Deuterocanonical content",
//    /* info */ "Text between these markers is material to be included only in published editions that contain the Deuterocanonical books. Deprecated.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 4,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 1,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fe",
//    /* name */ "Endnote",
//    /* info */ "An endnote text item.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "zendnotes",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fig",
//    /* name */ "Figure / illustration / map",
//    /* info */ "Illustration [columns to span, height, filename, caption text]",
//    /* category */ "sf",
//    /* type */ 10,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fk",
//    /* name */ "Footnote keyword",
//    /* info */ "The specific keyword or term from the text for which the footnote is being provided.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fl",
//    /* name */ "Footnote label text",
//    /* info */ "Can be used for marking or “labeling” a word or words which are used consistently across certain types of translation notes, such as the words 'Or' in an alternative translation note, 'Others', 'Heb.', 'LXX' etc.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fm",
//    /* name */ "Footnote reference mark",
//    /* info */ "An additional footnote marker location for a previous footnote.",
//    /* category */ "f",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fp",
//    /* name */ "Footnote additional paragraph",
//    /* info */ "Use this marker to if you need to indicate the start of a new paragraph within a footnote.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 5,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 3,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fq",
//    /* name */ "Footnote translation quotation",
//    /* info */ "A quotation from the current scripture text translation for which the note is being provided.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fqa",
//    /* name */ "Footnote alternate translation",
//    /* info */ "Used to distinguish between a quotation of the current scripture text translation, and an alternate translation.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fr",
//    /* name */ "Footnote origin reference",
//    /* info */ "This is the chapter and verse or verses that note refers to.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ft",
//    /* name */ "Footnote text",
//    /* info */ "The essential or explanatory text of the footnote.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 4,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -4,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "fv",
//    /* name */ "Footnote verse number",
//    /* info */ "A verse number within the footnote text.",
//    /* category */ "f",
//    /* type */ 7,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "h",
//    /* name */ "Running header",
//    /* info */ "Running header text for a book",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 1,
//    /* userbool3 */ 1,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "h1",
//    /* name */ "Deprecated running header",
//    /* info */ "Deprecated running header text",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 1,
//    /* userbool3 */ 1,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "h2",
//    /* name */ "Deprecated left running header",
//    /* info */ "Deprecated running header text, left side of page",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 1,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "h3",
//    /* name */ "Deprecated right running header",
//    /* info */ "Deprecated running header text, right side of page",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 1,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ib",
//    /* name */ "Introduction blank line",
//    /* info */ "May be used to explicitly indicate additional white space between paragraphs.",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ide",
//    /* name */ "Encoding",
//    /* info */ "File encoding information. Bibledit disregards this marker, as all text in Bibledit is in UTF-8 encoding.",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "",
//  },
//  {
//    /* marker */ "ie",
//    /* name */ "Introduction end",
//    /* info */ "Optionally included to explicitly indicate the end of the introduction material",
//    /* category */ "ioe",
//    /* type */ 0,
//    /* subtype */ 0,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iex",
//    /* name */ "Explanatory or bridge text",
//    /* info */ "Introduction explanatory or bridge text, e.g. explanation of missing book in Short Old Testament)",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 4,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ili",
//    /* name */ "Introduction list item",
//    /* info */ "A list entry, level 1, if single level",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ili1",
//    /* name */ "Introduction list item level 1",
//    /* info */ "A list entry, level 1, if multiple levels",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ili2",
//    /* name */ "Introduction list item level 2",
//    /* info */ "A list entry, level 2",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 19.1f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "im",
//    /* name */ "Introduction flush left paragraph",
//    /* info */ "Introduction prose paragraph, with no first line indent. May occur after poetry).",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imi",
//    /* name */ "Indented introduction flush left paragraph",
//    /* info */ "Introduction prose paragraph text, indented, with no first line indent",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imq",
//    /* name */ "Introduction flush left quote from text paragraph",
//    /* info */ "Introduction prose paragraph, quote from the body text, with no first line indent",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imt",
//    /* name */ "Introduction major title level 1",
//    /* info */ "Introduction major title, level 1, if single level",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imt1",
//    /* name */ "Introduction major title level 1",
//    /* info */ "Introduction major title, level 1, if multiple levels",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imt2",
//    /* name */ "Introduction major title level 2",
//    /* info */ "Introduction major title, level 2",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 13,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 6,
//    /* spaceafter */ 3,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imt3",
//    /* name */ "Introduction major title level 3",
//    /* info */ "Introduction major title, level 3",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 2,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imt4",
//    /* name */ "Introduction major title level 4",
//    /* info */ "Introduction major title, level 4.",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 2,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imte",
//    /* name */ "Introduction major title ending",
//    /* info */ "Used to mark a major title indicating the end of the introduction",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imte1",
//    /* name */ "Introduction major title ending level 1",
//    /* info */ "Used to mark a major title indicating the end of the introduction",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "imte2",
//    /* name */ "Introduction major title ending level 2",
//    /* info */ "Used to mark a major title indicating the end of the introduction",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 16,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "io",
//    /* name */ "Introduction outline entry",
//    /* info */ "Introduction outline text, level 1, if single level",
//    /* category */ "ioe",
//    /* type */ 3,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "io1",
//    /* name */ "Introduction outline entry Level 1",
//    /* info */ "Introduction outline text, level 1, if multiple levels",
//    /* category */ "ioe",
//    /* type */ 3,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "io2",
//    /* name */ "Introduction outline entry Level 2",
//    /* info */ "Introduction outline text, level 2",
//    /* category */ "ioe",
//    /* type */ 3,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 19.1f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "io3",
//    /* name */ "Introduction outline entry level 3",
//    /* info */ "Introduction outline text, level 3",
//    /* category */ "ioe",
//    /* type */ 3,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "io4",
//    /* name */ "Introduction outline entry level 4",
//    /* info */ "Introduction outline text, level 4",
//    /* category */ "ioe",
//    /* type */ 3,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 31.8f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ior",
//    /* name */ "Introduction outline reference range",
//    /* info */ "Introduction references range for outline entry; for marking references separately",
//    /* category */ "ioe",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iot",
//    /* name */ "Introduction outline title",
//    /* info */ "Introduction outline title",
//    /* category */ "ioe",
//    /* type */ 3,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ip",
//    /* name */ "Introduction paragraph",
//    /* info */ "Introduction prose paragraph",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ipi",
//    /* name */ "Indented introduction paragraph",
//    /* info */ "Introduction prose paragraph, with first line indent",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ipq",
//    /* name */ "Introduction quote from text paragraph",
//    /* info */ "Introduction prose paragraph, quote from the body text",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ipr",
//    /* name */ "Introduction right-aligned paragraph",
//    /* info */ "Introduction prose paragraph, right aligned",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iq",
//    /* name */ "Introduction poetic line",
//    /* info */ "Introduction poetry text, level 1, if single level",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -19.1f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iq1",
//    /* name */ "Introduction poetic line Level 1",
//    /* info */ "Introduction poetry text, level 1, if multiple levels",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -19.1f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iq2",
//    /* name */ "Introduction poetic line level 2",
//    /* info */ "Introduction poetry text, level 2",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -12.7f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iq3",
//    /* name */ "Introduction poetic line level 3",
//    /* info */ "Introduction poetry text, level 3",
//    /* category */ "ipp",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -6.4f,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "iqt",
//    /* name */ "Introduction quoted text",
//    /* info */ "Scripture quotations, or other quoted text, appearing in the introduction",
//    /* category */ "ioe",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "is",
//    /* name */ "Introduction section heading level 1",
//    /* info */ "Introduction section heading, level 1, if single level",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "is1",
//    /* name */ "Introduction section heading level 1",
//    /* info */ "Introduction section heading, level 1, if multiple levels",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "is2",
//    /* name */ "Introduction section heading level 2",
//    /* info */ "Introduction section heading, level 2",
//    /* category */ "ith",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "it",
//    /* name */ "Italic text",
//    /* info */ "A character style, use italic text",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "jmp",
//    /* name */ "Link text",
//    /* info */ "Optionally used for associating linking attributes to a span of text when no other character level markup is applied to the same span.",
//    /* category */ "sf",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 2,
//    /* bold */ 2,
//    /* underline */ 1,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#0000FF",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "k",
//    /* name */ "Keyword",
//    /* info */ "Keyword / keyterm",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lf",
//    /* name */ "List footer",
//    /* info */ "Some lists include an introductory and concluding remark. They are an integral part of the list content, but are not list items. A list does not require either or both of these elements.",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 10,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lh",
//    /* name */ "List header",
//    /* info */ "Some lists include an introductory and concluding remark. They are an integral part of the list content, but are not list items. A list does not require either or both of these elements.",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "li",
//    /* name */ "List entry",
//    /* info */ "A list entry, level 1, if single level",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "li1",
//    /* name */ "List entry level 1",
//    /* info */ "A list entry, level 1, if multiple levels",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "li2",
//    /* name */ "List entry level 2",
//    /* info */ "A list entry, level 2",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 19.1f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "li3",
//    /* name */ "List entry level 3",
//    /* info */ "A list entry, level 3",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "li4",
//    /* name */ "List entry level 4",
//    /* info */ "A list entry, level 4",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 31.8f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lik",
//    /* name */ "List entry 'key' content",
//    /* info */ "The 'key' content will be followed by 'value' content",
//    /* category */ "l",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lim",
//    /* name */ "Embedded list entry",
//    /* info */ "An out-dented paragraph meant to highlight the items of an embedded list",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 19.1f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lim1",
//    /* name */ "Embedded list entry level 1",
//    /* info */ "An out-dented paragraph meant to highlight the items of an embedded list, level 1",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 19.1f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ -9.5f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lim2",
//    /* name */ "Embedded list entry level 2",
//    /* info */ "An out-dented paragraph meant to highlight the items of an embedded list, level 2",
//    /* category */ "l",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -9.5,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "lit",
//    /* name */ "Liturgical note",
//    /* info */ "A guide which tells the reader or worshipper that he should recite a prayer or recitation etc.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "litl",
//    /* name */ "List entry total",
//    /* info */ "Use in accounting lists for denoting the total component of the text within a list item",
//    /* category */ "l",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "liv",
//    /* name */ "List entry 'value' content",
//    /* info */ "The 'value' content follows the 'key' content",
//    /* category */ "l",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "liv1",
//    /* name */ "List entry 'value' content level 1",
//    /* info */ "The 'value' content follows the 'key' content, level 1",
//    /* category */ "l",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "m",
//    /* name */ "Continuation paragraph",
//    /* info */ "Paragraph text, with no first line indent",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mi",
//    /* name */ "Indented flush left paragraph",
//    /* info */ "Paragraph text, indented, with no first line indent, often used for discourse.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mr",
//    /* name */ "Major section reference range",
//    /* info */ "The text reference range listed under a major section heading",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ms",
//    /* name */ "Major section heading",
//    /* info */ "A major section division heading, level 1, if single level",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 16,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ms1",
//    /* name */ "Major section heading level 1",
//    /* info */ "A major section division heading, level 1, if multiple levels",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 16,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ms2",
//    /* name */ "Major section heading level 2",
//    /* info */ "A major section division heading, level 2",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 14,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 16,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mt",
//    /* name */ "Major title",
//    /* info */ "The main title of the book, if single level",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mt1",
//    /* name */ "Major title level 1",
//    /* info */ "The main title of the book, if multiple levels",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 2,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mt2",
//    /* name */ "Major title level 2",
//    /* info */ "A secondary title with less important information than the main title.",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 16,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mt3",
//    /* name */ "Major title level 3",
//    /* info */ "A secondary title, less important than the main title.",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 16,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 2,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mt4",
//    /* name */ "Major title level 4",
//    /* info */ "A small secondary title sometimes occurring within parentheses.",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 2,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mte",
//    /* name */ "Major title at ending",
//    /* info */ "The main title of the book repeated at the end of the book, if single level.",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mte1",
//    /* name */ "Major title at ending level 1",
//    /* info */ "The main title of the book repeated at the end of the book, if multiple levels",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "mte2",
//    /* name */ "Major title at ending level 2",
//    /* info */ "A secondary title occurring before or after the ending main title.",
//    /* category */ "t",
//    /* type */ 3,
//    /* subtype */ 0,
//    /* fontsize */ 16,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 2,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 1,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "nb",
//    /* name */ "No break with previous paragraph",
//    /* info */ "Paragraph text, with no break from previous paragraph text, at chapter boundary.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "nd",
//    /* name */ "Name of God",
//    /* info */ "For name of God",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 1,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ndx",
//    /* name */ "Subject index entry",
//    /* info */ "Surround a word or words with this markup to indicate that it appears or should appear in the subject index.",
//    /* category */ "sf",
//    /* type */ 13,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "no",
//    /* name */ "Normal text",
//    /* info */ "May be used when a larger paragraph element is set in an alternate font style, e.g. italic, and a selected section of text should be displayed in normal text.",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "ord",
//    /* name */ "Ordinal number ending",
//    /* info */ "For the text portion of an ordinal number",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "p",
//    /* name */ "Normal paragraph",
//    /* info */ "Paragraph text, with first line indent",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pb",
//    /* name */ "Page break",
//    /* info */ "Page break used for new reader portions and children's bibles where content is controlled by the page.",
//    /* category */ "sb",
//    /* type */ 11,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pc",
//    /* name */ "Centered paragraph",
//    /* info */ "Paragraph text, centered, for inscription.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pi",
//    /* name */ "Indented paragraph",
//    /* info */ "Paragraph text, level 1 indent, if single level, with first line indent; often used for discourse.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pi1",
//    /* name */ "Indented paragraph level 1",
//    /* info */ "Paragraph text, level 1 indent, if multiple levels, with first line indent; often used for discourse.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pi2",
//    /* name */ "Indented paragraph level 2",
//    /* info */ "Paragraph text, level 2 indent, with first line indent; often used for discourse.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pi3",
//    /* name */ "Indented paragraph level 3",
//    /* info */ "Paragraph text, level 3 indent, with first line indent; often used for discourse.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 19.1f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pm",
//    /* name */ "Embedded text paragraph",
//    /* info */ "Embedded text paragraph.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pmc",
//    /* name */ "Embedded text closing",
//    /* info */ "Embedded text closing.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pmo",
//    /* name */ "Embedded text opening",
//    /* info */ "Embedded text opening.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pmr",
//    /* name */ "Embedded text refrain",
//    /* info */ "Embedded text refrain, e.g. Then all the people shall say, Amen!",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 6.4f,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pn",
//    /* name */ "Proper name",
//    /* info */ "For a proper name.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 1,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "png",
//    /* name */ "Geographic proper name",
//    /* info */ "For a geographic proper name.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 1,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "po",
//    /* name */ "Paragraph opening an epistle",
//    /* info */ "Paragraph opening an epistle or letter, without first line indent.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 4,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 3.2f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "pro",
//    /* name */ "Pronunciation annotation",
//    /* info */ "For indicating pronunciation in CJK texts. Deprecated.",
//    /* category */ "sf",
//    /* type */ 0,
//    /* subtype */ 9,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "q",
//    /* name */ "Poetic line",
//    /* info */ "Poetry text, level 1 indent, if single level.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 31.8f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -25.4f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "q1",
//    /* name */ "Poetic line level 1",
//    /* info */ "Poetry text, level 1 indent, if multiple levels.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 31.8f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -25.4f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "q2",
//    /* name */ "Poetic line level 2",
//    /* info */ "Poetry text, level 2 indent.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 31.8f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -19.1f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "q3",
//    /* name */ "Poetic line level 3",
//    /* info */ "Poetry text, level 3 indent.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 31.8f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -12.7f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qa",
//    /* name */ "Acrostic heading",
//    /* info */ "Poetry text, acrostic marker or heading.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qac",
//    /* name */ "Acrostic letter",
//    /* info */ "Poetry text, acrostic markup of the first character of a line of acrostic poetry.",
//    /* category */ "pe",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qc",
//    /* name */ "Centered poetic line",
//    /* info */ "Poetry text, centered.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qd",
//    /* name */ "Hebrew note",
//    /* info */ "A Hebrew musical performance comment similar in content to many of the Hebrew Psalm titles, but placed at the end of the poetic section.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 6.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qm",
//    /* name */ "Embedded text poetic line",
//    /* info */ "Poetry text, embedded, level 1 indent, if single level.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -19.1f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qm1",
//    /* name */ "Embedded text poetic line level 1",
//    /* info */ "Poetry text, embedded, level 1 indent, if multiple levels.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -19.1f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qm2",
//    /* name */ "Embedded text poetic line level 2",
//    /* info */ "Poetry text, embedded, level 2 indent.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -12.7f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qm3",
//    /* name */ "Embedded text poetic line level 3",
//    /* info */ "Poetry text, embedded, level 3 indent.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 25.4f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -6.4f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qr",
//    /* name */ "Right-aligned poetic line",
//    /* info */ "Commonly used for a poetic refrain.",
//    /* category */ "pe",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qs",
//    /* name */ "Selah",
//    /* info */ "Poetry text, Selah.",
//    /* category */ "pe",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "qt",
//    /* name */ "Quoted text",
//    /* info */ "Old Testament quotations in the New Testament, or other quotations.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "r",
//    /* name */ "Parallel passage references",
//    /* info */ "Parallel references.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "rb",
//    /* name */ "Annotated base text",
//    /* info */ "Used to mark the base text being annotated with ruby characters.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "rem",
//    /* name */ "Remark",
//    /* info */ "Comments and remarks.",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "rq",
//    /* name */ "Inline quotation references",
//    /* info */ "A cross-reference indicating the source text for the preceding quotation.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 10,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "rt",
//    /* name */ "Ruby annotation text",
//    /* info */ "In the case where the annotation text is associated with only a single preceding ideogram, only the 'rt ...rt*' marker is required. The base text markup 'rb ...rb*' is optional in these cases.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "s",
//    /* name */ "Section heading",
//    /* info */ "A section heading, level 1, if single level.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "s1",
//    /* name */ "Section heading level 1",
//    /* info */ "A section heading, level 1, if multiple levels.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "s2",
//    /* name */ "Section heading Level 2",
//    /* info */ "A section heading, level 2.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "s3",
//    /* name */ "Section heading level 3",
//    /* info */ "A section heading, level 3.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 6,
//    /* spaceafter */ 3,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "s4",
//    /* name */ "Section heading level 4",
//    /* info */ "A section heading, level 4.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 6,
//    /* spaceafter */ 3,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sc",
//    /* name */ "Small-cap text",
//    /* info */ "A character style, for small capitalization text.",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 1,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sd",
//    /* name */ "Semantic division",
//    /* info */ "Vertical space used to divide the text into sections, in a manner similar to the structure added through the use of a sequence of heading texts.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 24,
//    /* spaceafter */ 24,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sd1",
//    /* name */ "Semantic division level 1",
//    /* info */ "Vertical space used to divide the text into sections, in a manner similar to the structure added through the use of a sequence of heading texts.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 20,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 24,
//    /* spaceafter */ 24,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sd2",
//    /* name */ "Semantic division level 2",
//    /* info */ "Vertical space used to divide the text into sections, in a manner similar to the structure added through the use of a sequence of heading texts.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 16,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 18,
//    /* spaceafter */ 18,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sd3",
//    /* name */ "Semantic division level 3",
//    /* info */ "Vertical space used to divide the text into sections, in a manner similar to the structure added through the use of a sequence of heading texts.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 16,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 12,
//    /* spaceafter */ 12,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sd4",
//    /* name */ "Semantic division level 4",
//    /* info */ "Vertical space used to divide the text into sections, in a manner similar to the structure added through the use of a sequence of heading texts.",
//    /* category */ "p",
//    /* type */ 3,
//    /* subtype */ 3,
//    /* fontsize */ 16,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 8,
//    /* spaceafter */ 8,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sig",
//    /* name */ "Signature of the author",
//    /* info */ "Signature of the author of a letter or epistle.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sls",
//    /* name */ "Secondary language or text source",
//    /* info */ "Passage of text based on a secondary language or alternate text source.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sp",
//    /* name */ "Speaker",
//    /* info */ "A heading to identify the speaker.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 8,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sr",
//    /* name */ "Section reference range",
//    /* info */ "The text reference range listed under a section heading.",
//    /* category */ "h",
//    /* type */ 3,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 1,
//    /* spacebefore */ 0,
//    /* spaceafter */ 4,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "sts",
//    /* name */ "Status",
//    /* info */ "Project text status tracking.",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tc1",
//    /* name */ "Table column 1 cell",
//    /* info */ "A table cell item, column 1.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tc2",
//    /* name */ "Table column 2 cell",
//    /* info */ "A table cell item, column 2.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 2,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tc3",
//    /* name */ "Table column 3 cell",
//    /* info */ "A table cell item, column 3.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 3,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tc4",
//    /* name */ "Table column 4 cell",
//    /* info */ "A table cell item, column 4.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 4,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tcr1",
//    /* name */ "Right aligned table cell column 1",
//    /* info */ "A table cell item, column 1, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tcr2",
//    /* name */ "Right aligned table cell column 2",
//    /* info */ "A table cell item, column 2, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 2,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tcr3",
//    /* name */ "Right aligned table cell column 3",
//    /* info */ "A table cell item, column 3, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 3,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tcr4",
//    /* name */ "Right aligned table cell column 4",
//    /* info */ "A table cell item, column 4, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 4,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "th1",
//    /* name */ "Table column 1 heading",
//    /* info */ "A table heading, column 1.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "th2",
//    /* name */ "Table column 2 heading",
//    /* info */ "A table heading, column 2.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 2,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "th3",
//    /* name */ "Table column 3 heading",
//    /* info */ "A table heading, column 3.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 3,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "th4",
//    /* name */ "Table column 4 heading",
//    /* info */ "A table heading, column 4.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 4,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "thr1",
//    /* name */ "Right aligned table column 1 heading",
//    /* info */ "A table heading, column 1, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "thr2",
//    /* name */ "Right aligned table column 2 heading",
//    /* info */ "A table heading, column 2, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 2,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "thr3",
//    /* name */ "Right aligned table 3 column heading",
//    /* info */ "A table heading, column 3, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 3,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "thr4",
//    /* name */ "Right aligned table column 4 heading",
//    /* info */ "A table heading, column 4, right aligned.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 2,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 4,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tl",
//    /* name */ "Transliterated word",
//    /* info */ "Transliterated or foreign words.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "toc",
//    /* name */ "Table of contents",
//    /* info */ "Front matter table of contents.",
//    /* category */ "pm",
//    /* type */ 9,
//    /* subtype */ 1,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "toc1",
//    /* name */ "Long table of contents text",
//    /* info */ "Long table of contents text.",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 4,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "toc2",
//    /* name */ "Short table of contents text",
//    /* info */ "Short table of contents text.",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 5,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "toc3",
//    /* name */ "Book abbreviation",
//    /* info */ "Book abbreviation. Not yet supported in Bibledit.",
//    /* category */ "id",
//    /* type */ 0,
//    /* subtype */ 6,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "tr",
//    /* name */ "Table row start",
//    /* info */ "A new table row.",
//    /* category */ "te",
//    /* type */ 12,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 12.7f,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -6.4f,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "v",
//    /* name */ "Verse number",
//    /* info */ "A verse number.",
//    /* category */ "cv",
//    /* type */ 6,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "va",
//    /* name */ "Alternate verse number",
//    /* info */ "Second or alternate verse number. For coding dual numeration in Psalms.",
//    /* category */ "cv",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "vp",
//    /* name */ "Published verse marker",
//    /* info */ "Published verse marker. This is a verse marking that would be used in the published text.",
//    /* category */ "cv",
//    /* type */ 0,
//    /* subtype */ 10,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "w",
//    /* name */ "Wordlist entry",
//    /* info */ "Surround words with this markup to indicate that it appears or should appear in the word list.",
//    /* category */ "sf",
//    /* type */ 13,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 2,
//    /* bold */ 2,
//    /* underline */ 2,
//    /* smallcaps */ 2,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "wa",
//    /* name */ "Aramaic word list entry",
//    /* info */ "Surround words with this markup to indicate that it appears or should appear in the Aramaic word list.",
//    /* category */ "sf",
//    /* type */ 13,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 2,
//    /* bold */ 2,
//    /* underline */ 2,
//    /* smallcaps */ 2,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "wg",
//    /* name */ "Greek word list entry",
//    /* info */ "A Greek word list text item.",
//    /* category */ "sf",
//    /* type */ 13,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "wh",
//    /* name */ "Hebrew word list entry",
//    /* info */ "A Hebrew word list text item.",
//    /* category */ "sf",
//    /* type */ 13,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "wj",
//    /* name */ "Words of Jesus",
//    /* info */ "For marking the words of Jesus.",
//    /* category */ "st",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#FF0000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "x",
//    /* name */ "Cross reference",
//    /* info */ "A list of cross references.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 1,
//    /* userint2 */ 2,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xdc",
//    /* name */ "Cross reference deuterocanonical",
//    /* info */ "References or other text between these markers is material to be included only in published editions that contain the Deuterocanonical books. Deprecated.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 1,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xk",
//    /* name */ "Cross reference keyword",
//    /* info */ "A keyword from the scripture translation text which the target references also refer to.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xnt",
//    /* name */ "Cross reference New Testament",
//    /* info */ "References or other text between these markers is material to be included only in published editions that contain the New Testament books.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xo",
//    /* name */ "Cross reference origin reference",
//    /* info */ "This is the chapter and verse or verses that target references are being provided for.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 1,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xop",
//    /* name */ "Published cross reference origin text",
//    /* info */ "In some texts, the content intended to be published in the position of the cross reference origin text 'xo' does not follow the typical chapter-separator-verse pattern. An origin reference following this pattern is required for validation of the cross reference location. 'xop' ...'xop*' can be used in order to supply the content intended for publishing, similar to the use of 'cp' and 'vp ...vp*'.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xot",
//    /* name */ "Cross reference Old Testament",
//    /* info */ "References or other text between these markers is material to be included only in published editions that contain the Old Testament books.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xq",
//    /* name */ "Cross reference quotation",
//    /* info */ "A cross reference quotation from the scripture text.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 2,
//    /* fontsize */ 12,
//    /* italic */ 1,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xt",
//    /* name */ "Cross reference target references",
//    /* info */ "The cross reference target references.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 1,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 4,
//    /* rightmargin */ 0,
//    /* firstlineindent */ -4,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  {
//    /* marker */ "xta",
//    /* name */ "Target references added text",
//    /* info */ "Used for marking text added to the target references. This text should be ignored when identifying or linking to cross reference target references.",
//    /* category */ "x",
//    /* type */ 8,
//    /* subtype */ 3,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  // https://ubsicap.github.io/usfm/peripherals/index.html
//  {
//    /* marker */ "periph",
//    /* name */ "Peripheral",
//    /* info */ "Divisions for peripheral content.",
//    /* category */ "pm",
//    /* type */ 9,
//    /* subtype */ 10,
//    /* fontsize */ 10,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 0,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//  // https://ubsicap.github.io/usfm/characters/index.html?highlight=sup#sup-sup
//  {
//    /* marker */ "sup",
//    /* name */ "Superscript text",
//    /* info */ "Typically for use in critical edition footnotes.",
//    /* category */ "cs",
//    /* type */ 4,
//    /* subtype */ 0,
//    /* fontsize */ 12,
//    /* italic */ 0,
//    /* bold */ 0,
//    /* underline */ 0,
//    /* smallcaps */ 0,
//    /* superscript */ 1,
//    /* justification */ 0,
//    /* spacebefore */ 0,
//    /* spaceafter */ 0,
//    /* leftmargin */ 0,
//    /* rightmargin */ 0,
//    /* firstlineindent */ 0,
//    /* spancolumns */ 0,
//    /* color */ "#000000",
//    /* print */ 1,
//    /* userbool1 */ 0,
//    /* userbool2 */ 0,
//    /* userbool3 */ 0,
//    /* userint1 */ 0,
//    /* userint2 */ 0,
//    /* userint3 */ 0,
//    /* userstring1 */ "",
//    /* userstring2 */ "",
//    /* userstring3 */ "",
//    /* backgroundcolor */ "#FFFFFF",
//  },
//};
//
