.TH "afetch" 1 "@RELEASEDATE@" "@PACKAGE@ @RELEASE@" "@PACKAGE@ Manual"

.SH NAME
.TP 
afetch - retrieve an alignment from an alignment database 

.SH SYNOPSIS
.B afetch
.I [options]
.I alignmentdb
.I key

.PP
.B afetch --index
.I alignmentdb

.SH DESCRIPTION

.B afetch
retrieves the alignment named
.I key
from an alignment database in file
.I alignmentdb.

.PP 
.I alignmentdb 
is a "multiple multiple alignment" file in Stockholm (e.g. native
Pfam) format.

.PP
.I key 
is either the name (ID) of the alignment, or its accession
number (AC).

.PP
The 
.I alignmentdb
file should first be SSI indexed with
.B afetch --index
for efficient retrieval. An SSI index is
not required, but alignment retrieval without one may
be painfully slow.

.SH OPTIONS

.TP
.B -h
Print brief help; includes version number and summary of
all options, including expert options.

.SH EXPERT OPTIONS

.TP
.B --index
Instead of retrieving a
.I key,
the special command
.B afetch --index
.I alignmentdb
produces an SSI index of the names and accessions
of the alignments in 
the file 
.I alignmentdb. 
This should be run once on the 
.I alignmentdb
file to prepare it for all future afetch's.

.SH SEE ALSO

.PP
Master man page, with full list of and guide to the
individual man pages for SQUID's auxiliary programs: see
.B squid(1).

.SH AUTHOR

@PACKAGE@ and its documentation are @COPYRIGHT@
@LICENSE@
See COPYING in the source code distribution for more details, or contact me.

.nf
Sean Eddy
HHMI/Department of Genetics
Washington University School of Medicine
4444 Forest Park Blvd., Box 8510
St Louis, MO 63108 USA
Phone: 1-314-362-7666
FAX  : 1-314-362-2157
Email: eddy@genetics.wustl.edu
.fi


