/*
 * Cobertura - http://cobertura.sourceforge.net/
 *
 * Copyright (C) 2011 Piotr Tabor
 *
 * Note: This file is dual licensed under the GPL and the Apache
 * Source License (so that it can be used from both the main
 * Cobertura classes and the ant tasks).
 *
 * Cobertura is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published
 * by the Free Software Foundation; either version 2 of the License,
 * or (at your option) any later version.
 *
 * Cobertura is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Cobertura; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

package net.sourceforge.cobertura.instrument.pass1;

import net.sourceforge.cobertura.instrument.AbstractFindTouchPointsClassInstrumenter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.util.CheckClassAdapter;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;

public class DetectIgnoredCodeClassVisitor extends ClassVisitor {
	/**
	 * set of ignored line IDs
	 */
	private Set<Integer> ignoredLineIds = new HashSet<Integer>();

	/**
	 * Set of concatenated methodName and methodSignature that should be ignored
	 */
	private Set<String> ignoredMethodNamesAndSignatures = new HashSet<String>();

	/**
	 * Name (internal asm) of currently processed class
	 */
	private String className;

	/**
	 * Name (internal asm) of parent of processed class
	 */
	private String superName;

	/**
	 * Every LINENUMBER instruction will have generated it's lineId.
	 * <p/>
	 * The generated ids must be the same as those generated by ( {@link AbstractFindTouchPointsClassInstrumenter#lineIdGenerator} )
	 */
	private final AtomicInteger lineIdGenerator = new AtomicInteger(0);

	private final boolean ignoreTrivial;
	private final Set<String> ignoreAnnotations;

	public DetectIgnoredCodeClassVisitor(ClassVisitor cv,
			boolean ignoreTrivial, Set<String> ignoreAnnotations) {
		super(Opcodes.ASM4, new CheckClassAdapter(cv, false));
		this.ignoreTrivial = ignoreTrivial;
		this.ignoreAnnotations = ignoreAnnotations;
	}

	@Override
	public void visit(int version, int access, String name, String signature,
			String superName, String[] interfaces) {
		super.visit(version, access, name, signature, superName, interfaces);
		this.className = name;
		this.superName = superName;
	}

	@Override
	public MethodVisitor visitMethod(int access, String methodName,
			String description, String signature, String[] exceptions) {
		MethodVisitor nestedVisitor = super.visitMethod(access, methodName,
				description, signature, exceptions);
		return new DetectIgnoredCodeMethodVisitor(nestedVisitor,
				ignoredLineIds, ignoredMethodNamesAndSignatures, ignoreTrivial,
				ignoreAnnotations, className, superName, methodName,
				description, lineIdGenerator);
	}

	public Set<Integer> getIgnoredLineIds() {
		return ignoredLineIds;
	}

	public Set<String> getIgnoredMethodNamesAndSignatures() {
		return ignoredMethodNamesAndSignatures;
	}
}
