% make_ssbfilt.m
% David Rowe May 2015
%
% Creates low pass filter coeff used to implement a SSB filter in ch

graphics_toolkit ("gnuplot");

ssbfilt_n = 100;
ssbfilt_bw = 2400;
ssbfilt_centre = 1500;
Fs = 8000;

ssbfilt_coeff  = sbfilt_coeff = fir1(ssbfilt_n, ssbfilt_bw/Fs);

figure(1)
clf;
h = freqz(ssbfilt_coeff,1,Fs/2);
plot(20*log10(abs(h)))
grid minor

% save coeffs to a C header file

f=fopen("../src/ssbfilt_coeff.h","wt");
fprintf(f,"/* %d Hz LPF FIR filter coeffs */\n", ssbfilt_bw);
fprintf(f,"/* Generated by make_ssbfilt Octave script */\n");

fprintf(f,"\n#define SSBFILT_N %d\n\n", ssbfilt_n);
fprintf(f,"\n#define SSBFILT_CENTRE %d\n\n", ssbfilt_centre);

fprintf(f,"float ssbfilt_coeff[]={\n");
for r=1:ssbfilt_n
  if r < ssbfilt_n
    fprintf(f, "  %f,\n",  ssbfilt_coeff(r));
  else
    fprintf(f, "  %f\n};", ssbfilt_coeff(r));
  end
end

fclose(f);
