/*

  Author:  Bob Dean
  Copyright (c) 1999, 2000


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public Licensse as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
 
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

 */

#ifdef __cplusplus
extern "C"
{
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>
#include <sys/types.h>
#include <limits.h>
#include <fcntl.h>
#include <signal.h>
#include <stdarg.h>
#include <sys/shm.h>
#include <glib.h>
#include <math.h>

#include <dbsoundcard.h>
#include <dbchannel.h>
#include <dbdebug.h>
#include <dbaudiolib.h>
#include <sys/ipc.h>
#include <sys/msg.h>
	
#include "prototypes.h"
	
	/* variables to access DBMix channels shared memory */
	extern  int shmid, sysshmid;
	extern dbfsd_data * sysdata;
	/* static local_channel * cue_channels; */
	extern local_channel * ch;
	
	extern int errno;
	extern int debug_level; /* declared in debug module */
	
	
	int DBAudio_Set_Message_Handler(void(*message_handler)(dbfsd_msg msg),
									int msg_flags)
	{
		if (ch == NULL)  {errno = ERROR_NOT_INITIALIZED; return FAILURE;}
		
		ch->message_handler = message_handler;
		ch->msg_flags = msg_flags;
		
		/* do not allow pause messages to be requested if the device
           does not support pausing */

		return SUCCESS;
	}


	/*
	  handles message sent to DBAudioLib by outside sources.
	*/

	int DBAudio_Handle_Message_Queue()
	{
		dbfsd_msg msg;

		if (ch == NULL)  
		{
			errno = ERROR_NOT_INITIALIZED; 
			return FAILURE;
		}

		if (ch->msg_q_id == -1) 
		{
			return SUCCESS;
		}

		while (msgrcv(ch->msg_q_id, &msg,sizeof(dbfsd_msg) - sizeof(long int),0,IPC_NOWAIT) != -1)
		{
			/* if the client has asked for this message, send it */
			if (ch->msg_flags & msg.msg_type)
			{
				if (ch->message_handler != NULL)
				{
					Debug("dbaudiolib: passing message %d to client",msg.msg_type);
					(ch->message_handler)((dbfsd_msg)msg);
				}
			}
			else
			{
				/* hanle message internally */
				switch (msg.msg_type)
				{	
					case DBMSG_NONE:
						break;
					case DBMSG_MUTE:
						Debug("dbaudiolib: got MUTE message.");
						ch->mute = 1;
						break;
					case DBMSG_UNMUTE:				
						Debug("dbaudiolib: got UNMUTE message.");
						ch->mute = 0;
						break;
					case DBMSG_PAUSE:
						Debug("dbaudiolib: got PAUSE message. waiting for unpause...");
						if (!(PAUSE_ENABLED)) break;

						DBAudio_Pause(TRUE);
						break;
					case DBMSG_UNPAUSE:
						Debug("dbaudiolib: got UNPAUSE message.");
						if (!(PAUSE_ENABLED)) break;

						DBAudio_Pause(FALSE);
						break;
					case DBMSG_PLAY:
						Debug("dbaudiolib: got PLAY message.");
						break;
					case DBMSG_STOP:
						Debug("dbaudiolib: got STOP message.");
						break;
					case DBMSG_EJECT:
						Debug("dbaudiolib: got EJECT message.");
						break;
					case DBMSG_REWIND:
						Debug("dbaudiolib: got REWIND message.");
						break;
					case DBMSG_FFORWARD:
						Debug("dbaudiolib: got FFORWARD message.");
						break;
					case DBMSG_NEXT:
						Debug("dbaudiolib: got NEXT message.");
						break;
					case DBMSG_PREV:
						Debug("dbaudiolib: got PREV message.");
						break;
					case DBMSG_SAMPLERSIZE:
						Debug("dbaudiolib: got SAMPLERSIZE message.");
						break;
					case DBMSG_SAMPLERSAVE:
						Debug("dbaudiolib: got SAVE message.");
						DBAudio_Sampler_Save(sysdata->filename);
						break;
					case DBMSG_SAMPLERLOAD:
						Debug("dbaudiolib: got LOAD message.");
						DBAudio_Sampler_Load(sysdata->filename);
						break;
					case DBMSG_SAMPLERREC:
						Debug("dbaudiolib: got REC message.");
						DBAudio_Sampler_Record();
						break;
					case DBMSG_SAMPLERSTOP:
						Debug("dbaudiolib: got STOP message.");
						DBAudio_Sampler_Stop();
						break;
					case DBMSG_SAMPLERLOOP:
						Debug("dbaudiolib: got LOOP message.");
						DBAudio_Sampler_Loop();
						break;
					case DBMSG_SAMPLERONCE:
						Debug("dbaudiolib: got ONCE message.");
						DBAudio_Sampler_Single();
						break;
					default:
						Error("DBAudioLib: Handle_Message_Queue: unknown message type: %l\n",msg.msg_type);
						break;
				}
			}
		}

		return SUCCESS;
	}


#ifdef __cplusplus
}
#endif
