## About

The DICOM standard has become the dominant imaging format in medicine. However, it is necessarily complex. The relative simplicity of NIfTI makes it popular with many scientific tools.Further, to protect participant privacy scientists often wish to anonymize the datasets, removing [protected health information](https://www.hipaajournal.com/considered-phi-hipaa/). It is much easier to ensure a simple format is completely anonymized relative to a complex format.The role of dcm2niix is to convert these images into the simpler NIfTI standard. A challenge is that the DICOM standard is implemented differently by different vendors, and is evolving. Indeed, the complexity of the standard means that many DICOM images do not perfectly conform to the standard. To thoroughly read these images, one needs to develop an understanding of how each vender has interpreted the DICOM standard. Due to these factors, dcm2niix may not always create the results you expect.

This page explains situations where dcm2niix may fail or generate impoverished results. If this page is unable to resolve your problem, you may want to consider creating a [new issue report on the Github web page](https://github.com/rordenlab/dcm2niix/issues).

## Common DICOM Problems

The DICOM standard is very complex. In addition, dcm2niix attempts to extract a rich amount of meta data. For example, knowing about diffusion direction, phase encoding polarity and slice timing are all important details for scientists. Yet many of these details are not described by public DICOM tags. Therefore, dcm2niix must determine the vendor that generated the images. This allows dcm2niix to decipher the private tags used by the vendors. While the community has reversed-engineered data from the major vendors, data from unfamiliar vendors can cause issues. Further, tools that attempt to anonymize or otherwise modify DICOM data often inadvertently remove vital meta data or corrupt the DICOM images.

If you have a problem with a DICOM scan, your first step should be to inspect the DICOM header understand the providence of the image. The DICOM images created by the scanner are often saved in slightly altered forms by other tools that attempt to anonymize or process the images. It is typically these tools that effectively corrupt the images. In particular, the recent Enhanced DICOM images generated by Siemens Vida scanners and Philips scanners use a recent variation of DICOM. Many older DICOM tools are not familiar with this dialect, and corrupt every enhanced DICOM image they receive. Therefore, if you have a problem, it is worthwhile to first get an image direct from your scanner. If this raw data converts correctly, it suggests a subsequent tool is responsible for tampering with the data.

In general, you should be very cautious to use any tool to manipulate your raw DICOM data. The complexity of DICOM makes them very fragile. Attempts to change the transfer syntax (e.g. internally compress), anonymize or change the value representation from Explicit to Implicit can all corrupt some forms of DICOM data. Archival quality data should be tampered with as little as possible.

If you are unsure of the providence of your image, you can inspect the DICOM header. MacOS users can use the free [Horos](https://horosproject.org/) application to inspect the meta data using a graphical interface. The command line tools [dcmdump](https://support.dcmtk.org/docs/dcmdump.html) and [gdcmdump](http://gdcm.sourceforge.net/html/gdcmdump.html). For example, typing 'dcmconv myDICOM.dcm > log.txt' will generate  text file of your complete DICOM header. The first public tag to check is the Manufacturer (0008,0070): the major vendors are Siemens, Philips and GE. Data from other vendors is likely to have more issues. The next tag to check is the Implementation Version Name and the SourceApplicationEntityTitle (0002,0016) - these is the tool that created your image. For images direct off the scanner this will usually be named after the scanner model (e.g. a Siemens E11C Prisma might report "MR_VE11C", a Philips Examination Workstation might report "EWS R2.5'). In general, the most popular free tools have been used by many users, and generate good DICOM images. For example, "dcm4che","GDCM" and "OFFIS DCMTK" all refer to popular and robust tools. On the other hand, "MATLAB IPT 9.4" suggests that the file was manipulated by a Matlab script, and since it is so easy to generate Matlab scripts it is possible that the user did not consider all the possible unintended consequences of manipulating the image.
