/*
 * This file is part of din.
 *
 * din is copyright (c) 2006 - 2012 S Jagannathan <jag@dinisnoise.org>
 * For more information, please visit http://dinisnoise.org
 *
 * din is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * din is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with din.  If not, see <http://www.gnu.org/licenses/>.
 *
*/
#ifndef __CURVE_LIBRARY
#define __CURVE_LIBRARY

#include <string>
#include <vector>
#include "multi_curve.h"

struct curve_editor;
struct curve_library;

struct curve_library {

  // a library of multi curves loaded from file

  std::string filename;

  std::vector <multi_curve> curves;
  std::vector <float> sustains;
  
  int cur;
  
  int has_sustain; // only curve library of keyboard-keyboard attack has sustain

  curve_library (const std::string& fname, int _has_sustain = 0);
  ~curve_library ();
  void load (const std::string& fname);
  void add (const multi_curve& m);
  void del ();
  void replace (const multi_curve& m);
  void insert (const multi_curve& m);
  const multi_curve& prev ();
  const multi_curve& next ();
  void move (int i);
  int num_curves () { return (int) curves.size (); }
  void save ();

};
#endif
