/***************************************************************************
 *   Copyright (C) 2004, 2005, 2006 by Stephen McInerney                   *
 *   spm@stedee.id.au                                                      *
 *                                                                         *
 *   $Id: xmalloc.c 68 2007-01-23 11:12:33Z steve $
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

/***************************************************************************
 ***************************************************************************
 * xmalloc.c
 *
 *  dealing with memory: functional wrappers
 *
 ***************************************************************************
 ***************************************************************************/

#include "dnshistory.h"


/************************************************************************
 * xmalloc                                                              *
 *                                                                      *
 * Wrapper around calling calloc                                        *
 * **********************************************************************/
void *
xmalloc(size_t size)
{
    void *data_ptr;                             /* data pointer; result of calling calloc */

    data_ptr = calloc(1, size);
    if (data_ptr == NULL) {
        fprintf(stderr, "%s\n", msg_F_memory_alloc);
        exit(V_EXIT_MEMORY_EXHAUSTION);
    }

    return (data_ptr);
}


/************************************************************************
 ************************************************************************
 *                      END OF FILE                                     *
 ************************************************************************
 ************************************************************************/
