/*
 * fhist - file history and comparison tools
 * Copyright (C) 1991-1994, 1998, 2000, 2002, 2008, 2010, 2012 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef ARGLEX_H
#define ARGLEX_H

#include <common/main.h>

enum
{
    arglex_token_eoln,
    arglex_token_help,
    arglex_token_number,
    arglex_token_option,
    arglex_token_stdio,
    arglex_token_string,
    arglex_token_version,
    arglex_token_MAX1
};

typedef struct arglex_table_ty arglex_table_ty;
struct arglex_table_ty
{
    const char      *name;
    int             token;
};

typedef struct arglex_value_ty arglex_value_ty;
struct arglex_value_ty
{
    const char      *alv_string;
    long            alv_number;
};

extern int arglex_token;
extern arglex_value_ty arglex_value;

void arglex_init(int, char **, arglex_table_ty *);
int arglex(void);
int arglex_compare(const char *formal, const char *actual);

const char *arglex_token_name(int);

#endif /* ARGLEX_H */
/* vim: set ts=8 sw=4 et : */
