#!/bin/sh
#
# Usage: ./generate-hooklist.sh >hook-list.h

SOURCE_DIR="$1"
OUTPUT="$2"

if test -z "$SOURCE_DIR" || ! test -d "$SOURCE_DIR" || test -z "$OUTPUT"
then
	echo >&2 "USAGE: $0 <SOURCE_DIR> <OUTPUT>"
	exit 1
fi

{

cat <<EOF
/* Automatically generated by generate-hooklist.sh */

static const char *hook_name_list[] = {
EOF

sed -n \
	-e '/^~~~~*$/ {x; s/^.*$/	"&",/; p;}' \
	-e 'x' \
	<"$SOURCE_DIR"/Documentation/githooks.adoc |
	LC_ALL=C sort

cat <<EOF
	NULL,
};
EOF

} >"$OUTPUT"
