// Code generated by smithy-go-codegen DO NOT EDIT.

package launchwizard

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/launchwizard/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists the workload deployment patterns for a given workload name. You can use
// the [ListWorkloads]operation to discover the available workload names.
//
// [ListWorkloads]: https://docs.aws.amazon.com/launchwizard/latest/APIReference/API_ListWorkloads.html
func (c *Client) ListWorkloadDeploymentPatterns(ctx context.Context, params *ListWorkloadDeploymentPatternsInput, optFns ...func(*Options)) (*ListWorkloadDeploymentPatternsOutput, error) {
	if params == nil {
		params = &ListWorkloadDeploymentPatternsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListWorkloadDeploymentPatterns", params, optFns, c.addOperationListWorkloadDeploymentPatternsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListWorkloadDeploymentPatternsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListWorkloadDeploymentPatternsInput struct {

	// The name of the workload.
	//
	// This member is required.
	WorkloadName *string

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output.
	MaxResults *int32

	// The token returned from a previous paginated request. Pagination continues from
	// the end of the items returned by the previous request.
	NextToken *string

	noSmithyDocumentSerde
}

type ListWorkloadDeploymentPatternsOutput struct {

	// The token to include in another request to get the next page of items. This
	// value is null when there are no more items to return.
	NextToken *string

	// Describes the workload deployment patterns.
	WorkloadDeploymentPatterns []types.WorkloadDeploymentPatternDataSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListWorkloadDeploymentPatternsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListWorkloadDeploymentPatterns{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListWorkloadDeploymentPatterns{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListWorkloadDeploymentPatterns"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addOpListWorkloadDeploymentPatternsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListWorkloadDeploymentPatterns(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

// ListWorkloadDeploymentPatternsPaginatorOptions is the paginator options for
// ListWorkloadDeploymentPatterns
type ListWorkloadDeploymentPatternsPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListWorkloadDeploymentPatternsPaginator is a paginator for
// ListWorkloadDeploymentPatterns
type ListWorkloadDeploymentPatternsPaginator struct {
	options   ListWorkloadDeploymentPatternsPaginatorOptions
	client    ListWorkloadDeploymentPatternsAPIClient
	params    *ListWorkloadDeploymentPatternsInput
	nextToken *string
	firstPage bool
}

// NewListWorkloadDeploymentPatternsPaginator returns a new
// ListWorkloadDeploymentPatternsPaginator
func NewListWorkloadDeploymentPatternsPaginator(client ListWorkloadDeploymentPatternsAPIClient, params *ListWorkloadDeploymentPatternsInput, optFns ...func(*ListWorkloadDeploymentPatternsPaginatorOptions)) *ListWorkloadDeploymentPatternsPaginator {
	if params == nil {
		params = &ListWorkloadDeploymentPatternsInput{}
	}

	options := ListWorkloadDeploymentPatternsPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListWorkloadDeploymentPatternsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListWorkloadDeploymentPatternsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListWorkloadDeploymentPatterns page.
func (p *ListWorkloadDeploymentPatternsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListWorkloadDeploymentPatternsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListWorkloadDeploymentPatterns(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListWorkloadDeploymentPatternsAPIClient is a client that implements the
// ListWorkloadDeploymentPatterns operation.
type ListWorkloadDeploymentPatternsAPIClient interface {
	ListWorkloadDeploymentPatterns(context.Context, *ListWorkloadDeploymentPatternsInput, ...func(*Options)) (*ListWorkloadDeploymentPatternsOutput, error)
}

var _ ListWorkloadDeploymentPatternsAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListWorkloadDeploymentPatterns(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListWorkloadDeploymentPatterns",
	}
}
