/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util.webmacro;

import org.apache.turbine.services.webmacro.TurbineWebMacro;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.mail.SimpleEmail;
import org.webmacro.servlet.WebContext;

public class WebMacroEmail {
    private String toName = null;
    private String toEmail = null;
    private String fromName = null;
    private String fromEmail = null;
    private String subject = null;
    private String template = null;
    private WebContext context = null;

    public WebMacroEmail setTo(String to, String email) {
        this.toName = to;
        this.toEmail = email;
        return this;
    }

    public WebMacroEmail setFrom(String from, String email) {
        this.fromName = from;
        this.fromEmail = email;
        return this;
    }

    public WebMacroEmail setSubject(String subject) {
        this.subject = subject;
        return this;
    }

    public WebMacroEmail setTemplate(String template) {
        this.template = template;
        return this;
    }

    public WebMacroEmail setContext(WebContext context) {
        this.context = context;
        return this;
    }

    public WebContext getContext() {
        return this.context;
    }

    public void send() {
        this.context.put((Object)"mail", (Object)this);
        try {
            String body = TurbineWebMacro.handleRequest(this.context, this.template);
            SimpleEmail se = new SimpleEmail();
            se.setFrom(this.fromEmail, this.fromName);
            se.addTo(this.toEmail, this.toName);
            se.setSubject(this.subject);
            se.setMsg(body);
            se.send();
        }
        catch (Exception e) {
            Log.error("WebMacroEmail error: ", e);
        }
    }

    public String toString() {
        this.send();
        return "";
    }

    public WebMacroEmail() {
    }

    public WebMacroEmail(WebContext context) {
        this.context = context;
    }
}

