# coding=utf-8
r"""
This code was generated by
\ / _    _  _|   _  _
 | (_)\/(_)(_|\/| |(/_  v1.0.0
      /       /
"""

from twilio.base import values
from twilio.base.instance_context import InstanceContext
from twilio.base.instance_resource import InstanceResource
from twilio.base.list_resource import ListResource
from twilio.base.page import Page
from twilio.rest.bulkexports.v1.export.day import DayList
from twilio.rest.bulkexports.v1.export.export_custom_job import ExportCustomJobList
from twilio.rest.bulkexports.v1.export.job import JobList


class ExportList(ListResource):

    def __init__(self, version):
        """
        Initialize the ExportList

        :param Version version: Version that contains the resource

        :returns: twilio.rest.bulkexports.v1.export.ExportList
        :rtype: twilio.rest.bulkexports.v1.export.ExportList
        """
        super(ExportList, self).__init__(version)

        # Path Solution
        self._solution = {}

        # Components
        self._jobs = None

    @property
    def jobs(self):
        """
        Access the jobs

        :returns: twilio.rest.bulkexports.v1.export.job.JobList
        :rtype: twilio.rest.bulkexports.v1.export.job.JobList
        """
        if self._jobs is None:
            self._jobs = JobList(self._version, )
        return self._jobs

    def get(self, resource_type):
        """
        Constructs a ExportContext

        :param resource_type: The type of communication – Messages, Calls, Conferences, and Participants

        :returns: twilio.rest.bulkexports.v1.export.ExportContext
        :rtype: twilio.rest.bulkexports.v1.export.ExportContext
        """
        return ExportContext(self._version, resource_type=resource_type, )

    def __call__(self, resource_type):
        """
        Constructs a ExportContext

        :param resource_type: The type of communication – Messages, Calls, Conferences, and Participants

        :returns: twilio.rest.bulkexports.v1.export.ExportContext
        :rtype: twilio.rest.bulkexports.v1.export.ExportContext
        """
        return ExportContext(self._version, resource_type=resource_type, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Bulkexports.V1.ExportList>'


class ExportPage(Page):

    def __init__(self, version, response, solution):
        """
        Initialize the ExportPage

        :param Version version: Version that contains the resource
        :param Response response: Response from the API

        :returns: twilio.rest.bulkexports.v1.export.ExportPage
        :rtype: twilio.rest.bulkexports.v1.export.ExportPage
        """
        super(ExportPage, self).__init__(version, response)

        # Path Solution
        self._solution = solution

    def get_instance(self, payload):
        """
        Build an instance of ExportInstance

        :param dict payload: Payload response from the API

        :returns: twilio.rest.bulkexports.v1.export.ExportInstance
        :rtype: twilio.rest.bulkexports.v1.export.ExportInstance
        """
        return ExportInstance(self._version, payload, )

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        return '<Twilio.Bulkexports.V1.ExportPage>'


class ExportContext(InstanceContext):

    def __init__(self, version, resource_type):
        """
        Initialize the ExportContext

        :param Version version: Version that contains the resource
        :param resource_type: The type of communication – Messages, Calls, Conferences, and Participants

        :returns: twilio.rest.bulkexports.v1.export.ExportContext
        :rtype: twilio.rest.bulkexports.v1.export.ExportContext
        """
        super(ExportContext, self).__init__(version)

        # Path Solution
        self._solution = {'resource_type': resource_type, }
        self._uri = '/Exports/{resource_type}'.format(**self._solution)

        # Dependents
        self._days = None
        self._export_custom_jobs = None

    def fetch(self):
        """
        Fetch the ExportInstance

        :returns: The fetched ExportInstance
        :rtype: twilio.rest.bulkexports.v1.export.ExportInstance
        """
        payload = self._version.fetch(method='GET', uri=self._uri, )

        return ExportInstance(self._version, payload, resource_type=self._solution['resource_type'], )

    @property
    def days(self):
        """
        Access the days

        :returns: twilio.rest.bulkexports.v1.export.day.DayList
        :rtype: twilio.rest.bulkexports.v1.export.day.DayList
        """
        if self._days is None:
            self._days = DayList(self._version, resource_type=self._solution['resource_type'], )
        return self._days

    @property
    def export_custom_jobs(self):
        """
        Access the export_custom_jobs

        :returns: twilio.rest.bulkexports.v1.export.export_custom_job.ExportCustomJobList
        :rtype: twilio.rest.bulkexports.v1.export.export_custom_job.ExportCustomJobList
        """
        if self._export_custom_jobs is None:
            self._export_custom_jobs = ExportCustomJobList(
                self._version,
                resource_type=self._solution['resource_type'],
            )
        return self._export_custom_jobs

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Bulkexports.V1.ExportContext {}>'.format(context)


class ExportInstance(InstanceResource):

    def __init__(self, version, payload, resource_type=None):
        """
        Initialize the ExportInstance

        :returns: twilio.rest.bulkexports.v1.export.ExportInstance
        :rtype: twilio.rest.bulkexports.v1.export.ExportInstance
        """
        super(ExportInstance, self).__init__(version)

        # Marshaled Properties
        self._properties = {
            'resource_type': payload.get('resource_type'),
            'url': payload.get('url'),
            'links': payload.get('links'),
        }

        # Context
        self._context = None
        self._solution = {'resource_type': resource_type or self._properties['resource_type'], }

    @property
    def _proxy(self):
        """
        Generate an instance context for the instance, the context is capable of
        performing various actions.  All instance actions are proxied to the context

        :returns: ExportContext for this ExportInstance
        :rtype: twilio.rest.bulkexports.v1.export.ExportContext
        """
        if self._context is None:
            self._context = ExportContext(self._version, resource_type=self._solution['resource_type'], )
        return self._context

    @property
    def resource_type(self):
        """
        :returns: The type of communication – Messages, Calls, Conferences, and Participants
        :rtype: unicode
        """
        return self._properties['resource_type']

    @property
    def url(self):
        """
        :returns: The URL of this resource.
        :rtype: unicode
        """
        return self._properties['url']

    @property
    def links(self):
        """
        :returns: Nested resource URLs.
        :rtype: unicode
        """
        return self._properties['links']

    def fetch(self):
        """
        Fetch the ExportInstance

        :returns: The fetched ExportInstance
        :rtype: twilio.rest.bulkexports.v1.export.ExportInstance
        """
        return self._proxy.fetch()

    @property
    def days(self):
        """
        Access the days

        :returns: twilio.rest.bulkexports.v1.export.day.DayList
        :rtype: twilio.rest.bulkexports.v1.export.day.DayList
        """
        return self._proxy.days

    @property
    def export_custom_jobs(self):
        """
        Access the export_custom_jobs

        :returns: twilio.rest.bulkexports.v1.export.export_custom_job.ExportCustomJobList
        :rtype: twilio.rest.bulkexports.v1.export.export_custom_job.ExportCustomJobList
        """
        return self._proxy.export_custom_jobs

    def __repr__(self):
        """
        Provide a friendly representation

        :returns: Machine friendly representation
        :rtype: str
        """
        context = ' '.join('{}={}'.format(k, v) for k, v in self._solution.items())
        return '<Twilio.Bulkexports.V1.ExportInstance {}>'.format(context)
