Icinga Basket Generator
===

To make the integration as easy as possible, the Framework is shipping with an Icinga Director Basket configuration generator. Each Check-Plugin available within the Framework is able to auto-generate a basket config which can later be imported into the Icinga Director

Generating Baskets
---

To automaticly generate the Basket configuration, open a PowerShell terminal and type in

```powershell
Use-Icinga
```

to load the framework Cmdlets.

Afterwards use the command

```powershell
Get-IcingaCheckCommandConfig
```

to automatically generate the configuration for all Check-Commands.

If you wish to specify specific commands only, you can filter them as well:

```powershell
Get-IcingaCheckCommandConfig -CheckName Invoke-IcingaCheckBiosSerial, Invoke-IcingaCheckCPU
```

Last but not least you can output the JSON-Basket directly into a file. To do this, simply use the `OutDirectory` argument. You only require to specify a directory here, as the file including a timestamp is generated by the Cmdlet itself

```powershell
Get-IcingaCheckCommandConfig -OutDirectory 'C:\Users\myuser\Documents\'
```

Once the file is exported, you can navigate to your Icinga Director Basket menu and import the generated file. Afterwards all specified Check-Commands are available and ready to use

Developer Note
---

The generated Basket configuration will benefit from a detailed documentation of the module and each single argument. Descriptions for arguments are parsed into the Director description field, informing users of what the argument actually does. Furthermore arguments are automaticly mapped to certain object types. A `switch` argument for example will always be rendered with a `yes/no` drop-down-field, while arguments with a fixed set of input types like `Running`,  `Stopped`, and so on for services is rendered within a fixed custom list.

This will increase the entire usability of the module and prevent you from having to document the a plugin multiple times.
