# Icinga Knowledge Base - IWKB000007

## Short Message

Icinga Director Self-Service API fails with errors.

[Error]: The remote host for address "..." could not be resolved

[Error]: Failed to connect to your Icinga Director at "...". Please try again.

## Example Exception

[Error]: The remote host for address https://example.com/icingaweb2/director/self-service/powershell-parameters?key=9698sdf98sd6f9sd67fs7sdf7sa789sd58 could not be resolved

[Error]: Failed to connect to your Icinga Director at "https://example.com/icingaweb2/director/". Please try again.

Please re-enter your SelfService API Key for the Host-Template in case the key is no longer assigned to your host (Defaults: "9698sdf98sd6f9sd67fs7sdf7sa789sd58"):

## Reason

This error can occur because of different reasons. The most common reason is that the host you try to use Icinga Director Self-Service API for is already assigned a Self-Service key which is not matching your local key or you dropped the key within the Icinga Director but did not drop the key on the Windows machine.
In addition this error can occur if you are using self signed certificates for your Icinga Web 2 address and the Windows machine is not trusting it.

## Solution

### Self Signed Certificates

In case you are using self signed TLS certificates for your Icinga Web 2 address, the Windows machine might not trust the certificate. To allow the Windows host to connect to it, either install the certificate on the client to trust it or disable the certificate validation before running any Icinga for Windows command

```powershell
Enable-IcingaUntrustedCertificateValidation
```

If the error continues, please read on.

### Self-Service Key Missmatch

Icinga for Windows is storing a Self-Service API key for the registered host within it's `config.json` under `icinga-powershell-framework\config`. In case you removed the host from the Icinga Director and added it again, the Self-Service API key is no longer valid. On the other hand, if a host was already registered within the Icinga Director and you manually removed the `config.json` setting by either command or by re-installing everything entirely, the Icinga Director will prevent you from re-adding the host for security reasons.

#### Remove the Host API Key

If you re-installed the entire Icinga PowerShell Framework including the `config.json` (which now no longer contains the key) you will have to drop the Self-Service API key on the host inside the Icinga Director.

For this follow these steps:

* Navigate to the Icinga Director Module
* Click on Hosts and then on the Hosts category
* Select the Host this error occurs for
* Navigate to the `Agent` tab of the Host
* Click the button `Drop Self Service API Key`

After that, please try to run your commands again. In case the button is not present, please read on

#### Flush the Self-Service API Key locally

In case the button is not present within the Icinga Director or you are still running into issues while using your Template API key, you can flush the local Icinga Director Self-Service API key by simply running the command

```powershell
Remove-IcingaDirectorSelfServiceKey
```

Once executed try to run your commands again and see if with all above mentioned solutions the registration and configuration is possible again.
