<?php

namespace Icinga\Module\Vspheredb\MappedClass;

/**
 * The DistributedVirtualSwitchPortConnection data object represents a connection
 * or association between a DistributedVirtualPortgroup or a DistributedVirtualPort
 * and one of the following entities:
 *
 * - Virtual machine virtual NIC (VirtualEthernetCardDistributedVirtualPortBackingInfo)
 * - Host virtual NIC (HostVirtualNic)
 * - Physical NIC (HostNetworkInfo.pnic)
 */
#[\AllowDynamicProperties]
class DistributedVirtualSwitchPortConnection
{
    /**
     * Cookie that represents this DistributedVirtualSwitchPortConnection instance
     * for the port. The cookie value is generated by the Server. The Server
     * ignores any value set by an SDK client.
     *
     * The same cookie is present in the distributed virtual port configuration
     * (DistributedVirtualPort.connectionCookie) so that the Server can verify that
     * the entity is the rightful connectee of the port.
     *
     * e.g. 1595325423
     *
     * @var int
     */
    public $connectionCookie;

    /**
     * Key of the portgroup. If specified, the connection object represents a
     * connection or an association between a DistributedVirtualPortgroup and a
     * Virtual NIC or physical NIC. In this case, setting the portKey is not
     * necessary for a early-binding portgroup and is not allowed for a
     * late-binding portgroup.
     *
     * The portKey property will be populated by the implementation at the time
     * of port binding.
     *
     * e.g. "dvportgroup-34250"
     *
     * @var string
     */
    public $portgroupKey;

    /**
     * Key of the port. If specified, this object represents a connection or an
     * association between an individual DistributedVirtualPort and a Virtual NIC
     * or physical NIC. See portgroupKey for more information on populating this
     * property.
     *
     * e.g. "50"
     *
     * @var string
     */
    public $portKey;

    /**
     * UUID of the switch (DistributedVirtualSwitch.uuid)
     *
     * e.g. "50 1e ac 7f 3e 26 c5 66-4e d9 31 41 ac 58 c0 1a"
     *
     * @var string
     */
    public $switchUuid;
}
