/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.util.Hashtable;
import sun.misc.NativeSignalHandler;
import sun.misc.SignalHandler;

public final class Signal {
    private static Hashtable<Signal, SignalHandler> handlers = new Hashtable(4);
    private static Hashtable<Integer, Signal> signals = new Hashtable(4);
    private int number;
    private String name;

    public int getNumber() {
        return this.number;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof Signal)) {
            return false;
        }
        Signal other1 = (Signal)other;
        return this.name.equals(other1.name) && this.number == other1.number;
    }

    public int hashCode() {
        return this.number;
    }

    public String toString() {
        return "SIG" + this.name;
    }

    public Signal(String name) {
        this.number = Signal.findSignal(name);
        this.name = name;
        if (this.number < 0) {
            throw new IllegalArgumentException("Unknown signal: " + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized SignalHandler handle(Signal sig, SignalHandler handler) throws IllegalArgumentException {
        long newH = handler instanceof NativeSignalHandler ? ((NativeSignalHandler)handler).getHandler() : 2L;
        long oldH = Signal.handle0(sig.number, newH);
        if (oldH == -1L) {
            throw new IllegalArgumentException("Signal already used by VM or OS: " + sig);
        }
        signals.put(sig.number, sig);
        Hashtable<Signal, SignalHandler> hashtable = handlers;
        synchronized (hashtable) {
            SignalHandler oldHandler = handlers.get(sig);
            handlers.remove(sig);
            if (newH == 2L) {
                handlers.put(sig, handler);
            }
            if (oldH == 0L) {
                return SignalHandler.SIG_DFL;
            }
            if (oldH == 1L) {
                return SignalHandler.SIG_IGN;
            }
            if (oldH == 2L) {
                return oldHandler;
            }
            return new NativeSignalHandler(oldH);
        }
    }

    public static void raise(Signal sig) throws IllegalArgumentException {
        if (handlers.get(sig) == null) {
            throw new IllegalArgumentException("Unhandled signal: " + sig);
        }
        Signal.raise0(sig.number);
    }

    private static void dispatch(int number) {
        final Signal sig = signals.get(number);
        final SignalHandler handler = handlers.get(sig);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                handler.handle(sig);
            }
        };
        if (handler != null) {
            new Thread(runnable, sig + " handler").start();
        }
    }

    private static native int findSignal(String var0);

    private static native long handle0(int var0, long var1);

    private static native void raise0(int var0);
}

