/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import sun.security.krb5.Credentials;
import sun.security.krb5.KrbException;
import sun.security.krb5.KrbTgsReq;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.Realm;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.PAData;
import sun.security.krb5.internal.PAForUserEnc;
import sun.security.krb5.internal.Ticket;

public class CredentialsUtil {
    private static boolean DEBUG = Krb5.DEBUG;

    public static Credentials acquireS4U2selfCreds(PrincipalName client, Credentials ccreds) throws KrbException, IOException {
        String localRealm;
        String uRealm = client.getRealmString();
        if (!uRealm.equals(localRealm = ccreds.getClient().getRealmString())) {
            throw new KrbException("Cross realm impersonation not supported");
        }
        KrbTgsReq req = new KrbTgsReq(ccreds, ccreds.getClient(), new PAData(129, new PAForUserEnc(client, ccreds.getSessionKey()).asn1Encode()));
        Credentials creds = req.sendAndGetCreds();
        if (!creds.getClient().equals(client)) {
            throw new KrbException("S4U2self request not honored by KDC");
        }
        return creds;
    }

    public static Credentials acquireS4U2proxyCreds(String backend, Ticket second, PrincipalName client, Credentials ccreds) throws KrbException, IOException {
        KrbTgsReq req = new KrbTgsReq(ccreds, second, new PrincipalName(backend));
        Credentials creds = req.sendAndGetCreds();
        if (!creds.getClient().equals(client)) {
            throw new KrbException("S4U2proxy request not honored by KDC");
        }
        return creds;
    }

    public static Credentials acquireServiceCreds(String service, Credentials ccreds) throws KrbException, IOException {
        PrincipalName sname = new PrincipalName(service);
        String serviceRealm = sname.getRealmString();
        String localRealm = ccreds.getClient().getRealmString();
        if (localRealm.equals(serviceRealm)) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: same realm");
            }
            return CredentialsUtil.serviceCreds(sname, ccreds);
        }
        Credentials theCreds = null;
        boolean[] okAsDelegate = new boolean[1];
        Credentials theTgt = CredentialsUtil.getTGTforRealm(localRealm, serviceRealm, ccreds, okAsDelegate);
        if (theTgt != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got right tgt");
                System.out.println(">>> Credentials acquireServiceCreds: obtaining service creds for " + sname);
            }
            try {
                theCreds = CredentialsUtil.serviceCreds(sname, theTgt);
            }
            catch (Exception exc) {
                if (DEBUG) {
                    System.out.println(exc);
                }
                theCreds = null;
            }
        }
        if (theCreds != null) {
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: returning creds:");
                Credentials.printDebug(theCreds);
            }
            if (!okAsDelegate[0]) {
                theCreds.resetDelegate();
            }
            return theCreds;
        }
        throw new KrbApErrException(63, "No service creds");
    }

    private static Credentials getTGTforRealm(String localRealm, String serviceRealm, Credentials ccreds, boolean[] okAsDelegate) throws KrbException {
        String[] realms = Realm.getRealmsList(localRealm, serviceRealm);
        int i = 0;
        int k = 0;
        Credentials cTgt = null;
        Credentials newTgt = null;
        Credentials theTgt = null;
        PrincipalName tempService = null;
        String newTgtRealm = null;
        okAsDelegate[0] = true;
        cTgt = ccreds;
        i = 0;
        while (i < realms.length) {
            tempService = PrincipalName.tgsService(serviceRealm, realms[i]);
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: main loop: [" + i + "] tempService=" + tempService);
            }
            try {
                newTgt = CredentialsUtil.serviceCreds(tempService, cTgt);
            }
            catch (Exception exc) {
                newTgt = null;
            }
            if (newTgt == null) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: no tgt; searching thru capath");
                }
                newTgt = null;
                for (k = i + 1; newTgt == null && k < realms.length; ++k) {
                    tempService = PrincipalName.tgsService(realms[k], realms[i]);
                    if (DEBUG) {
                        System.out.println(">>> Credentials acquireServiceCreds: inner loop: [" + k + "] tempService=" + tempService);
                    }
                    try {
                        newTgt = CredentialsUtil.serviceCreds(tempService, cTgt);
                        continue;
                    }
                    catch (Exception exc) {
                        newTgt = null;
                    }
                }
            }
            if (newTgt == null) {
                if (!DEBUG) break;
                System.out.println(">>> Credentials acquireServiceCreds: no tgt; cannot get creds");
                break;
            }
            newTgtRealm = newTgt.getServer().getInstanceComponent();
            if (okAsDelegate[0] && !newTgt.checkDelegate()) {
                if (DEBUG) {
                    System.out.println(">>> Credentials acquireServiceCreds: global OK-AS-DELEGATE turned off at " + newTgt.getServer());
                }
                okAsDelegate[0] = false;
            }
            if (DEBUG) {
                System.out.println(">>> Credentials acquireServiceCreds: got tgt");
            }
            if (newTgtRealm.equals(serviceRealm)) {
                theTgt = newTgt;
                break;
            }
            for (k = i + 1; k < realms.length && !newTgtRealm.equals(realms[k]); ++k) {
            }
            if (k >= realms.length) break;
            i = k;
            cTgt = newTgt;
            if (!DEBUG) continue;
            System.out.println(">>> Credentials acquireServiceCreds: continuing with main loop counter reset to " + i);
        }
        return theTgt;
    }

    private static Credentials serviceCreds(PrincipalName service, Credentials ccreds) throws KrbException, IOException {
        return new KrbTgsReq(ccreds, service).sendAndGetCreds();
    }
}

