/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKLookAndFeel;
import com.sun.java.swing.plaf.gtk.GTKRegion;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JToolBar;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import sun.awt.UNIXToolkit;
import sun.awt.image.SunWritableRaster;
import sun.swing.ImageCache;

class GTKEngine {
    static final GTKEngine INSTANCE = new GTKEngine();
    private static final int CACHE_SIZE = 50;
    private static HashMap<Region, Object> regionToWidgetTypeMap;
    private ImageCache cache = new ImageCache(50);
    private int x0;
    private int y0;
    private int w0;
    private int h0;
    private Graphics graphics;
    private Object[] cacheArgs;
    private static final ColorModel[] COLOR_MODELS;
    private static final int[][] BAND_OFFSETS;

    GTKEngine() {
    }

    private native void native_paint_arrow(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_box(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native void native_paint_box_gap(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    private native void native_paint_check(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_expander(int var1, int var2, String var3, int var4, int var5, int var6, int var7, int var8);

    private native void native_paint_extension(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_flat_box(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void native_paint_focus(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_handle(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_hline(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_option(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_shadow(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9, int var10);

    private native void native_paint_slider(int var1, int var2, int var3, String var4, int var5, int var6, int var7, int var8, int var9);

    private native void native_paint_vline(int var1, int var2, String var3, int var4, int var5, int var6, int var7);

    private native void native_paint_background(int var1, int var2, int var3, int var4, int var5, int var6);

    private native Object native_get_gtk_setting(int var1);

    private native void nativeSetRangeValue(int var1, double var2, double var4, double var6, double var8);

    private native void nativeStartPainting(int var1, int var2);

    private native int nativeFinishPainting(int[] var1, int var2, int var3);

    private native void native_switch_theme();

    static WidgetType getWidgetType(JComponent c, Region id) {
        Object value = regionToWidgetTypeMap.get(id);
        if (value instanceof WidgetType) {
            return (WidgetType)((Object)value);
        }
        WidgetType[] widgets = (WidgetType[])value;
        if (c == null) {
            return widgets[0];
        }
        if (c instanceof JScrollBar) {
            return ((JScrollBar)c).getOrientation() == 0 ? widgets[0] : widgets[1];
        }
        if (c instanceof JSeparator) {
            JSeparator separator = (JSeparator)c;
            if (separator.getParent() instanceof JPopupMenu) {
                return WidgetType.POPUP_MENU_SEPARATOR;
            }
            if (separator.getParent() instanceof JToolBar) {
                return WidgetType.TOOL_BAR_SEPARATOR;
            }
            return separator.getOrientation() == 0 ? widgets[0] : widgets[1];
        }
        if (c instanceof JSlider) {
            return ((JSlider)c).getOrientation() == 0 ? widgets[0] : widgets[1];
        }
        if (c instanceof JProgressBar) {
            return ((JProgressBar)c).getOrientation() == 0 ? widgets[0] : widgets[1];
        }
        if (c instanceof JSplitPane) {
            return ((JSplitPane)c).getOrientation() == 1 ? widgets[1] : widgets[0];
        }
        if (id == Region.LABEL) {
            if (c instanceof ListCellRenderer) {
                return widgets[1];
            }
            return widgets[0];
        }
        if (id == Region.TEXT_FIELD) {
            String name = c.getName();
            if (name != null && name.startsWith("ComboBox")) {
                return widgets[1];
            }
            return widgets[0];
        }
        if (id == Region.FORMATTED_TEXT_FIELD) {
            String name = c.getName();
            if (name != null && name.startsWith("Spinner")) {
                return widgets[1];
            }
            return widgets[0];
        }
        if (id == Region.ARROW_BUTTON) {
            if (c.getParent() instanceof JScrollBar) {
                Integer prop = (Integer)c.getClientProperty("__arrow_direction__");
                int dir = prop != null ? prop : 7;
                switch (dir) {
                    case 7: {
                        return WidgetType.HSCROLL_BAR_BUTTON_LEFT;
                    }
                    case 3: {
                        return WidgetType.HSCROLL_BAR_BUTTON_RIGHT;
                    }
                    case 1: {
                        return WidgetType.VSCROLL_BAR_BUTTON_UP;
                    }
                    case 5: {
                        return WidgetType.VSCROLL_BAR_BUTTON_DOWN;
                    }
                }
                return null;
            }
            if (c.getParent() instanceof JComboBox) {
                return WidgetType.COMBO_BOX_ARROW_BUTTON;
            }
            return WidgetType.SPINNER_ARROW_BUTTON;
        }
        return null;
    }

    private static int getTextDirection(SynthContext context) {
        ComponentOrientation co;
        GTKConstants.TextDirection dir = GTKConstants.TextDirection.NONE;
        JComponent comp = context.getComponent();
        if (comp != null && (co = comp.getComponentOrientation()) != null) {
            dir = co.isLeftToRight() ? GTKConstants.TextDirection.LTR : GTKConstants.TextDirection.RTL;
        }
        return dir.ordinal();
    }

    public void paintArrow(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, GTKConstants.ArrowType direction, String detail, int x, int y, int w, int h) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_arrow(widget, state, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, direction.ordinal());
    }

    public void paintBox(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h) {
        int gtkState = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int synthState = context.getComponentState();
        int dir = GTKEngine.getTextDirection(context);
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_box(widget, gtkState, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, synthState, dir);
    }

    public void paintBoxGap(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h, GTKConstants.PositionType boxGapType, int tabBegin, int size) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_box_gap(widget, state, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, boxGapType.ordinal(), tabBegin, size);
    }

    public void paintCheck(Graphics g, SynthContext context, Region id, String detail, int x, int y, int w, int h) {
        int synthState = context.getComponentState();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_check(widget, synthState, detail, x - this.x0, y - this.y0, w, h);
    }

    public void paintExpander(Graphics g, SynthContext context, Region id, int state, GTKConstants.ExpanderStyle expanderStyle, String detail, int x, int y, int w, int h) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_expander(widget, state, detail, x - this.x0, y - this.y0, w, h, expanderStyle.ordinal());
    }

    public void paintExtension(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h, GTKConstants.PositionType placement, int tabIndex) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_extension(widget, state, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, placement.ordinal());
    }

    public void paintFlatBox(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h, ColorType colorType) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_flat_box(widget, state, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, context.getComponent().hasFocus());
    }

    public void paintFocus(Graphics g, SynthContext context, Region id, int state, String detail, int x, int y, int w, int h) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_focus(widget, state, detail, x - this.x0, y - this.y0, w, h);
    }

    public void paintHandle(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h, GTKConstants.Orientation orientation) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_handle(widget, state, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, orientation.ordinal());
    }

    public void paintHline(Graphics g, SynthContext context, Region id, int state, String detail, int x, int y, int w, int h) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_hline(widget, state, detail, x - this.x0, y - this.y0, w, h);
    }

    public void paintOption(Graphics g, SynthContext context, Region id, String detail, int x, int y, int w, int h) {
        int synthState = context.getComponentState();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_option(widget, synthState, detail, x - this.x0, y - this.y0, w, h);
    }

    public void paintShadow(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h) {
        int gtkState = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int synthState = context.getComponentState();
        int dir = GTKEngine.getTextDirection(context);
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_shadow(widget, gtkState, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, synthState, dir);
    }

    public void paintSlider(Graphics g, SynthContext context, Region id, int state, GTKConstants.ShadowType shadowType, String detail, int x, int y, int w, int h, GTKConstants.Orientation orientation) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_slider(widget, state, shadowType.ordinal(), detail, x - this.x0, y - this.y0, w, h, orientation.ordinal());
    }

    public void paintVline(Graphics g, SynthContext context, Region id, int state, String detail, int x, int y, int w, int h) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_vline(widget, state, detail, x - this.x0, y - this.y0, w, h);
    }

    public void paintBackground(Graphics g, SynthContext context, Region id, int state, Color color, int x, int y, int w, int h) {
        state = GTKLookAndFeel.synthStateToGTKStateType(state).ordinal();
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.native_paint_background(widget, state, x - this.x0, y - this.y0, w, h);
    }

    public boolean paintCachedImage(Graphics g, int x, int y, int w, int h, Object ... args) {
        if (w <= 0 || h <= 0) {
            return true;
        }
        Image img = this.cache.getImage(this.getClass(), null, w, h, args);
        if (img != null) {
            g.drawImage(img, x, y, null);
            return true;
        }
        return false;
    }

    public void startPainting(Graphics g, int x, int y, int w, int h, Object ... args) {
        this.nativeStartPainting(w, h);
        this.x0 = x;
        this.y0 = y;
        this.w0 = w;
        this.h0 = h;
        this.graphics = g;
        this.cacheArgs = args;
    }

    public void finishPainting() {
        this.finishPainting(true);
    }

    public void finishPainting(boolean useCache) {
        DataBufferInt dataBuffer = new DataBufferInt(this.w0 * this.h0);
        int transparency = this.nativeFinishPainting(SunWritableRaster.stealData(dataBuffer, 0), this.w0, this.h0);
        SunWritableRaster.markDirty(dataBuffer);
        int[] bands = BAND_OFFSETS[transparency - 1];
        WritableRaster raster = Raster.createPackedRaster(dataBuffer, this.w0, this.h0, this.w0, bands, null);
        ColorModel cm = COLOR_MODELS[transparency - 1];
        BufferedImage img = new BufferedImage(cm, raster, false, null);
        if (useCache) {
            this.cache.setImage(this.getClass(), null, this.w0, this.h0, this.cacheArgs, img);
        }
        this.graphics.drawImage(img, this.x0, this.y0, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void themeChanged() {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            this.native_switch_theme();
        }
        this.cache.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSetting(Settings property) {
        Object object = UNIXToolkit.GTK_LOCK;
        synchronized (object) {
            return this.native_get_gtk_setting(property.ordinal());
        }
    }

    void setRangeValue(SynthContext context, Region id, double value, double min, double max, double visible) {
        int widget = GTKEngine.getWidgetType(context.getComponent(), id).ordinal();
        this.nativeSetRangeValue(widget, value, min, max, visible);
    }

    static {
        Toolkit.getDefaultToolkit();
        regionToWidgetTypeMap = new HashMap(50);
        regionToWidgetTypeMap.put(Region.ARROW_BUTTON, new WidgetType[]{WidgetType.SPINNER_ARROW_BUTTON, WidgetType.COMBO_BOX_ARROW_BUTTON, WidgetType.HSCROLL_BAR_BUTTON_LEFT, WidgetType.HSCROLL_BAR_BUTTON_RIGHT, WidgetType.VSCROLL_BAR_BUTTON_UP, WidgetType.VSCROLL_BAR_BUTTON_DOWN});
        regionToWidgetTypeMap.put(Region.BUTTON, (Object)WidgetType.BUTTON);
        regionToWidgetTypeMap.put(Region.CHECK_BOX, (Object)WidgetType.CHECK_BOX);
        regionToWidgetTypeMap.put(Region.CHECK_BOX_MENU_ITEM, (Object)WidgetType.CHECK_BOX_MENU_ITEM);
        regionToWidgetTypeMap.put(Region.COLOR_CHOOSER, (Object)WidgetType.COLOR_CHOOSER);
        regionToWidgetTypeMap.put(Region.FILE_CHOOSER, (Object)WidgetType.OPTION_PANE);
        regionToWidgetTypeMap.put(Region.COMBO_BOX, (Object)WidgetType.COMBO_BOX);
        regionToWidgetTypeMap.put(Region.DESKTOP_ICON, (Object)WidgetType.DESKTOP_ICON);
        regionToWidgetTypeMap.put(Region.DESKTOP_PANE, (Object)WidgetType.DESKTOP_PANE);
        regionToWidgetTypeMap.put(Region.EDITOR_PANE, (Object)WidgetType.EDITOR_PANE);
        regionToWidgetTypeMap.put(Region.FORMATTED_TEXT_FIELD, new WidgetType[]{WidgetType.FORMATTED_TEXT_FIELD, WidgetType.SPINNER_TEXT_FIELD});
        regionToWidgetTypeMap.put(GTKRegion.HANDLE_BOX, (Object)WidgetType.HANDLE_BOX);
        regionToWidgetTypeMap.put(Region.INTERNAL_FRAME, (Object)WidgetType.INTERNAL_FRAME);
        regionToWidgetTypeMap.put(Region.INTERNAL_FRAME_TITLE_PANE, (Object)WidgetType.INTERNAL_FRAME_TITLE_PANE);
        regionToWidgetTypeMap.put(Region.LABEL, new WidgetType[]{WidgetType.LABEL, WidgetType.COMBO_BOX_TEXT_FIELD});
        regionToWidgetTypeMap.put(Region.LIST, (Object)WidgetType.LIST);
        regionToWidgetTypeMap.put(Region.MENU, (Object)WidgetType.MENU);
        regionToWidgetTypeMap.put(Region.MENU_BAR, (Object)WidgetType.MENU_BAR);
        regionToWidgetTypeMap.put(Region.MENU_ITEM, (Object)WidgetType.MENU_ITEM);
        regionToWidgetTypeMap.put(Region.MENU_ITEM_ACCELERATOR, (Object)WidgetType.MENU_ITEM_ACCELERATOR);
        regionToWidgetTypeMap.put(Region.OPTION_PANE, (Object)WidgetType.OPTION_PANE);
        regionToWidgetTypeMap.put(Region.PANEL, (Object)WidgetType.PANEL);
        regionToWidgetTypeMap.put(Region.PASSWORD_FIELD, (Object)WidgetType.PASSWORD_FIELD);
        regionToWidgetTypeMap.put(Region.POPUP_MENU, (Object)WidgetType.POPUP_MENU);
        regionToWidgetTypeMap.put(Region.POPUP_MENU_SEPARATOR, (Object)WidgetType.POPUP_MENU_SEPARATOR);
        regionToWidgetTypeMap.put(Region.PROGRESS_BAR, new WidgetType[]{WidgetType.HPROGRESS_BAR, WidgetType.VPROGRESS_BAR});
        regionToWidgetTypeMap.put(Region.RADIO_BUTTON, (Object)WidgetType.RADIO_BUTTON);
        regionToWidgetTypeMap.put(Region.RADIO_BUTTON_MENU_ITEM, (Object)WidgetType.RADIO_BUTTON_MENU_ITEM);
        regionToWidgetTypeMap.put(Region.ROOT_PANE, (Object)WidgetType.ROOT_PANE);
        regionToWidgetTypeMap.put(Region.SCROLL_BAR, new WidgetType[]{WidgetType.HSCROLL_BAR, WidgetType.VSCROLL_BAR});
        regionToWidgetTypeMap.put(Region.SCROLL_BAR_THUMB, new WidgetType[]{WidgetType.HSCROLL_BAR_THUMB, WidgetType.VSCROLL_BAR_THUMB});
        regionToWidgetTypeMap.put(Region.SCROLL_BAR_TRACK, new WidgetType[]{WidgetType.HSCROLL_BAR_TRACK, WidgetType.VSCROLL_BAR_TRACK});
        regionToWidgetTypeMap.put(Region.SCROLL_PANE, (Object)WidgetType.SCROLL_PANE);
        regionToWidgetTypeMap.put(Region.SEPARATOR, new WidgetType[]{WidgetType.HSEPARATOR, WidgetType.VSEPARATOR});
        regionToWidgetTypeMap.put(Region.SLIDER, new WidgetType[]{WidgetType.HSLIDER, WidgetType.VSLIDER});
        regionToWidgetTypeMap.put(Region.SLIDER_THUMB, new WidgetType[]{WidgetType.HSLIDER_THUMB, WidgetType.VSLIDER_THUMB});
        regionToWidgetTypeMap.put(Region.SLIDER_TRACK, new WidgetType[]{WidgetType.HSLIDER_TRACK, WidgetType.VSLIDER_TRACK});
        regionToWidgetTypeMap.put(Region.SPINNER, (Object)WidgetType.SPINNER);
        regionToWidgetTypeMap.put(Region.SPLIT_PANE, (Object)WidgetType.SPLIT_PANE);
        regionToWidgetTypeMap.put(Region.SPLIT_PANE_DIVIDER, new WidgetType[]{WidgetType.HSPLIT_PANE_DIVIDER, WidgetType.VSPLIT_PANE_DIVIDER});
        regionToWidgetTypeMap.put(Region.TABBED_PANE, (Object)WidgetType.TABBED_PANE);
        regionToWidgetTypeMap.put(Region.TABBED_PANE_CONTENT, (Object)WidgetType.TABBED_PANE_CONTENT);
        regionToWidgetTypeMap.put(Region.TABBED_PANE_TAB, (Object)WidgetType.TABBED_PANE_TAB);
        regionToWidgetTypeMap.put(Region.TABBED_PANE_TAB_AREA, (Object)WidgetType.TABBED_PANE_TAB_AREA);
        regionToWidgetTypeMap.put(Region.TABLE, (Object)WidgetType.TABLE);
        regionToWidgetTypeMap.put(Region.TABLE_HEADER, (Object)WidgetType.TABLE_HEADER);
        regionToWidgetTypeMap.put(Region.TEXT_AREA, (Object)WidgetType.TEXT_AREA);
        regionToWidgetTypeMap.put(Region.TEXT_FIELD, new WidgetType[]{WidgetType.TEXT_FIELD, WidgetType.COMBO_BOX_TEXT_FIELD});
        regionToWidgetTypeMap.put(Region.TEXT_PANE, (Object)WidgetType.TEXT_PANE);
        regionToWidgetTypeMap.put(CustomRegion.TITLED_BORDER, (Object)WidgetType.TITLED_BORDER);
        regionToWidgetTypeMap.put(Region.TOGGLE_BUTTON, (Object)WidgetType.TOGGLE_BUTTON);
        regionToWidgetTypeMap.put(Region.TOOL_BAR, (Object)WidgetType.TOOL_BAR);
        regionToWidgetTypeMap.put(Region.TOOL_BAR_CONTENT, (Object)WidgetType.TOOL_BAR);
        regionToWidgetTypeMap.put(Region.TOOL_BAR_DRAG_WINDOW, (Object)WidgetType.TOOL_BAR_DRAG_WINDOW);
        regionToWidgetTypeMap.put(Region.TOOL_BAR_SEPARATOR, (Object)WidgetType.TOOL_BAR_SEPARATOR);
        regionToWidgetTypeMap.put(Region.TOOL_TIP, (Object)WidgetType.TOOL_TIP);
        regionToWidgetTypeMap.put(Region.TREE, (Object)WidgetType.TREE);
        regionToWidgetTypeMap.put(Region.TREE_CELL, (Object)WidgetType.TREE_CELL);
        regionToWidgetTypeMap.put(Region.VIEWPORT, (Object)WidgetType.VIEWPORT);
        COLOR_MODELS = new ColorModel[]{new DirectColorModel(24, 0xFF0000, 65280, 255, 0), new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000), ColorModel.getRGBdefault()};
        BAND_OFFSETS = new int[][]{{0xFF0000, 65280, 255}, {0xFF0000, 65280, 255, 0x1000000}, {0xFF0000, 65280, 255, -16777216}};
    }

    static class CustomRegion
    extends Region {
        static Region TITLED_BORDER = new CustomRegion("TitledBorder");

        private CustomRegion(String name) {
            super(name, null, false);
        }
    }

    static enum Settings {
        GTK_FONT_NAME,
        GTK_ICON_SIZES,
        GTK_CURSOR_BLINK,
        GTK_CURSOR_BLINK_TIME;

    }

    static enum WidgetType {
        BUTTON,
        CHECK_BOX,
        CHECK_BOX_MENU_ITEM,
        COLOR_CHOOSER,
        COMBO_BOX,
        COMBO_BOX_ARROW_BUTTON,
        COMBO_BOX_TEXT_FIELD,
        DESKTOP_ICON,
        DESKTOP_PANE,
        EDITOR_PANE,
        FORMATTED_TEXT_FIELD,
        HANDLE_BOX,
        HPROGRESS_BAR,
        HSCROLL_BAR,
        HSCROLL_BAR_BUTTON_LEFT,
        HSCROLL_BAR_BUTTON_RIGHT,
        HSCROLL_BAR_TRACK,
        HSCROLL_BAR_THUMB,
        HSEPARATOR,
        HSLIDER,
        HSLIDER_TRACK,
        HSLIDER_THUMB,
        HSPLIT_PANE_DIVIDER,
        INTERNAL_FRAME,
        INTERNAL_FRAME_TITLE_PANE,
        IMAGE,
        LABEL,
        LIST,
        MENU,
        MENU_BAR,
        MENU_ITEM,
        MENU_ITEM_ACCELERATOR,
        OPTION_PANE,
        PANEL,
        PASSWORD_FIELD,
        POPUP_MENU,
        POPUP_MENU_SEPARATOR,
        RADIO_BUTTON,
        RADIO_BUTTON_MENU_ITEM,
        ROOT_PANE,
        SCROLL_PANE,
        SPINNER,
        SPINNER_ARROW_BUTTON,
        SPINNER_TEXT_FIELD,
        SPLIT_PANE,
        TABBED_PANE,
        TABBED_PANE_TAB_AREA,
        TABBED_PANE_CONTENT,
        TABBED_PANE_TAB,
        TABLE,
        TABLE_HEADER,
        TEXT_AREA,
        TEXT_FIELD,
        TEXT_PANE,
        TITLED_BORDER,
        TOGGLE_BUTTON,
        TOOL_BAR,
        TOOL_BAR_DRAG_WINDOW,
        TOOL_BAR_SEPARATOR,
        TOOL_TIP,
        TREE,
        TREE_CELL,
        VIEWPORT,
        VPROGRESS_BAR,
        VSCROLL_BAR,
        VSCROLL_BAR_BUTTON_UP,
        VSCROLL_BAR_BUTTON_DOWN,
        VSCROLL_BAR_TRACK,
        VSCROLL_BAR_THUMB,
        VSEPARATOR,
        VSLIDER,
        VSLIDER_TRACK,
        VSLIDER_THUMB,
        VSPLIT_PANE_DIVIDER;

    }
}

