/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.xr;

import sun.java2d.xr.DirtyRegion;
import sun.java2d.xr.GrowableRectArray;

public class XRDrawLine {
    static final int BIG_MAX = 0x1FFFFFFF;
    static final int BIG_MIN = -536870912;
    static final int OUTCODE_TOP = 1;
    static final int OUTCODE_BOTTOM = 2;
    static final int OUTCODE_LEFT = 4;
    static final int OUTCODE_RIGHT = 8;
    int x1;
    int y1;
    int x2;
    int y2;
    int ucX1;
    int ucY1;
    int ucX2;
    int ucY2;
    DirtyRegion region = new DirtyRegion();

    protected void rasterizeLine(GrowableRectArray rectBuffer, int _x1, int _y1, int _x2, int _y2, int cxmin, int cymin, int cxmax, int cymax, boolean clip, boolean overflowCheck) {
        int orthogonalYStep;
        int steps;
        int errminor;
        int errmajor;
        this.initCoordinates(_x1, _y1, _x2, _y2, overflowCheck);
        int dx = this.x2 - this.x1;
        int dy = this.y2 - this.y1;
        int ax = Math.abs(dx);
        int ay = Math.abs(dy);
        boolean xmajor = ax >= ay;
        float diagF = (float)ax / (float)ay;
        if (clip && !this.clipCoordinates(cxmin, cymin, cxmax, cymax, xmajor, dx, dy, ax, ay)) {
            return;
        }
        this.region.setDirtyLineRegion(this.x1, this.y1, this.x2, this.y2);
        int xDiff = this.region.x2 - this.region.x;
        int yDiff = this.region.y2 - this.region.y;
        if (xDiff == 0 || yDiff == 0) {
            rectBuffer.pushRectValues(this.region.x, this.region.y, this.region.x2 - this.region.x + 1, this.region.y2 - this.region.y + 1);
            return;
        }
        if (xmajor) {
            errmajor = ay * 2;
            errminor = ax * 2;
            ax = -ax;
            steps = this.x2 - this.x1;
        } else {
            errmajor = ax * 2;
            errminor = ay * 2;
            ay = -ay;
            steps = this.y2 - this.y1;
        }
        steps = Math.abs(steps) + 1;
        if (steps == 0) {
            return;
        }
        int error = -(errminor / 2);
        if (this.y1 != this.ucY1) {
            int ysteps = this.y1 - this.ucY1;
            if (ysteps < 0) {
                ysteps = -ysteps;
            }
            error += ysteps * ax * 2;
        }
        if (this.x1 != this.ucX1) {
            int xsteps = this.x1 - this.ucX1;
            if (xsteps < 0) {
                xsteps = -xsteps;
            }
            error += xsteps * ay * 2;
        }
        error += errmajor;
        errminor -= errmajor;
        int xStep = dx > 0 ? 1 : -1;
        int yStep = dy > 0 ? 1 : -1;
        int orthogonalXStep = xmajor ? xStep : 0;
        int n = orthogonalYStep = !xmajor ? yStep : 0;
        if ((double)diagF <= 0.9 || (double)diagF >= 1.1) {
            this.lineToRects(rectBuffer, steps, error, errmajor, errminor, xStep, yStep, orthogonalXStep, orthogonalYStep);
        } else {
            this.lineToPoints(rectBuffer, steps, error, errmajor, errminor, xStep, yStep, orthogonalXStep, orthogonalYStep);
        }
    }

    private void lineToPoints(GrowableRectArray rectBuffer, int steps, int error, int errmajor, int errminor, int xStep, int yStep, int orthogonalXStep, int orthogonalYStep) {
        int x = this.x1;
        int y = this.y1;
        do {
            rectBuffer.pushRectValues(x, y, 1, 1);
            if (error < 0) {
                error += errmajor;
                x += orthogonalXStep;
                y += orthogonalYStep;
                continue;
            }
            error -= errminor;
            x += xStep;
            y += yStep;
        } while (--steps > 0);
    }

    private void lineToRects(GrowableRectArray rectBuffer, int steps, int error, int errmajor, int errminor, int xStep, int yStep, int orthogonalXStep, int orthogonalYStep) {
        int x = this.x1;
        int y = this.y1;
        int rectX = Integer.MIN_VALUE;
        int rectY = 0;
        int rectW = 0;
        int rectH = 0;
        do {
            if (y == rectY) {
                if (x == rectX + rectW) {
                    ++rectW;
                } else if (x == rectX - 1) {
                    --rectX;
                    ++rectW;
                }
            } else if (x == rectX) {
                if (y == rectY + rectH) {
                    ++rectH;
                } else if (y == rectY - 1) {
                    --rectY;
                    ++rectH;
                }
            } else {
                if (rectX != Integer.MIN_VALUE) {
                    rectBuffer.pushRectValues(rectX, rectY, rectW, rectH);
                }
                rectX = x;
                rectY = y;
                rectH = 1;
                rectW = 1;
            }
            if (error < 0) {
                error += errmajor;
                x += orthogonalXStep;
                y += orthogonalYStep;
                continue;
            }
            error -= errminor;
            x += xStep;
            y += yStep;
        } while (--steps > 0);
        rectBuffer.pushRectValues(rectX, rectY, rectW, rectH);
    }

    private boolean clipCoordinates(int cxmin, int cymin, int cxmax, int cymax, boolean xmajor, int dx, int dy, int ax, int ay) {
        int outcode1 = this.outcode(this.x1, this.y1, cxmin, cymin, cxmax, cymax);
        int outcode2 = this.outcode(this.x2, this.y2, cxmin, cymin, cxmax, cymax);
        while ((outcode1 | outcode2) != 0) {
            int xsteps = 0;
            int ysteps = 0;
            if ((outcode1 & outcode2) != 0) {
                return false;
            }
            if (outcode1 != 0) {
                if ((outcode1 & 3) != 0) {
                    this.y1 = (outcode1 & 1) != 0 ? cymin : cymax;
                    ysteps = this.y1 - this.ucY1;
                    if (ysteps < 0) {
                        ysteps = -ysteps;
                    }
                    xsteps = 2 * ysteps * ax + ay;
                    if (xmajor) {
                        xsteps += ay - ax - 1;
                    }
                    xsteps /= 2 * ay;
                    if (dx < 0) {
                        xsteps = -xsteps;
                    }
                    this.x1 = this.ucX1 + xsteps;
                } else if ((outcode1 & 0xC) != 0) {
                    this.x1 = (outcode1 & 4) != 0 ? cxmin : cxmax;
                    xsteps = this.x1 - this.ucX1;
                    if (xsteps < 0) {
                        xsteps = -xsteps;
                    }
                    ysteps = 2 * xsteps * ay + ax;
                    if (!xmajor) {
                        ysteps += ax - ay - 1;
                    }
                    ysteps /= 2 * ax;
                    if (dy < 0) {
                        ysteps = -ysteps;
                    }
                    this.y1 = this.ucY1 + ysteps;
                }
                outcode1 = this.outcode(this.x1, this.y1, cxmin, cymin, cxmax, cymax);
                continue;
            }
            if ((outcode2 & 3) != 0) {
                this.y2 = (outcode2 & 1) != 0 ? cymin : cymax;
                ysteps = this.y2 - this.ucY2;
                if (ysteps < 0) {
                    ysteps = -ysteps;
                }
                xsteps = 2 * ysteps * ax + ay;
                xsteps = xmajor ? (xsteps += ay - ax) : --xsteps;
                xsteps /= 2 * ay;
                if (dx > 0) {
                    xsteps = -xsteps;
                }
                this.x2 = this.ucX2 + xsteps;
            } else if ((outcode2 & 0xC) != 0) {
                this.x2 = (outcode2 & 4) != 0 ? cxmin : cxmax;
                xsteps = this.x2 - this.ucX2;
                if (xsteps < 0) {
                    xsteps = -xsteps;
                }
                ysteps = 2 * xsteps * ay + ax;
                ysteps = xmajor ? --ysteps : (ysteps += ax - ay);
                ysteps /= 2 * ax;
                if (dy > 0) {
                    ysteps = -ysteps;
                }
                this.y2 = this.ucY2 + ysteps;
            }
            outcode2 = this.outcode(this.x2, this.y2, cxmin, cymin, cxmax, cymax);
        }
        return true;
    }

    private void initCoordinates(int x1, int y1, int x2, int y2, boolean checkOverflow) {
        if (checkOverflow && (this.OverflowsBig(x1) || this.OverflowsBig(y1) || this.OverflowsBig(x2) || this.OverflowsBig(y2))) {
            double x1d = x1;
            double y1d = y1;
            double x2d = x2;
            double y2d = y2;
            double dxd = x2d - x1d;
            double dyd = y2d - y1d;
            if (x1 < -536870912) {
                y1d = (double)y1 + (double)(-536870912 - x1) * dyd / dxd;
                x1d = -5.36870912E8;
            } else if (x1 > 0x1FFFFFFF) {
                y1d = (double)y1 - (double)(x1 - 0x1FFFFFFF) * dyd / dxd;
                x1d = 5.36870911E8;
            }
            if (y1d < -5.36870912E8) {
                x1d = (double)x1 + (double)(-536870912 - y1) * dxd / dyd;
                y1d = -5.36870912E8;
            } else if (y1d > 5.36870911E8) {
                x1d = (double)x1 - (double)(y1 - 0x1FFFFFFF) * dxd / dyd;
                y1d = 5.36870911E8;
            }
            if (x2 < -536870912) {
                y2d = (double)y2 + (double)(-536870912 - x2) * dyd / dxd;
                x2d = -5.36870912E8;
            } else if (x2 > 0x1FFFFFFF) {
                y2d = (double)y2 - (double)(x2 - 0x1FFFFFFF) * dyd / dxd;
                x2d = 5.36870911E8;
            }
            if (y2d < -5.36870912E8) {
                x2d = (double)x2 + (double)(-536870912 - y2) * dxd / dyd;
                y2d = -5.36870912E8;
            } else if (y2d > 5.36870911E8) {
                x2d = (double)x2 - (double)(y2 - 0x1FFFFFFF) * dxd / dyd;
                y2d = 5.36870911E8;
            }
            x1 = (int)x1d;
            y1 = (int)y1d;
            x2 = (int)x2d;
            y2 = (int)y2d;
        }
        this.x1 = this.ucX1 = x1;
        this.y1 = this.ucY1 = y1;
        this.x2 = this.ucX2 = x2;
        this.y2 = this.ucY2 = y2;
    }

    private boolean OverflowsBig(int v) {
        return v != v << 2 >> 2;
    }

    private int out(int v, int vmin, int vmax, int cmin, int cmax) {
        return v < vmin ? cmin : (v > vmax ? cmax : 0);
    }

    private int outcode(int x, int y, int xmin, int ymin, int xmax, int ymax) {
        return this.out(y, ymin, ymax, 1, 2) | this.out(x, xmin, xmax, 4, 8);
    }
}

