/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipCoder;
import java.util.zip.ZipConstants;
import java.util.zip.ZipEntry;
import java.util.zip.ZipError;
import java.util.zip.ZipException;
import sun.misc.JavaUtilZipFileAccess;
import sun.misc.PerfCounter;
import sun.misc.SharedSecrets;
import sun.misc.VM;

public class ZipFile
implements ZipConstants,
Closeable {
    private long jzfile;
    private final String name;
    private final int total;
    private final boolean locsig;
    private volatile boolean closeRequested = false;
    private static final int STORED = 0;
    private static final int DEFLATED = 8;
    public static final int OPEN_READ = 1;
    public static final int OPEN_DELETE = 4;
    private static final boolean usemmap;
    private ZipCoder zc;
    private final Map<InputStream, Inflater> streams = new WeakHashMap<InputStream, Inflater>();
    private Deque<Inflater> inflaterCache = new ArrayDeque<Inflater>();
    private static final int JZENTRY_NAME = 0;
    private static final int JZENTRY_EXTRA = 1;
    private static final int JZENTRY_COMMENT = 2;

    private static native void initIDs();

    public ZipFile(String name) throws IOException {
        this(new File(name), 1);
    }

    public ZipFile(File file, int mode) throws IOException {
        this(file, mode, StandardCharsets.UTF_8);
    }

    public ZipFile(File file) throws ZipException, IOException {
        this(file, 1);
    }

    public ZipFile(File file, int mode, Charset charset) throws IOException {
        if ((mode & 1) == 0 || (mode & 0xFFFFFFFA) != 0) {
            throw new IllegalArgumentException("Illegal mode: 0x" + Integer.toHexString(mode));
        }
        String name = file.getPath();
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkRead(name);
            if ((mode & 4) != 0) {
                sm.checkDelete(name);
            }
        }
        if (charset == null) {
            throw new NullPointerException("charset is null");
        }
        this.zc = ZipCoder.get(charset);
        long t0 = System.nanoTime();
        this.jzfile = ZipFile.open(name, mode, file.lastModified(), usemmap);
        PerfCounter.getZipFileOpenTime().addElapsedTimeFrom(t0);
        PerfCounter.getZipFileCount().increment();
        this.name = name;
        this.total = ZipFile.getTotal(this.jzfile);
        this.locsig = ZipFile.startsWithLOC(this.jzfile);
    }

    public ZipFile(String name, Charset charset) throws IOException {
        this(new File(name), 1, charset);
    }

    public ZipFile(File file, Charset charset) throws IOException {
        this(file, 1, charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getComment() {
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            byte[] bcomm = ZipFile.getCommentBytes(this.jzfile);
            if (bcomm == null) {
                return null;
            }
            return this.zc.toString(bcomm, bcomm.length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry getEntry(String name) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        long jzentry = 0L;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            jzentry = ZipFile.getEntry(this.jzfile, this.zc.getBytes(name), true);
            if (jzentry != 0L) {
                ZipEntry ze = this.getZipEntry(name, jzentry);
                ZipFile.freeEntry(this.jzfile, jzentry);
                return ze;
            }
        }
        return null;
    }

    private static native long getEntry(long var0, byte[] var2, boolean var3);

    private static native void freeEntry(long var0, long var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        if (entry == null) {
            throw new NullPointerException("entry");
        }
        long jzentry = 0L;
        ZipFileInputStream in = null;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            this.ensureOpen();
            jzentry = !this.zc.isUTF8() && (entry.flag & 0x800) != 0 ? ZipFile.getEntry(this.jzfile, this.zc.getBytesUTF8(entry.name), false) : ZipFile.getEntry(this.jzfile, this.zc.getBytes(entry.name), false);
            if (jzentry == 0L) {
                return null;
            }
            in = new ZipFileInputStream(jzentry);
            switch (ZipFile.getEntryMethod(jzentry)) {
                case 0: {
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(in, null);
                    }
                    return in;
                }
                case 8: {
                    long size = ZipFile.getEntrySize(jzentry) + 2L;
                    if (size > 65536L) {
                        size = 8192L;
                    }
                    if (size <= 0L) {
                        size = 4096L;
                    }
                    Inflater inf = this.getInflater();
                    ZipFileInflaterInputStream is = new ZipFileInflaterInputStream(in, inf, (int)size);
                    Map<InputStream, Inflater> map = this.streams;
                    synchronized (map) {
                        this.streams.put(is, inf);
                    }
                    return is;
                }
            }
            throw new ZipException("invalid compression method");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Inflater getInflater() {
        Deque<Inflater> deque = this.inflaterCache;
        synchronized (deque) {
            Inflater inf;
            while (null != (inf = this.inflaterCache.poll())) {
                if (inf.ended()) continue;
                return inf;
            }
        }
        return new Inflater(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseInflater(Inflater inf) {
        if (!inf.ended()) {
            inf.reset();
            Deque<Inflater> deque = this.inflaterCache;
            synchronized (deque) {
                this.inflaterCache.add(inf);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Enumeration<? extends ZipEntry> entries() {
        return new ZipEntryIterator();
    }

    public Stream<? extends ZipEntry> stream() {
        return StreamSupport.stream(Spliterators.spliterator(new ZipEntryIterator(), (long)this.size(), 1297), false);
    }

    private ZipEntry getZipEntry(String name, long jzentry) {
        ZipEntry e = new ZipEntry();
        e.flag = ZipFile.getEntryFlag(jzentry);
        if (name != null) {
            e.name = name;
        } else {
            byte[] bname = ZipFile.getEntryBytes(jzentry, 0);
            e.name = !this.zc.isUTF8() && (e.flag & 0x800) != 0 ? this.zc.toStringUTF8(bname, bname.length) : this.zc.toString(bname, bname.length);
        }
        e.xdostime = ZipFile.getEntryTime(jzentry);
        e.crc = ZipFile.getEntryCrc(jzentry);
        e.size = ZipFile.getEntrySize(jzentry);
        e.csize = ZipFile.getEntryCSize(jzentry);
        e.method = ZipFile.getEntryMethod(jzentry);
        e.setExtra0(ZipFile.getEntryBytes(jzentry, 1), false);
        byte[] bcomm = ZipFile.getEntryBytes(jzentry, 2);
        e.comment = bcomm == null ? null : (!this.zc.isUTF8() && (e.flag & 0x800) != 0 ? this.zc.toStringUTF8(bcomm, bcomm.length) : this.zc.toString(bcomm, bcomm.length));
        return e;
    }

    private static native long getNextEntry(long var0, int var2);

    public int size() {
        this.ensureOpen();
        return this.total;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (this.closeRequested) {
            return;
        }
        this.closeRequested = true;
        ZipFile zipFile = this;
        synchronized (zipFile) {
            Object copy;
            Map<InputStream, Inflater> map = this.streams;
            synchronized (map) {
                if (!this.streams.isEmpty()) {
                    copy = new HashMap<InputStream, Inflater>(this.streams);
                    this.streams.clear();
                    for (Map.Entry e : copy.entrySet()) {
                        ((InputStream)e.getKey()).close();
                        Inflater inf = (Inflater)e.getValue();
                        if (inf == null) continue;
                        inf.end();
                    }
                }
            }
            copy = this.inflaterCache;
            synchronized (copy) {
                Inflater inf;
                while (null != (inf = this.inflaterCache.poll())) {
                    inf.end();
                }
            }
            if (this.jzfile != 0L) {
                long zf = this.jzfile;
                this.jzfile = 0L;
                ZipFile.close(zf);
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void close(long var0);

    private void ensureOpen() {
        if (this.closeRequested) {
            throw new IllegalStateException("zip file closed");
        }
        if (this.jzfile == 0L) {
            throw new IllegalStateException("The object is not initialized.");
        }
    }

    private void ensureOpenOrZipException() throws IOException {
        if (this.closeRequested) {
            throw new ZipException("ZipFile closed");
        }
    }

    private boolean startsWithLocHeader() {
        return this.locsig;
    }

    private static native long open(String var0, int var1, long var2, boolean var4) throws IOException;

    private static native int getTotal(long var0);

    private static native boolean startsWithLOC(long var0);

    private static native int read(long var0, long var2, long var4, byte[] var6, int var7, int var8);

    private static native long getEntryTime(long var0);

    private static native long getEntryCrc(long var0);

    private static native long getEntryCSize(long var0);

    private static native long getEntrySize(long var0);

    private static native int getEntryMethod(long var0);

    private static native int getEntryFlag(long var0);

    private static native byte[] getCommentBytes(long var0);

    private static native byte[] getEntryBytes(long var0, int var2);

    private static native String getZipMessage(long var0);

    static {
        ZipFile.initIDs();
        String prop = VM.getSavedProperty("sun.zip.disableMemoryMapping");
        usemmap = prop == null || prop.length() != 0 && !prop.equalsIgnoreCase("true");
        SharedSecrets.setJavaUtilZipFileAccess(new JavaUtilZipFileAccess(){

            @Override
            public boolean startsWithLocHeader(ZipFile zip) {
                return zip.startsWithLocHeader();
            }
        });
    }

    private class ZipFileInputStream
    extends InputStream {
        private volatile boolean zfisCloseRequested = false;
        protected long jzentry;
        private long pos = 0L;
        protected long rem;
        protected long size;

        ZipFileInputStream(long jzentry) {
            this.rem = ZipFile.getEntryCSize(jzentry);
            this.size = ZipFile.getEntrySize(jzentry);
            this.jzentry = jzentry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                long rem = this.rem;
                long pos = this.pos;
                if (rem == 0L) {
                    return -1;
                }
                if (len <= 0) {
                    return 0;
                }
                if ((long)len > rem) {
                    len = (int)rem;
                }
                ZipFile.this.ensureOpenOrZipException();
                len = ZipFile.read(ZipFile.this.jzfile, this.jzentry, pos, b, off, len);
                if (len > 0) {
                    this.pos = pos + (long)len;
                    this.rem = rem - (long)len;
                }
            }
            if (this.rem == 0L) {
                this.close();
            }
            return len;
        }

        @Override
        public int read() throws IOException {
            byte[] b = new byte[1];
            if (this.read(b, 0, 1) == 1) {
                return b[0] & 0xFF;
            }
            return -1;
        }

        @Override
        public long skip(long n) {
            if (n > this.rem) {
                n = this.rem;
            }
            this.pos += n;
            this.rem -= n;
            if (this.rem == 0L) {
                this.close();
            }
            return n;
        }

        @Override
        public int available() {
            return this.rem > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)this.rem;
        }

        public long size() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (this.zfisCloseRequested) {
                return;
            }
            this.zfisCloseRequested = true;
            this.rem = 0L;
            Object object = ZipFile.this;
            synchronized (object) {
                if (this.jzentry != 0L && ZipFile.this.jzfile != 0L) {
                    ZipFile.freeEntry(ZipFile.this.jzfile, this.jzentry);
                    this.jzentry = 0L;
                }
            }
            object = ZipFile.this.streams;
            synchronized (object) {
                ZipFile.this.streams.remove(this);
            }
        }

        protected void finalize() {
            this.close();
        }
    }

    private class ZipEntryIterator
    implements Enumeration<ZipEntry>,
    Iterator<ZipEntry> {
        private int i = 0;

        public ZipEntryIterator() {
            ZipFile.this.ensureOpen();
        }

        @Override
        public boolean hasMoreElements() {
            return this.hasNext();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                return this.i < ZipFile.this.total;
            }
        }

        @Override
        public ZipEntry nextElement() {
            return this.next();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ZipEntry next() {
            ZipFile zipFile = ZipFile.this;
            synchronized (zipFile) {
                ZipFile.this.ensureOpen();
                if (this.i >= ZipFile.this.total) {
                    throw new NoSuchElementException();
                }
                long jzentry = ZipFile.getNextEntry(ZipFile.this.jzfile, this.i++);
                if (jzentry == 0L) {
                    String message = ZipFile.this.closeRequested ? "ZipFile concurrently closed" : ZipFile.getZipMessage(ZipFile.this.jzfile);
                    throw new ZipError("jzentry == 0,\n jzfile = " + ZipFile.this.jzfile + ",\n total = " + ZipFile.this.total + ",\n name = " + ZipFile.this.name + ",\n i = " + this.i + ",\n message = " + message);
                }
                ZipEntry ze = ZipFile.this.getZipEntry(null, jzentry);
                ZipFile.freeEntry(ZipFile.this.jzfile, jzentry);
                return ze;
            }
        }
    }

    private class ZipFileInflaterInputStream
    extends InflaterInputStream {
        private volatile boolean closeRequested;
        private boolean eof;
        private final ZipFileInputStream zfin;

        ZipFileInflaterInputStream(ZipFileInputStream zfin, Inflater inf, int size) {
            super(zfin, inf, size);
            this.closeRequested = false;
            this.eof = false;
            this.zfin = zfin;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            Inflater inf;
            if (this.closeRequested) {
                return;
            }
            this.closeRequested = true;
            super.close();
            Map map = ZipFile.this.streams;
            synchronized (map) {
                inf = (Inflater)ZipFile.this.streams.remove(this);
            }
            if (inf != null) {
                ZipFile.this.releaseInflater(inf);
            }
        }

        @Override
        protected void fill() throws IOException {
            if (this.eof) {
                throw new EOFException("Unexpected end of ZLIB input stream");
            }
            this.len = this.in.read(this.buf, 0, this.buf.length);
            if (this.len == -1) {
                this.buf[0] = 0;
                this.len = 1;
                this.eof = true;
            }
            this.inf.setInput(this.buf, 0, this.len);
        }

        @Override
        public int available() throws IOException {
            if (this.closeRequested) {
                return 0;
            }
            long avail = this.zfin.size() - this.inf.getBytesWritten();
            return avail > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)avail;
        }

        protected void finalize() throws Throwable {
            this.close();
        }
    }
}

