/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.ua;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Arrays;

public abstract class DSTU4145PointEncoder {
    private static BigInteger trace(ECFieldElement fe) {
        ECFieldElement t = fe;
        for (int i = 0; i < fe.getFieldSize() - 1; ++i) {
            t = t.square().add(fe);
        }
        return t.toBigInteger();
    }

    private static ECFieldElement solveQuadraticEquation(ECCurve curve, ECFieldElement beta) {
        if (beta.isZero()) {
            return beta;
        }
        ECFieldElement zeroElement = curve.fromBigInteger(ECConstants.ZERO);
        ECFieldElement z = null;
        ECFieldElement gamma = null;
        Random rand = new Random();
        int m = beta.getFieldSize();
        do {
            ECFieldElement t = curve.fromBigInteger(new BigInteger(m, rand));
            z = zeroElement;
            ECFieldElement w = beta;
            for (int i = 1; i <= m - 1; ++i) {
                ECFieldElement w2 = w.square();
                z = z.square().add(w2.multiply(t));
                w = w2.add(beta);
            }
            if (w.isZero()) continue;
            return null;
        } while ((gamma = z.square().add(z)).isZero());
        return z;
    }

    public static byte[] encodePoint(ECPoint Q) {
        Q = Q.normalize();
        ECFieldElement x = Q.getAffineXCoord();
        byte[] bytes = x.getEncoded();
        if (!x.isZero()) {
            ECFieldElement y = Q.getAffineYCoord().divide(x);
            if (DSTU4145PointEncoder.trace(y).equals(ECConstants.ONE)) {
                int n = bytes.length - 1;
                bytes[n] = (byte)(bytes[n] | 1);
            } else {
                int n = bytes.length - 1;
                bytes[n] = (byte)(bytes[n] & 0xFE);
            }
        }
        return bytes;
    }

    public static ECPoint decodePoint(ECCurve curve, byte[] bytes) {
        BigInteger k = BigInteger.valueOf(bytes[bytes.length - 1] & 1);
        if (!DSTU4145PointEncoder.trace(curve.fromBigInteger(new BigInteger(1, bytes))).equals(curve.getA().toBigInteger())) {
            bytes = Arrays.clone(bytes);
            int n = bytes.length - 1;
            bytes[n] = (byte)(bytes[n] ^ 1);
        }
        ECFieldElement xp = curve.fromBigInteger(new BigInteger(1, bytes));
        ECFieldElement yp = null;
        if (xp.isZero()) {
            yp = (ECFieldElement.F2m)curve.getB();
            for (int i = 0; i < curve.getFieldSize() - 1; ++i) {
                yp = ((ECFieldElement)yp).square();
            }
        } else {
            ECFieldElement beta = xp.add(curve.getA()).add(curve.getB().multiply(xp.square().invert()));
            ECFieldElement z = DSTU4145PointEncoder.solveQuadraticEquation(curve, beta);
            if (z == null) {
                throw new RuntimeException("Invalid point compression");
            }
            if (!DSTU4145PointEncoder.trace(z).equals(k)) {
                z = z.addOne();
            }
            yp = xp.multiply(z);
        }
        return new ECPoint.F2m(curve, xp, yp);
    }
}

