/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.bouncycastle.jce.PrincipalUtil;
import org.bouncycastle.jce.X509Principal;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.AttrCertTest;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.util.test.SimpleTest;
import org.bouncycastle.x509.X509AttributeCertStoreSelector;
import org.bouncycastle.x509.X509CRLStoreSelector;
import org.bouncycastle.x509.X509CertPairStoreSelector;
import org.bouncycastle.x509.X509CertStoreSelector;
import org.bouncycastle.x509.X509CertificatePair;
import org.bouncycastle.x509.X509CollectionStoreParameters;
import org.bouncycastle.x509.X509Store;
import org.bouncycastle.x509.X509StoreParameters;
import org.bouncycastle.x509.X509V2AttributeCertificate;

public class X509StoreTest
extends SimpleTest {
    private void certPairTest() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CertificatePair pair1 = new X509CertificatePair(rootCert, interCert);
        ArrayList<X509CertificatePair> certList = new ArrayList<X509CertificatePair>();
        certList.add(pair1);
        certList.add(new X509CertificatePair(interCert, finalCert));
        X509CollectionStoreParameters ccsp = new X509CollectionStoreParameters(certList);
        X509Store certStore = X509Store.getInstance("CertificatePair/Collection", (X509StoreParameters)ccsp, "BC");
        X509CertPairStoreSelector selector = new X509CertPairStoreSelector();
        X509CertStoreSelector fwSelector = new X509CertStoreSelector();
        fwSelector.setSerialNumber(rootCert.getSerialNumber());
        fwSelector.setSubject(rootCert.getIssuerDN().getName());
        selector.setForwardSelector(fwSelector);
        Collection col = certStore.getMatches(selector);
        if (col.size() != 1 || !col.contains(pair1)) {
            this.fail("failed pair1 test");
        }
        if ((col = certStore.getMatches(null)).size() != 2) {
            this.fail("failed null test");
        }
    }

    @Override
    public void performTest() throws Exception {
        Collection attrs;
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        certList.add(rootCert);
        certList.add(interCert);
        certList.add(finalCert);
        X509CollectionStoreParameters ccsp = new X509CollectionStoreParameters(certList);
        X509Store certStore = X509Store.getInstance("Certificate/Collection", (X509StoreParameters)ccsp, "BC");
        X509Principal.DefaultReverse = true;
        X509CertStoreSelector targetConstraints = new X509CertStoreSelector();
        targetConstraints.setSubject(PrincipalUtil.getSubjectX509Principal(rootCert).getEncoded());
        Collection certs = certStore.getMatches(targetConstraints);
        if (certs.size() != 1 || !certs.contains(rootCert)) {
            this.fail("rootCert not found by subjectDN");
        }
        targetConstraints = new X509CertStoreSelector();
        targetConstraints.setSubject(PrincipalUtil.getSubjectX509Principal(rootCert).getEncoded());
        certs = certStore.getMatches(targetConstraints);
        if (certs.size() != 1 || !certs.contains(rootCert)) {
            this.fail("rootCert not found by encoded subjectDN");
        }
        X509Principal.DefaultReverse = false;
        targetConstraints = new X509CertStoreSelector();
        targetConstraints.setSubjectPublicKey(rootCert.getPublicKey().getEncoded());
        certs = certStore.getMatches(targetConstraints);
        if (certs.size() != 1 || !certs.contains(rootCert)) {
            this.fail("rootCert not found by encoded public key");
        }
        targetConstraints = new X509CertStoreSelector();
        targetConstraints.setIssuer(PrincipalUtil.getSubjectX509Principal(rootCert).getEncoded());
        certs = certStore.getMatches(targetConstraints);
        if (certs.size() != 2) {
            this.fail("did not found 2 certs");
        }
        if (!certs.contains(rootCert)) {
            this.fail("rootCert not found");
        }
        if (!certs.contains(interCert)) {
            this.fail("interCert not found");
        }
        ArrayList<X509CRL> crlList = new ArrayList<X509CRL>();
        crlList.add(rootCrl);
        crlList.add(interCrl);
        ccsp = new X509CollectionStoreParameters(crlList);
        X509Store store = X509Store.getInstance("CRL/Collection", (X509StoreParameters)ccsp, "BC");
        X509CRLStoreSelector targetConstraintsCRL = new X509CRLStoreSelector();
        targetConstraintsCRL.setIssuers(Collections.singleton(rootCrl.getIssuerX500Principal()));
        Collection crls = store.getMatches(targetConstraintsCRL);
        if (crls.size() != 1 || !crls.contains(rootCrl)) {
            this.fail("rootCrl not found");
        }
        if ((crls = certStore.getMatches(targetConstraintsCRL)).size() != 0) {
            this.fail("error using wrong selector (CRL)");
        }
        if ((certs = store.getMatches(targetConstraints)).size() != 0) {
            this.fail("error using wrong selector (certs)");
        }
        X509V2AttributeCertificate attrCert = new X509V2AttributeCertificate(AttrCertTest.attrCert);
        X509V2AttributeCertificate attrCert2 = new X509V2AttributeCertificate(AttrCertTest.certWithBaseCertificateID);
        ArrayList<X509V2AttributeCertificate> attrList = new ArrayList<X509V2AttributeCertificate>();
        attrList.add(attrCert);
        attrList.add(attrCert2);
        ccsp = new X509CollectionStoreParameters(attrList);
        store = X509Store.getInstance("AttributeCertificate/Collection", (X509StoreParameters)ccsp, "BC");
        X509AttributeCertStoreSelector attrSelector = new X509AttributeCertStoreSelector();
        attrSelector.setHolder(attrCert.getHolder());
        if (!attrSelector.getHolder().equals(attrCert.getHolder())) {
            this.fail("holder get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert)) {
            this.fail("attrCert not found on holder");
        }
        attrSelector.setHolder(attrCert2.getHolder());
        if (attrSelector.getHolder().equals(attrCert.getHolder())) {
            this.fail("holder get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert2)) {
            this.fail("attrCert2 not found on holder");
        }
        attrSelector = new X509AttributeCertStoreSelector();
        attrSelector.setIssuer(attrCert.getIssuer());
        if (!attrSelector.getIssuer().equals(attrCert.getIssuer())) {
            this.fail("issuer get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert)) {
            this.fail("attrCert not found on issuer");
        }
        attrSelector.setIssuer(attrCert2.getIssuer());
        if (attrSelector.getIssuer().equals(attrCert.getIssuer())) {
            this.fail("issuer get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert2)) {
            this.fail("attrCert2 not found on issuer");
        }
        attrSelector = new X509AttributeCertStoreSelector();
        attrSelector.setAttributeCert(attrCert);
        if (!attrSelector.getAttributeCert().equals(attrCert)) {
            this.fail("attrCert get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert)) {
            this.fail("attrCert not found on attrCert");
        }
        attrSelector = new X509AttributeCertStoreSelector();
        attrSelector.setSerialNumber(attrCert.getSerialNumber());
        if (!attrSelector.getSerialNumber().equals(attrCert.getSerialNumber())) {
            this.fail("serial number get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert)) {
            this.fail("attrCert not found on serial number");
        }
        if (!(attrSelector = (X509AttributeCertStoreSelector)attrSelector.clone()).getSerialNumber().equals(attrCert.getSerialNumber())) {
            this.fail("serial number get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert)) {
            this.fail("attrCert not found on serial number");
        }
        attrSelector = new X509AttributeCertStoreSelector();
        attrSelector.setAttributeCertificateValid(attrCert.getNotBefore());
        if (!attrSelector.getAttributeCertificateValid().equals(attrCert.getNotBefore())) {
            this.fail("valid get not correct");
        }
        if ((attrs = store.getMatches(attrSelector)).size() != 1 || !attrs.contains(attrCert)) {
            this.fail("attrCert not found on valid");
        }
        attrSelector = new X509AttributeCertStoreSelector();
        attrSelector.setAttributeCertificateValid(new Date(attrCert.getNotBefore().getTime() - 100L));
        attrs = store.getMatches(attrSelector);
        if (attrs.size() != 0) {
            this.fail("attrCert found on before");
        }
        attrSelector.setAttributeCertificateValid(new Date(attrCert.getNotAfter().getTime() + 100L));
        attrs = store.getMatches(attrSelector);
        if (attrs.size() != 0) {
            this.fail("attrCert found on after");
        }
        attrSelector.setSerialNumber(BigInteger.valueOf(10000L));
        attrs = store.getMatches(attrSelector);
        if (attrs.size() != 0) {
            this.fail("attrCert found on wrong serial number");
        }
        attrSelector.setAttributeCert(null);
        attrSelector.setAttributeCertificateValid(null);
        attrSelector.setHolder(null);
        attrSelector.setIssuer(null);
        attrSelector.setSerialNumber(null);
        if (attrSelector.getAttributeCert() != null) {
            this.fail("null attrCert");
        }
        if (attrSelector.getAttributeCertificateValid() != null) {
            this.fail("null attrCertValid");
        }
        if (attrSelector.getHolder() != null) {
            this.fail("null attrCert holder");
        }
        if (attrSelector.getIssuer() != null) {
            this.fail("null attrCert issuer");
        }
        if (attrSelector.getSerialNumber() != null) {
            this.fail("null attrCert serial");
        }
        if ((attrs = certStore.getMatches(attrSelector)).size() != 0) {
            this.fail("error using wrong selector (attrs)");
        }
        this.certPairTest();
    }

    @Override
    public String getName() {
        return "X509Store";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        X509StoreTest.runTest(new X509StoreTest());
    }
}

