/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.Security;
import java.security.cert.CertPath;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CRL;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.provider.test.CertPathTest;
import org.bouncycastle.jce.provider.test.TestUtils;
import org.bouncycastle.util.test.SimpleTest;

public class CertPathBuilderTest
extends SimpleTest {
    private void baseTest() throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
        X509Certificate rootCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.rootCertBin));
        X509Certificate interCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.interCertBin));
        X509Certificate finalCert = (X509Certificate)cf.generateCertificate(new ByteArrayInputStream(CertPathTest.finalCertBin));
        X509CRL rootCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.rootCrlBin));
        X509CRL interCrl = (X509CRL)cf.generateCRL(new ByteArrayInputStream(CertPathTest.interCrlBin));
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(rootCert);
        list.add(interCert);
        list.add(finalCert);
        list.add(rootCrl);
        list.add(interCrl);
        CollectionCertStoreParameters ccsp = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", (CertStoreParameters)ccsp, "BC");
        Calendar validDate = Calendar.getInstance();
        validDate.set(2008, 8, 4, 14, 49, 10);
        HashSet<TrustAnchor> trust = new HashSet<TrustAnchor>();
        trust.add(new TrustAnchor(rootCert, null));
        CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX", "BC");
        X509CertSelector targetConstraints = new X509CertSelector();
        targetConstraints.setSubject(finalCert.getSubjectX500Principal().getEncoded());
        PKIXBuilderParameters params = new PKIXBuilderParameters(trust, (CertSelector)targetConstraints);
        params.addCertStore(store);
        params.setDate(validDate.getTime());
        PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)cpb.build(params);
        CertPath path = result.getCertPath();
        if (path.getCertificates().size() != 2) {
            this.fail("wrong number of certs in baseTest path");
        }
    }

    private void v0Test() throws Exception {
        KeyPair rootPair = TestUtils.generateRSAKeyPair();
        KeyPair interPair = TestUtils.generateRSAKeyPair();
        KeyPair endPair = TestUtils.generateRSAKeyPair();
        X509Certificate rootCert = TestUtils.generateRootCert(rootPair);
        X509Certificate interCert = TestUtils.generateIntermediateCert(interPair.getPublic(), rootPair.getPrivate(), rootCert);
        X509Certificate endCert = TestUtils.generateEndEntityCert(endPair.getPublic(), interPair.getPrivate(), interCert);
        BigInteger revokedSerialNumber = BigInteger.valueOf(2L);
        X509CRL rootCRL = TestUtils.createCRL(rootCert, rootPair.getPrivate(), revokedSerialNumber);
        X509CRL interCRL = TestUtils.createCRL(interCert, interPair.getPrivate(), revokedSerialNumber);
        ArrayList<X509Extension> list = new ArrayList<X509Extension>();
        list.add(rootCert);
        list.add(interCert);
        list.add(endCert);
        list.add(rootCRL);
        list.add(interCRL);
        CollectionCertStoreParameters params = new CollectionCertStoreParameters(list);
        CertStore store = CertStore.getInstance("Collection", params);
        CertPathBuilder builder = CertPathBuilder.getInstance("PKIX", "BC");
        X509CertSelector pathConstraints = new X509CertSelector();
        pathConstraints.setSubject(endCert.getSubjectX500Principal().getEncoded());
        PKIXBuilderParameters buildParams = new PKIXBuilderParameters(Collections.singleton(new TrustAnchor(rootCert, null)), (CertSelector)pathConstraints);
        buildParams.addCertStore(store);
        buildParams.setDate(new Date());
        PKIXCertPathBuilderResult result = (PKIXCertPathBuilderResult)builder.build(buildParams);
        CertPath path = result.getCertPath();
        if (path.getCertificates().size() != 2) {
            this.fail("wrong number of certs in v0Test path");
        }
    }

    @Override
    public void performTest() throws Exception {
        this.baseTest();
        this.v0Test();
    }

    @Override
    public String getName() {
        return "CertPathBuilder";
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        CertPathBuilderTest.runTest(new CertPathBuilderTest());
    }
}

