/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider.test;

import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.Security;
import javax.crypto.Cipher;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.IESEngine;
import org.bouncycastle.crypto.generators.KDF2BytesGenerator;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.paddings.PaddedBufferedBlockCipher;
import org.bouncycastle.jcajce.provider.asymmetric.ec.IESCipher;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.IESParameterSpec;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.test.SimpleTest;

public class ECIESTest
extends SimpleTest {
    ECIESTest() {
    }

    @Override
    public String getName() {
        return "ECIES";
    }

    @Override
    public void performTest() throws Exception {
        byte[] derivation = Hex.decode("202122232425262728292a2b2c2d2e2f");
        byte[] encoding = Hex.decode("303132333435363738393a3b3c3d3e3f");
        IESCipher c1 = new IESCipher.ECIES();
        IESCipher c2 = new IESCipher.ECIES();
        IESParameterSpec params = new IESParameterSpec(derivation, encoding, 128);
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC", "BC");
        this.doTest("ECIES with default", g, "ECIES", params);
        g.initialize(192, new SecureRandom());
        this.doTest("ECIES with 192-bit", g, "ECIES", params);
        g.initialize(256, new SecureRandom());
        this.doTest("ECIES with 256-bit", g, "ECIES", params);
        c1 = new IESCipher(new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), new PaddedBufferedBlockCipher(new DESEngine())));
        c2 = new IESCipher(new IESEngine(new ECDHBasicAgreement(), new KDF2BytesGenerator(new SHA1Digest()), new HMac(new SHA1Digest()), new PaddedBufferedBlockCipher(new DESEngine())));
        params = new IESParameterSpec(derivation, encoding, 128, 128);
        g = KeyPairGenerator.getInstance("EC", "BC");
        this.doTest("default", g, "ECIESwithDESEDE", params);
        g.initialize(192, new SecureRandom());
        this.doTest("192-bit", g, "ECIESwithDESEDE", params);
        g.initialize(256, new SecureRandom());
        this.doTest("256-bit", g, "ECIESwithDESEDE", params);
        c1 = new IESCipher.ECIESwithAES();
        c2 = new IESCipher.ECIESwithAES();
        params = new IESParameterSpec(derivation, encoding, 128, 128);
        g = KeyPairGenerator.getInstance("EC", "BC");
        this.doTest("default", g, "ECIESwithAES", params);
        g.initialize(192, new SecureRandom());
        this.doTest("192-bit", g, "ECIESwithAES", params);
        g.initialize(256, new SecureRandom());
        this.doTest("256-bit", g, "ECIESwithAES", params);
    }

    public void doTest(String testname, KeyPairGenerator g, String cipher, IESParameterSpec p) throws Exception {
        byte[] message = Hex.decode("0102030405060708090a0b0c0d0e0f10111213141516");
        KeyPair KeyPair2 = g.generateKeyPair();
        ECPublicKey Pub = (ECPublicKey)KeyPair2.getPublic();
        ECPrivateKey Priv = (ECPrivateKey)KeyPair2.getPrivate();
        Cipher c1 = Cipher.getInstance(cipher);
        Cipher c2 = Cipher.getInstance(cipher);
        c1.init(1, (Key)Pub, new SecureRandom());
        c2.init(2, (Key)Priv, new SecureRandom());
        byte[] out1 = c1.doFinal(message, 0, message.length);
        byte[] out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with null parameters, DHAES mode false.");
        }
        c1.init(1, (Key)Pub, p, new SecureRandom());
        c2.init(2, (Key)Priv, p, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode false.");
        }
        c1 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c2 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding", "BC");
        c1.init(1, (Key)Pub, new SecureRandom());
        c2.init(2, (Key)Priv, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with null parameters, DHAES mode true.");
        }
        c1 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding");
        c2 = Cipher.getInstance(cipher + "/DHAES/PKCS7Padding");
        c1.init(1, (Key)Pub, p, new SecureRandom());
        c2.init(2, (Key)Priv, p, new SecureRandom());
        out1 = c1.doFinal(message, 0, message.length);
        out2 = c2.doFinal(out1, 0, out1.length);
        if (!this.areEqual(out2, message)) {
            this.fail(testname + " test failed with non-null parameters, DHAES mode true.");
        }
    }

    public static void main(String[] args) {
        Security.addProvider(new BouncyCastleProvider());
        ECIESTest.runTest(new ECIESTest());
    }
}

