/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.datatransfer;

import java.awt.EventQueue;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.FlavorTable;
import java.awt.datatransfer.SystemFlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import sun.awt.AppContext;
import sun.awt.EventListenerAggregate;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;
import sun.awt.datatransfer.ClipboardTransferable;
import sun.awt.datatransfer.DataTransferer;
import sun.awt.datatransfer.TransferableProxy;

public abstract class SunClipboard
extends Clipboard
implements PropertyChangeListener {
    private AppContext contentsContext = null;
    private final Object CLIPBOARD_FLAVOR_LISTENER_KEY;
    private volatile int numberOfFlavorListeners = 0;
    private volatile long[] currentFormats;

    public SunClipboard(String name) {
        super(name);
        this.CLIPBOARD_FLAVOR_LISTENER_KEY = new StringBuffer(name + "_CLIPBOARD_FLAVOR_LISTENER_KEY");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        if (contents == null) {
            throw new NullPointerException("contents");
        }
        this.initContext();
        ClipboardOwner oldOwner = this.owner;
        Transferable oldContents = this.contents;
        try {
            this.owner = owner;
            this.contents = new TransferableProxy(contents, true);
            this.setContentsNative(contents);
            if (oldOwner == null || oldOwner == owner) return;
        }
        catch (Throwable throwable) {
            if (oldOwner == null || oldOwner == owner) throw throwable;
            EventQueue.invokeLater(new Runnable(oldOwner, oldContents){
                final /* synthetic */ ClipboardOwner val$oldOwner;
                final /* synthetic */ Transferable val$oldContents;
                {
                    this.val$oldOwner = clipboardOwner;
                    this.val$oldContents = transferable;
                }

                @Override
                public void run() {
                    this.val$oldOwner.lostOwnership(SunClipboard.this, this.val$oldContents);
                }
            });
            throw throwable;
        }
        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void initContext() {
        AppContext context = AppContext.getAppContext();
        if (this.contentsContext != context) {
            AppContext appContext = context;
            synchronized (appContext) {
                if (context.isDisposed()) {
                    throw new IllegalStateException("Can't set contents from disposed AppContext");
                }
                context.addPropertyChangeListener("disposed", this);
            }
            if (this.contentsContext != null) {
                this.contentsContext.removePropertyChangeListener("disposed", this);
            }
            this.contentsContext = context;
        }
    }

    @Override
    public synchronized Transferable getContents(Object requestor) {
        if (this.contents != null) {
            return this.contents;
        }
        return new ClipboardTransferable(this);
    }

    protected synchronized Transferable getContextContents() {
        AppContext context = AppContext.getAppContext();
        return context == this.contentsContext ? this.contents : null;
    }

    @Override
    public DataFlavor[] getAvailableDataFlavors() {
        Transferable cntnts = this.getContextContents();
        if (cntnts != null) {
            return cntnts.getTransferDataFlavors();
        }
        long[] formats = this.getClipboardFormatsOpenClose();
        return DataTransferer.getInstance().getFlavorsForFormatsAsArray(formats, SunClipboard.getDefaultFlavorTable());
    }

    @Override
    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        if (flavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable cntnts = this.getContextContents();
        if (cntnts != null) {
            return cntnts.isDataFlavorSupported(flavor);
        }
        long[] formats = this.getClipboardFormatsOpenClose();
        return SunClipboard.formatArrayAsDataFlavorSet(formats).contains(flavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == null) {
            throw new NullPointerException("flavor");
        }
        Transferable cntnts = this.getContextContents();
        if (cntnts != null) {
            return cntnts.getTransferData(flavor);
        }
        long format = 0L;
        byte[] data = null;
        Transferable localeTransferable = null;
        try {
            this.openClipboard(null);
            long[] formats = this.getClipboardFormats();
            Long lFormat = (Long)DataTransferer.getInstance().getFlavorsForFormats(formats, SunClipboard.getDefaultFlavorTable()).get(flavor);
            if (lFormat == null) {
                throw new UnsupportedFlavorException(flavor);
            }
            format = lFormat;
            data = this.getClipboardData(format);
            if (DataTransferer.getInstance().isLocaleDependentTextFormat(format)) {
                localeTransferable = this.createLocaleTransferable(formats);
            }
        }
        finally {
            this.closeClipboard();
        }
        return DataTransferer.getInstance().translateBytes(data, flavor, format, localeTransferable);
    }

    protected Transferable createLocaleTransferable(long[] formats) throws IOException {
        return null;
    }

    public void openClipboard(SunClipboard newOwner) {
    }

    public void closeClipboard() {
    }

    public abstract long getID();

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("disposed".equals(evt.getPropertyName()) && Boolean.TRUE.equals(evt.getNewValue())) {
            AppContext disposedContext = (AppContext)evt.getSource();
            this.lostOwnershipLater(disposedContext);
        }
    }

    protected void lostOwnershipImpl() {
        this.lostOwnershipLater(null);
    }

    protected void lostOwnershipLater(AppContext disposedContext) {
        AppContext context = this.contentsContext;
        if (context == null) {
            return;
        }
        SunToolkit.postEvent(context, new PeerEvent(this, () -> this.lostOwnershipNow(disposedContext), 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lostOwnershipNow(AppContext disposedContext) {
        SunClipboard sunClipboard = this;
        ClipboardOwner owner = null;
        Transferable contents = null;
        SunClipboard sunClipboard2 = sunClipboard;
        synchronized (sunClipboard2) {
            AppContext context = sunClipboard.contentsContext;
            if (context == null) {
                return;
            }
            if (disposedContext != null && context != disposedContext) {
                return;
            }
            owner = sunClipboard.owner;
            contents = sunClipboard.contents;
            sunClipboard.contentsContext = null;
            sunClipboard.owner = null;
            sunClipboard.contents = null;
            sunClipboard.clearNativeContext();
            context.removePropertyChangeListener("disposed", sunClipboard);
        }
        if (owner != null) {
            owner.lostOwnership(sunClipboard, contents);
        }
    }

    protected abstract void clearNativeContext();

    protected abstract void setContentsNative(Transferable var1);

    protected long[] getClipboardFormatsOpenClose() {
        try {
            this.openClipboard(null);
            long[] lArray = this.getClipboardFormats();
            return lArray;
        }
        finally {
            this.closeClipboard();
        }
    }

    protected abstract long[] getClipboardFormats();

    protected abstract byte[] getClipboardData(long var1) throws IOException;

    private static Set formatArrayAsDataFlavorSet(long[] formats) {
        return formats == null ? null : DataTransferer.getInstance().getFlavorsForFormatsAsSet(formats, SunClipboard.getDefaultFlavorTable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void addFlavorListener(FlavorListener listener) {
        if (listener == null) {
            return;
        }
        AppContext appContext = AppContext.getAppContext();
        EventListenerAggregate contextFlavorListeners = (EventListenerAggregate)appContext.get(this.CLIPBOARD_FLAVOR_LISTENER_KEY);
        if (contextFlavorListeners == null) {
            contextFlavorListeners = new EventListenerAggregate(FlavorListener.class);
            appContext.put(this.CLIPBOARD_FLAVOR_LISTENER_KEY, contextFlavorListeners);
        }
        contextFlavorListeners.add(listener);
        if (this.numberOfFlavorListeners++ == 0) {
            long[] currentFormats = null;
            try {
                this.openClipboard(null);
                currentFormats = this.getClipboardFormats();
            }
            catch (IllegalStateException illegalStateException) {
            }
            finally {
                this.closeClipboard();
            }
            this.currentFormats = currentFormats;
            this.registerClipboardViewerChecked();
        }
    }

    @Override
    public synchronized void removeFlavorListener(FlavorListener listener) {
        if (listener == null) {
            return;
        }
        AppContext appContext = AppContext.getAppContext();
        EventListenerAggregate contextFlavorListeners = (EventListenerAggregate)appContext.get(this.CLIPBOARD_FLAVOR_LISTENER_KEY);
        if (contextFlavorListeners == null) {
            return;
        }
        if (contextFlavorListeners.remove(listener) && --this.numberOfFlavorListeners == 0) {
            this.unregisterClipboardViewerChecked();
            this.currentFormats = null;
        }
    }

    @Override
    public synchronized FlavorListener[] getFlavorListeners() {
        EventListenerAggregate contextFlavorListeners = (EventListenerAggregate)AppContext.getAppContext().get(this.CLIPBOARD_FLAVOR_LISTENER_KEY);
        return contextFlavorListeners == null ? new FlavorListener[]{} : (FlavorListener[])contextFlavorListeners.getListenersCopy();
    }

    public boolean areFlavorListenersRegistered() {
        return this.numberOfFlavorListeners > 0;
    }

    protected abstract void registerClipboardViewerChecked();

    protected abstract void unregisterClipboardViewerChecked();

    protected final void checkChange(long[] formats) {
        if (Arrays.equals(formats, this.currentFormats)) {
            return;
        }
        this.currentFormats = formats;
        for (AppContext appContext : AppContext.getAppContexts()) {
            EventListenerAggregate flavorListeners;
            if (appContext == null || appContext.isDisposed() || (flavorListeners = (EventListenerAggregate)appContext.get(this.CLIPBOARD_FLAVOR_LISTENER_KEY)) == null) continue;
            FlavorListener[] flavorListenerArray = (FlavorListener[])flavorListeners.getListenersInternal();
            for (int i = 0; i < flavorListenerArray.length; ++i) {
                class SunFlavorChangeNotifier
                implements Runnable {
                    private final FlavorListener flavorListener;

                    SunFlavorChangeNotifier(FlavorListener flavorListener) {
                        this.flavorListener = flavorListener;
                    }

                    @Override
                    public void run() {
                        if (this.flavorListener != null) {
                            this.flavorListener.flavorsChanged(new FlavorEvent(SunClipboard.this));
                        }
                    }
                }
                SunToolkit.postEvent(appContext, new PeerEvent(this, new SunFlavorChangeNotifier(flavorListenerArray[i]), 1L));
            }
        }
    }

    public static FlavorTable getDefaultFlavorTable() {
        return (FlavorTable)SystemFlavorMap.getDefaultFlavorMap();
    }
}

