/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers;

import eu.emi.security.authn.x509.helpers.JavaAndBCStyle;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;

public class CertificateHelpers {
    private static final byte[] TEST = new byte[]{1, 2, 3, 4, 100};

    public static PEMContentsType getPEMType(String name) {
        if (name.contains("CERTIFICATE") && !name.contains("REQUEST")) {
            return PEMContentsType.CERTIFICATE;
        }
        if (name.equals("PRIVATE KEY")) {
            return PEMContentsType.PRIVATE_KEY;
        }
        if (name.equals("ENCRYPTED PRIVATE KEY")) {
            return PEMContentsType.PRIVATE_KEY;
        }
        if (name.contains("PRIVATE KEY")) {
            return PEMContentsType.LEGACY_OPENSSL_PRIVATE_KEY;
        }
        if (name.contains("REQUEST") && name.contains("CERTIFICATE")) {
            return PEMContentsType.CSR;
        }
        if (name.contains("CRL")) {
            return PEMContentsType.CRL;
        }
        return PEMContentsType.UNKNOWN;
    }

    public static Collection<? extends Certificate> readDERCertificates(InputStream input) throws IOException {
        CertificateFactory factory = CertificateHelpers.getFactory();
        try {
            Collection<? extends Certificate> collection = factory.generateCertificates(input);
            return collection;
        }
        catch (CertificateException e) {
            throw new IOException("Can not parse the input data as a certificate", e);
        }
        catch (ClassCastException e) {
            throw new IOException("Can not parse the input as it contains a certificate but it is not an X.509 certificate.", e);
        }
        finally {
            input.close();
        }
    }

    public static Certificate readDERCertificate(InputStream input) throws IOException {
        CertificateFactory factory = CertificateHelpers.getFactory();
        try {
            Certificate certificate = factory.generateCertificate(input);
            return certificate;
        }
        catch (CertificateException e) {
            throw new IOException("Can not parse the input data as a certificate", e);
        }
        catch (ClassCastException e) {
            throw new IOException("Can not parse the input as it contains a certificate but it is not an X.509 certificate.", e);
        }
        finally {
            input.close();
        }
    }

    private static CertificateFactory getFactory() {
        try {
            return CertificateFactory.getInstance("X.509", "BC");
        }
        catch (CertificateException e) {
            throw new RuntimeException("Can not initialize CertificateFactory, your JDK installation is misconfigured!", e);
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("Can not initialize CertificateFactory, no BouncyCastle provider, it is a BUG!", e);
        }
    }

    public static X509Certificate[] sortChain(List<X509Certificate> certificates) throws IOException {
        X509Certificate child;
        X509Certificate parent;
        if (certificates.size() == 0) {
            return new X509Certificate[0];
        }
        HashMap<X500Principal, X509Certificate> certsMapBySubject = new HashMap<X500Principal, X509Certificate>();
        HashMap<X500Principal, X509Certificate> certsMapByIssuer = new HashMap<X500Principal, X509Certificate>();
        for (X509Certificate c : certificates) {
            certsMapBySubject.put(c.getSubjectX500Principal(), c);
            if (c.getIssuerX500Principal().equals(c.getSubjectX500Principal())) continue;
            certsMapByIssuer.put(c.getIssuerX500Principal(), c);
        }
        LinkedList<X509Certificate> certsList = new LinkedList<X509Certificate>();
        X509Certificate current = (X509Certificate)certsMapBySubject.remove(certificates.get(0).getSubjectX500Principal());
        if (!current.getIssuerX500Principal().equals(current.getSubjectX500Principal())) {
            certsMapByIssuer.remove(current.getIssuerX500Principal());
        }
        certsList.add(current);
        while ((parent = (X509Certificate)certsMapBySubject.remove(current.getIssuerX500Principal())) != null) {
            certsMapByIssuer.remove(parent.getIssuerX500Principal());
            certsList.add(parent);
            current = parent;
        }
        current = (X509Certificate)certsList.get(0);
        while ((child = (X509Certificate)certsMapByIssuer.remove(current.getSubjectX500Principal())) != null) {
            certsList.add(0, child);
            current = child;
        }
        if (certsMapByIssuer.size() > 0) {
            throw new IOException("The keystore is inconsistent as it contains certificates from different chains");
        }
        return certsList.toArray(new X509Certificate[certsList.size()]);
    }

    public static CertPath toCertPath(X509Certificate[] in) throws CertificateException {
        CertificateFactory certFactory;
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException("No provider supporting X.509 CertificateFactory. JDK is misconfigured?", e);
        }
        return certFactory.generateCertPath(Arrays.asList(in));
    }

    public static X500Name toX500Name(X500Principal srcDn) {
        X500Name withDefaultStyle = X500Name.getInstance((Object)srcDn.getEncoded());
        JavaAndBCStyle style = new JavaAndBCStyle();
        return new X500Name((X500NameStyle)style, withDefaultStyle);
    }

    public static byte[] getExtensionBytes(X509Certificate cert, String oid) throws IOException {
        byte[] bytes = cert.getExtensionValue(oid);
        if (bytes == null) {
            return null;
        }
        DEROctetString valueOctets = (DEROctetString)ASN1Primitive.fromByteArray((byte[])bytes);
        return valueOctets.getOctets();
    }

    public static void checkKeysMatching(PrivateKey privKey, PublicKey pubKey) throws InvalidKeyException {
        String algorithm = pubKey.getAlgorithm();
        if (!privKey.getAlgorithm().equals(algorithm)) {
            throw new InvalidKeyException("Private and public keys are not matching: different algorithms");
        }
        if (algorithm.equals("DSA")) {
            if (!CertificateHelpers.checkKeysViaSignature("SHA1withDSA", privKey, pubKey)) {
                throw new InvalidKeyException("Private and public keys are not matching: DSA");
            }
        } else if (algorithm.equals("RSA")) {
            RSAPublicKey rpub = (RSAPublicKey)pubKey;
            RSAPrivateKey rpriv = (RSAPrivateKey)privKey;
            if (!rpub.getModulus().equals(rpriv.getModulus())) {
                throw new InvalidKeyException("Private and public keys are not matching: RSA parameters");
            }
        } else if (algorithm.equals("GOST3410")) {
            if (!CertificateHelpers.checkKeysViaSignature("GOST3411withGOST3410", privKey, pubKey)) {
                throw new InvalidKeyException("Private and public keys are not matching: GOST 34.10");
            }
        } else if (algorithm.equals("ECGOST3410")) {
            if (!CertificateHelpers.checkKeysViaSignature("GOST3411withECGOST3410", privKey, pubKey)) {
                throw new InvalidKeyException("Private and public keys are not matching: EC GOST 34.10");
            }
        } else if (algorithm.equals("ECDSA") && !CertificateHelpers.checkKeysViaSignature("SHA1withECDSA", privKey, pubKey)) {
            throw new InvalidKeyException("Private and public keys are not matching: EC DSA");
        }
    }

    private static boolean checkKeysViaSignature(String alg, PrivateKey privKey, PublicKey pubKey) throws InvalidKeyException {
        try {
            Signature s = Signature.getInstance(alg);
            s.initSign(privKey);
            s.update(TEST);
            byte[] signature = s.sign();
            Signature s2 = Signature.getInstance(alg);
            s2.initVerify(pubKey);
            s2.update(TEST);
            return s2.verify(signature);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Bug: BC provider not available in checkKeysMatching()", e);
        }
        catch (SignatureException e) {
            throw new RuntimeException("Bug: can't sign/verify test data", e);
        }
    }

    public static enum PEMContentsType {
        PRIVATE_KEY,
        LEGACY_OPENSSL_PRIVATE_KEY,
        CERTIFICATE,
        CSR,
        CRL,
        UNKNOWN;

    }
}

