/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.ns;

import eu.emi.security.authn.x509.StoreUpdateListener;
import eu.emi.security.authn.x509.helpers.CachedElement;
import eu.emi.security.authn.x509.helpers.ObserversHandler;
import eu.emi.security.authn.x509.helpers.ns.NamespacePolicy;
import eu.emi.security.authn.x509.helpers.ns.NamespacesParser;
import eu.emi.security.authn.x509.helpers.ns.NamespacesStore;
import eu.emi.security.authn.x509.helpers.trust.OpensslTruststoreHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.x500.X500Principal;

public abstract class AbstractNamespacesStore
implements NamespacesStore {
    private static final List<NamespacePolicy> EMPTY = Collections.emptyList();
    protected final ObserversHandler observers;
    protected boolean openssl1Mode;

    public AbstractNamespacesStore(ObserversHandler observers, boolean openssl1Mode) {
        this.openssl1Mode = openssl1Mode;
        this.observers = observers;
    }

    protected abstract String getNotificationType();

    protected abstract NamespacesParser getParser(String var1);

    protected abstract String getFileSuffix();

    protected List<NamespacePolicy> tryLoadNsPath(String path) {
        if (path == null) {
            return EMPTY;
        }
        NamespacesParser parser = this.getParser(path);
        try {
            List<NamespacePolicy> ret = parser.parse();
            this.observers.notifyObservers(path, this.getNotificationType(), StoreUpdateListener.Severity.NOTIFICATION, null);
            return ret;
        }
        catch (FileNotFoundException ret) {
        }
        catch (IOException e) {
            this.observers.notifyObservers(path, this.getNotificationType(), StoreUpdateListener.Severity.ERROR, e);
        }
        return EMPTY;
    }

    protected void tryLoadNsLocation(String location, List<NamespacePolicy> policies) {
        String path = OpensslTruststoreHelper.getNsFile(location, this.getFileSuffix());
        policies.addAll(this.tryLoadNsPath(path));
    }

    protected void addPolicy(NamespacePolicy policy, Map<String, Map<String, List<NamespacePolicy>>> policies) {
        String definedFor = policy.getDefinedFor();
        Map<String, List<NamespacePolicy>> current = policies.get(definedFor);
        if (current == null) {
            current = new HashMap<String, List<NamespacePolicy>>();
            policies.put(definedFor, current);
        }
        this.addPolicyToMap(policy, current);
    }

    protected void addPolicyToMap(NamespacePolicy policy, Map<String, List<NamespacePolicy>> map) {
        String issuer = policy.getIssuer();
        List<NamespacePolicy> currentList = map.get(issuer);
        if (currentList == null) {
            currentList = new ArrayList<NamespacePolicy>();
            map.put(issuer, currentList);
        }
        currentList.add(policy);
    }

    @Override
    public List<NamespacePolicy> getPolicies(X509Certificate[] chain, int position) {
        X500Principal[] issuers = new X500Principal[chain.length];
        for (int i = position; i < chain.length; ++i) {
            issuers[i] = chain[i].getIssuerX500Principal();
        }
        return this.getPolicies(issuers, position);
    }

    protected List<NamespacePolicy> getCachedPolicies(Map<String, CachedElement<Map<String, List<NamespacePolicy>>>> policies, String definedForHash, String issuer, String path, long maxTTL) {
        CachedElement<Map<String, List<NamespacePolicy>>> cachedEntry = policies.get(definedForHash);
        if (cachedEntry != null && !cachedEntry.isExpired(maxTTL)) {
            Map<String, List<NamespacePolicy>> policiesMap = cachedEntry.getElement();
            return policiesMap.get(issuer);
        }
        List<NamespacePolicy> loaded = this.tryLoadNsPath(path);
        if (loaded != null) {
            HashMap<String, List<NamespacePolicy>> current = new HashMap<String, List<NamespacePolicy>>();
            for (NamespacePolicy policy : loaded) {
                this.addPolicyToMap(policy, current);
            }
            policies.put(definedForHash, new CachedElement(current));
        }
        return loaded;
    }
}

