/*
 * Decompiled with CFR 0.152.
 */
package eu.emi.security.authn.x509.helpers.proxy;

import eu.emi.security.authn.x509.helpers.CertificateHelpers;
import eu.emi.security.authn.x509.helpers.proxy.ExtendedProxyType;
import eu.emi.security.authn.x509.helpers.proxy.ProxyCertInfoExtension;
import eu.emi.security.authn.x509.proxy.ProxyPolicy;
import java.io.IOException;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class ProxyHelper {
    public static ExtendedProxyType getProxyType(X509Certificate certificate) {
        String value;
        if (certificate.getExtensionValue("1.3.6.1.5.5.7.1.14") != null && certificate.getExtensionValue("1.3.6.1.5.5.7.1.14").length > 0) {
            return ExtendedProxyType.RFC3820;
        }
        if (certificate.getExtensionValue("1.3.6.1.4.1.3536.1.222") != null && certificate.getExtensionValue("1.3.6.1.4.1.3536.1.222").length > 0) {
            return ExtendedProxyType.DRAFT_RFC;
        }
        try {
            value = ProxyHelper.getLastCN(certificate.getSubjectX500Principal());
        }
        catch (IllegalArgumentException e) {
            value = "";
        }
        if ("proxy".equals(value.toLowerCase()) || "limited proxy".equals(value.toLowerCase())) {
            return ExtendedProxyType.LEGACY;
        }
        return ExtendedProxyType.NOT_A_PROXY;
    }

    public static String getLastCN(X500Principal principal) throws IllegalArgumentException {
        X500Name x500Name = CertificateHelpers.toX500Name(principal);
        return ProxyHelper.getLastCN(x500Name);
    }

    public static String getLastCN(X500Name x500Name) throws IllegalArgumentException {
        RDN[] rdns = x500Name.getRDNs();
        if (rdns.length == 0) {
            throw new IllegalArgumentException("The DN is empty");
        }
        RDN last = rdns[rdns.length - 1];
        if (last.isMultiValued()) {
            throw new IllegalArgumentException("The DN is ended with a multivalued RDN");
        }
        AttributeTypeAndValue cn = last.getFirst();
        if (!cn.getType().equals((Object)BCStyle.CN)) {
            throw new IllegalArgumentException("The DN is not ended with a CN AVA");
        }
        return IETFUtils.valueToString((ASN1Encodable)cn.getValue());
    }

    public static int getProxyPathLimit(X509Certificate cert) throws IOException {
        ProxyCertInfoExtension info = ProxyCertInfoExtension.getInstance(cert);
        if (info == null) {
            return Integer.MAX_VALUE;
        }
        return info.getProxyPathLimit();
    }

    public static boolean isLimited(X509Certificate cert) throws IOException {
        ExtendedProxyType type = ProxyHelper.getProxyType(cert);
        if (type == ExtendedProxyType.RFC3820 || type == ExtendedProxyType.DRAFT_RFC) {
            ProxyCertInfoExtension ext = ProxyCertInfoExtension.getInstance(cert);
            ProxyPolicy policy = ext.getPolicy();
            return "1.3.6.1.4.1.3536.1.1.1.9".equals(policy.getPolicyOID());
        }
        if (type == ExtendedProxyType.LEGACY) {
            String cn;
            try {
                cn = ProxyHelper.getLastCN(cert.getSubjectX500Principal());
            }
            catch (IllegalArgumentException e) {
                cn = "";
            }
            return "limited proxy".equals(cn.toLowerCase());
        }
        return false;
    }
}

