/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.Attribute;
import com.sun.java.util.jar.pack.PackerImpl;
import com.sun.java.util.jar.pack.Utils;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

final class PropMap
implements SortedMap<String, String> {
    private final TreeMap<String, String> theMap = new TreeMap();
    private final List<Object> listenerList = new ArrayList<Object>(1);
    private static Map<String, String> defaultProps;

    void addListener(Object listener) {
        assert (Beans.isPropertyChangeListener(listener));
        this.listenerList.add(listener);
    }

    void removeListener(Object listener) {
        assert (Beans.isPropertyChangeListener(listener));
        this.listenerList.remove(listener);
    }

    @Override
    public String put(String key, String value) {
        String oldValue = this.theMap.put(key, value);
        if (value != oldValue && !this.listenerList.isEmpty()) {
            assert (Beans.isBeansPresent());
            Object event = Beans.newPropertyChangeEvent(this, key, oldValue, value);
            for (Object listener : this.listenerList) {
                Beans.invokePropertyChange(listener, event);
            }
        }
        return oldValue;
    }

    PropMap() {
        this.theMap.putAll(defaultProps);
    }

    SortedMap<String, String> prefixMap(String prefix) {
        int len = prefix.length();
        if (len == 0) {
            return this;
        }
        char nextch = (char)(prefix.charAt(len - 1) + '\u0001');
        String limit = prefix.substring(0, len - 1) + nextch;
        return this.subMap(prefix, limit);
    }

    String getProperty(String s) {
        return this.get(s);
    }

    String getProperty(String s, String defaultVal) {
        String val = this.getProperty(s);
        if (val == null) {
            return defaultVal;
        }
        return val;
    }

    String setProperty(String s, String val) {
        return this.put(s, val);
    }

    List<String> getProperties(String prefix) {
        Collection<String> values = this.prefixMap(prefix).values();
        ArrayList<String> res = new ArrayList<String>(values.size());
        res.addAll(values);
        while (res.remove(null)) {
        }
        return res;
    }

    private boolean toBoolean(String val) {
        return Boolean.valueOf(val);
    }

    boolean getBoolean(String s) {
        return this.toBoolean(this.getProperty(s));
    }

    boolean setBoolean(String s, boolean val) {
        return this.toBoolean(this.setProperty(s, String.valueOf(val)));
    }

    int toInteger(String val) {
        return this.toInteger(val, 0);
    }

    int toInteger(String val, int def) {
        if (val == null) {
            return def;
        }
        if ("true".equals(val)) {
            return 1;
        }
        if ("false".equals(val)) {
            return 0;
        }
        return Integer.parseInt(val);
    }

    int getInteger(String s, int def) {
        return this.toInteger(this.getProperty(s), def);
    }

    int getInteger(String s) {
        return this.toInteger(this.getProperty(s));
    }

    int setInteger(String s, int val) {
        return this.toInteger(this.setProperty(s, String.valueOf(val)));
    }

    long toLong(String val) {
        try {
            return val == null ? 0L : Long.parseLong(val);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Invalid value");
        }
    }

    long getLong(String s) {
        return this.toLong(this.getProperty(s));
    }

    long setLong(String s, long val) {
        return this.toLong(this.setProperty(s, String.valueOf(val)));
    }

    int getTime(String s) {
        String sval = this.getProperty(s, "0");
        if ("now".equals(sval)) {
            return (int)((System.currentTimeMillis() + 500L) / 1000L);
        }
        long lval = this.toLong(sval);
        long recentSecondCount = 1000000000L;
        if (lval < 10000000000L && !"0".equals(sval)) {
            Utils.log.warning("Supplied modtime appears to be seconds rather than milliseconds: " + sval);
        }
        return (int)((lval + 500L) / 1000L);
    }

    void list(PrintStream out) {
        PrintWriter outw = new PrintWriter(out);
        this.list(outw);
        outw.flush();
    }

    void list(PrintWriter out) {
        out.println("#PACK200[");
        Set<Map.Entry<String, String>> defaults = defaultProps.entrySet();
        for (Map.Entry<String, String> e : this.theMap.entrySet()) {
            if (defaults.contains(e)) continue;
            out.println("  " + e.getKey() + " = " + e.getValue());
        }
        out.println("#]");
    }

    @Override
    public int size() {
        return this.theMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.theMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.theMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.theMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.theMap.get(key);
    }

    @Override
    public String remove(Object key) {
        return this.theMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.theMap.putAll(m);
    }

    @Override
    public void clear() {
        this.theMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.theMap.keySet();
    }

    @Override
    public Collection<String> values() {
        return this.theMap.values();
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return this.theMap.entrySet();
    }

    @Override
    public Comparator<? super String> comparator() {
        return this.theMap.comparator();
    }

    @Override
    public SortedMap<String, String> subMap(String fromKey, String toKey) {
        return this.theMap.subMap(fromKey, toKey);
    }

    @Override
    public SortedMap<String, String> headMap(String toKey) {
        return this.theMap.headMap(toKey);
    }

    @Override
    public SortedMap<String, String> tailMap(String fromKey) {
        return this.theMap.tailMap(fromKey);
    }

    @Override
    public String firstKey() {
        return this.theMap.firstKey();
    }

    @Override
    public String lastKey() {
        return this.theMap.lastKey();
    }

    static {
        Properties props = new Properties();
        props.put("com.sun.java.util.jar.pack.disable.native", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.disable.native")));
        props.put("com.sun.java.util.jar.pack.verbose", String.valueOf(Integer.getInteger("com.sun.java.util.jar.pack.verbose", 0)));
        props.put("com.sun.java.util.jar.pack.default.timezone", String.valueOf(Boolean.getBoolean("com.sun.java.util.jar.pack.default.timezone")));
        props.put("pack.segment.limit", "-1");
        props.put("pack.keep.file.order", "true");
        props.put("pack.modification.time", "keep");
        props.put("pack.deflate.hint", "keep");
        props.put("pack.unknown.attribute", "pass");
        props.put("com.sun.java.util.jar.pack.class.format.error", System.getProperty("com.sun.java.util.jar.pack.class.format.error", "pass"));
        props.put("pack.effort", "5");
        String propFile = "intrinsic.properties";
        try {
            Throwable throwable = null;
            try (InputStream propStr = PackerImpl.class.getResourceAsStream(propFile);){
                if (propStr == null) {
                    throw new RuntimeException(propFile + " cannot be loaded");
                }
                props.load(propStr);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
        }
        catch (IOException ee) {
            throw new RuntimeException(ee);
        }
        for (Map.Entry entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            if (!key.startsWith("attribute.")) continue;
            entry.setValue(Attribute.normalizeLayoutString(val));
        }
        HashMap<Object, Object> temp = new HashMap<Object, Object>(props);
        defaultProps = temp;
    }

    private static class Beans {
        private static final Class<?> propertyChangeListenerClass = Beans.getClass("java.beans.PropertyChangeListener");
        private static final Class<?> propertyChangeEventClass = Beans.getClass("java.beans.PropertyChangeEvent");
        private static final Method propertyChangeMethod = Beans.getMethod(propertyChangeListenerClass, "propertyChange", propertyChangeEventClass);
        private static final Constructor<?> propertyEventCtor = Beans.getConstructor(propertyChangeEventClass, Object.class, String.class, Object.class, Object.class);

        private Beans() {
        }

        private static Class<?> getClass(String name) {
            try {
                return Class.forName(name, true, Beans.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        private static Constructor<?> getConstructor(Class<?> c, Class<?> ... types) {
            try {
                return c == null ? null : c.getDeclaredConstructor(types);
            }
            catch (NoSuchMethodException x) {
                throw new AssertionError((Object)x);
            }
        }

        private static Method getMethod(Class<?> c, String name, Class<?> ... types) {
            try {
                return c == null ? null : c.getMethod(name, types);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }

        static boolean isBeansPresent() {
            return propertyChangeListenerClass != null && propertyChangeEventClass != null;
        }

        static boolean isPropertyChangeListener(Object obj) {
            if (propertyChangeListenerClass == null) {
                return false;
            }
            return propertyChangeListenerClass.isInstance(obj);
        }

        static Object newPropertyChangeEvent(Object source, String prop, Object oldValue, Object newValue) {
            try {
                return propertyEventCtor.newInstance(source, prop, oldValue, newValue);
            }
            catch (IllegalAccessException | InstantiationException x) {
                throw new AssertionError((Object)x);
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new AssertionError((Object)x);
            }
        }

        static void invokePropertyChange(Object listener, Object ev) {
            try {
                propertyChangeMethod.invoke(listener, ev);
            }
            catch (IllegalAccessException x) {
                throw new AssertionError((Object)x);
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof Error) {
                    throw (Error)cause;
                }
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                throw new AssertionError((Object)x);
            }
        }
    }
}

