/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.util.jar.pack;

import com.sun.java.util.jar.pack.ClassWriter;
import com.sun.java.util.jar.pack.NativeUnpack;
import com.sun.java.util.jar.pack.Package;
import com.sun.java.util.jar.pack.PackageReader;
import com.sun.java.util.jar.pack.TLGlobals;
import com.sun.java.util.jar.pack.Utils;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;

public class UnpackerImpl
extends TLGlobals
implements Pack200.Unpacker {
    Object _nunp;

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.props.addListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.props.removeListener(listener);
    }

    @Override
    public SortedMap<String, String> properties() {
        return this.props;
    }

    public String toString() {
        return Utils.getVersionString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void unpack(InputStream in, JarOutputStream out) throws IOException {
        block13: {
            if (in == null) {
                throw new NullPointerException("null input");
            }
            if (out == null) {
                throw new NullPointerException("null output");
            }
            assert (Utils.currentInstance.get() == null);
            boolean needUTC = !this.props.getBoolean("com.sun.java.util.jar.pack.default.timezone");
            try {
                Utils.currentInstance.set(this);
                if (needUTC) {
                    Utils.changeDefaultTimeZoneToUtc();
                }
                int verbose = this.props.getInteger("com.sun.java.util.jar.pack.verbose");
                BufferedInputStream in0 = new BufferedInputStream(in);
                if (Utils.isJarMagic(Utils.readMagic(in0))) {
                    if (verbose > 0) {
                        Utils.log.info("Copying unpacked JAR file...");
                    }
                    Utils.copyJarFile(new JarInputStream(in0), out);
                    break block13;
                }
                if (this.props.getBoolean("com.sun.java.util.jar.pack.disable.native")) {
                    new DoUnpack().run(in0, out);
                    in0.close();
                    Utils.markJarFile(out);
                    break block13;
                }
                try {
                    new NativeUnpack(this).run(in0, out);
                }
                catch (NoClassDefFoundError | UnsatisfiedLinkError ex) {
                    new DoUnpack().run(in0, out);
                }
                in0.close();
                Utils.markJarFile(out);
            }
            finally {
                this._nunp = null;
                Utils.currentInstance.set(null);
                if (needUTC) {
                    Utils.restoreDefaultTimeZone();
                }
            }
        }
    }

    @Override
    public synchronized void unpack(File in, JarOutputStream out) throws IOException {
        if (in == null) {
            throw new NullPointerException("null input");
        }
        if (out == null) {
            throw new NullPointerException("null output");
        }
        try (FileInputStream instr = new FileInputStream(in);){
            this.unpack(instr, out);
        }
        if (this.props.getBoolean("com.sun.java.util.jar.pack.unpack.remove.packfile")) {
            in.delete();
        }
    }

    private class DoUnpack {
        final int verbose;
        final Package pkg;
        final boolean keepModtime;
        final boolean keepDeflateHint;
        final int modtime;
        final boolean deflateHint;
        final CRC32 crc;
        final ByteArrayOutputStream bufOut;
        final OutputStream crcOut;

        private DoUnpack() {
            this.verbose = UnpackerImpl.this.props.getInteger("com.sun.java.util.jar.pack.verbose");
            UnpackerImpl.this.props.setInteger("unpack.progress", 0);
            this.pkg = new Package();
            this.keepModtime = "keep".equals(UnpackerImpl.this.props.getProperty("com.sun.java.util.jar.pack.unpack.modification.time", "keep"));
            this.keepDeflateHint = "keep".equals(UnpackerImpl.this.props.getProperty("unpack.deflate.hint", "keep"));
            this.modtime = !this.keepModtime ? UnpackerImpl.this.props.getTime("com.sun.java.util.jar.pack.unpack.modification.time") : this.pkg.default_modtime;
            this.deflateHint = this.keepDeflateHint ? false : UnpackerImpl.this.props.getBoolean("unpack.deflate.hint");
            this.crc = new CRC32();
            this.bufOut = new ByteArrayOutputStream();
            this.crcOut = new CheckedOutputStream(this.bufOut, this.crc);
        }

        public void run(BufferedInputStream in, JarOutputStream out) throws IOException {
            if (this.verbose > 0) {
                UnpackerImpl.this.props.list(System.out);
            }
            int seg = 1;
            while (true) {
                this.unpackSegment(in, out);
                if (!Utils.isPackMagic(Utils.readMagic(in))) break;
                if (this.verbose > 0) {
                    Utils.log.info("Finished segment #" + seg);
                }
                ++seg;
            }
        }

        private void unpackSegment(InputStream in, JarOutputStream out) throws IOException {
            UnpackerImpl.this.props.setProperty("unpack.progress", "0");
            new PackageReader(this.pkg, in).read();
            if (UnpackerImpl.this.props.getBoolean("unpack.strip.debug")) {
                this.pkg.stripAttributeKind("Debug");
            }
            if (UnpackerImpl.this.props.getBoolean("unpack.strip.compile")) {
                this.pkg.stripAttributeKind("Compile");
            }
            UnpackerImpl.this.props.setProperty("unpack.progress", "50");
            this.pkg.ensureAllClassFiles();
            HashSet<Package.Class> classesToWrite = new HashSet<Package.Class>(this.pkg.getClasses());
            for (Package.File file : this.pkg.getFiles()) {
                boolean needCRC;
                String name = file.nameString;
                JarEntry je = new JarEntry(Utils.getJarEntryName(name));
                boolean deflate = this.keepDeflateHint ? (file.options & 1) != 0 || (this.pkg.default_options & 0x20) != 0 : this.deflateHint;
                boolean bl = needCRC = !deflate;
                if (needCRC) {
                    this.crc.reset();
                }
                this.bufOut.reset();
                if (file.isClassStub()) {
                    Package.Class cls = file.getStubClass();
                    assert (cls != null);
                    new ClassWriter(cls, needCRC ? this.crcOut : this.bufOut).write();
                    classesToWrite.remove(cls);
                } else {
                    file.writeTo(needCRC ? this.crcOut : this.bufOut);
                }
                je.setMethod(deflate ? 8 : 0);
                if (needCRC) {
                    if (this.verbose > 0) {
                        Utils.log.info("stored size=" + this.bufOut.size() + " and crc=" + this.crc.getValue());
                    }
                    je.setMethod(0);
                    je.setSize(this.bufOut.size());
                    je.setCrc(this.crc.getValue());
                }
                if (this.keepModtime) {
                    je.setTime(file.modtime);
                    je.setTime((long)file.modtime * 1000L);
                } else {
                    je.setTime((long)this.modtime * 1000L);
                }
                out.putNextEntry(je);
                this.bufOut.writeTo(out);
                out.closeEntry();
                if (this.verbose <= 0) continue;
                Utils.log.info("Writing " + Utils.zeString(je));
            }
            assert (classesToWrite.isEmpty());
            UnpackerImpl.this.props.setProperty("unpack.progress", "100");
            this.pkg.reset();
        }
    }
}

