/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.ac.impl;

import eu.emi.security.authn.x509.ValidationError;
import eu.emi.security.authn.x509.ValidationResult;
import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import eu.emi.security.authn.x509.impl.X500NameUtils;
import eu.emi.security.authn.x509.proxy.ProxyUtils;
import java.net.UnknownHostException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.ac.VOMSACValidationStrategy;
import org.italiangrid.voms.ac.VOMSValidationResult;
import org.italiangrid.voms.ac.impl.DefaultLocalHostnameResolver;
import org.italiangrid.voms.ac.impl.LocalHostnameResolver;
import org.italiangrid.voms.asn1.VOMSConstants;
import org.italiangrid.voms.error.VOMSValidationErrorCode;
import org.italiangrid.voms.error.VOMSValidationErrorMessage;
import org.italiangrid.voms.store.LSCInfo;
import org.italiangrid.voms.store.VOMSTrustStore;

public class DefaultVOMSValidationStrategy
implements VOMSACValidationStrategy {
    private final VOMSTrustStore store;
    private final X509CertChainValidatorExt certChainValidator;
    private final LocalHostnameResolver hostnameResolver;

    public DefaultVOMSValidationStrategy(VOMSTrustStore store, X509CertChainValidatorExt validator, LocalHostnameResolver resolver) {
        this.store = store;
        this.certChainValidator = validator;
        this.hostnameResolver = resolver;
    }

    public DefaultVOMSValidationStrategy(VOMSTrustStore store, X509CertChainValidatorExt validator) {
        this(store, validator, new DefaultLocalHostnameResolver());
    }

    private boolean checkACHolder(VOMSAttribute attributes, X509Certificate[] chain, List<VOMSValidationErrorMessage> validationErrors) {
        X500Principal chainHolder = ProxyUtils.getOriginalUserDN((X509Certificate[])chain);
        boolean holderDoesMatch = chainHolder.equals(attributes.getHolder());
        if (!holderDoesMatch) {
            String acHolderSubject = X500NameUtils.getReadableForm((X500Principal)attributes.getHolder());
            String certChainSubject = X500NameUtils.getReadableForm((X500Principal)chainHolder);
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.acHolderDoesntMatchCertChain, acHolderSubject, certChainSubject));
        }
        return holderDoesMatch;
    }

    private boolean checkACValidity(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        Date now = new Date();
        boolean valid = attributes.validAt(now);
        if (!valid) {
            VOMSValidationErrorMessage m = VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.acNotValidAtCurrentTime, attributes.getNotBefore(), attributes.getNotAfter(), now);
            validationErrors.add(m);
        }
        return valid;
    }

    private boolean checkLocalAACertSignature(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        X509Certificate localAACert = this.store.getAACertificateBySubject(attributes.getIssuer());
        if (localAACert == null) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.aaCertNotFound));
            return false;
        }
        if (!this.validateCertificate(localAACert, validationErrors)) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.invalidAaCert));
            return false;
        }
        boolean signatureValid = this.verifyACSignature(attributes, localAACert);
        if (!signatureValid) {
            String readableSubject = X500NameUtils.getReadableForm((X500Principal)localAACert.getSubjectX500Principal());
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.aaCertFailsSignatureVerification, readableSubject));
        }
        return signatureValid;
    }

    private boolean checkLSCSignature(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        LSCInfo lsc = this.store.getLSC(attributes.getVO(), attributes.getHost());
        X509Certificate[] aaCerts = attributes.getAACertificates();
        if (lsc == null) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.lscFileNotFound));
            return false;
        }
        if (aaCerts == null || aaCerts.length == 0) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.emptyAcCertsExtension));
            return false;
        }
        if (!lsc.matches(aaCerts)) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.lscDescriptionDoesntMatchAcCert));
            return false;
        }
        if (!this.validateCertificateChain(aaCerts, validationErrors)) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.invalidAcCert));
            return false;
        }
        boolean signatureValid = this.verifyACSignature(attributes, aaCerts[0]);
        if (!signatureValid) {
            String readableSubject = X500NameUtils.getReadableForm((X500Principal)aaCerts[0].getSubjectX500Principal());
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.acCertFailsSignatureVerification, readableSubject));
        }
        return signatureValid;
    }

    private boolean checkSignature(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        boolean valid = this.checkLSCSignature(attributes, validationErrors);
        if (!valid) {
            valid = this.checkLocalAACertSignature(attributes, validationErrors);
        }
        return valid;
    }

    private boolean checkTargets(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        String localhostName;
        if (attributes.getTargets() == null || attributes.getTargets().size() == 0) {
            return true;
        }
        try {
            localhostName = this.hostnameResolver.resolveLocalHostname();
        }
        catch (UnknownHostException e) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.other, "Error resolving localhost name: " + e.getMessage()));
            return false;
        }
        if (!attributes.getTargets().contains(localhostName)) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.localhostDoesntMatchAcTarget, localhostName, attributes.getTargets().toString()));
            return false;
        }
        return true;
    }

    private boolean checkNoRevAvailExtension(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        Extension noRevAvail = attributes.getVOMSAC().getExtension(Extension.noRevAvail);
        if (noRevAvail != null && noRevAvail.isCritical()) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.other, "NoRevAvail AC extension cannot be critical!"));
            return false;
        }
        return true;
    }

    private boolean checkAuthorityKeyIdentifierExtension(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        Extension authKeyId = attributes.getVOMSAC().getExtension(Extension.authorityKeyIdentifier);
        if (authKeyId != null && authKeyId.isCritical()) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.other, "AuthorityKeyIdentifier AC extension cannot be critical!"));
            return false;
        }
        return true;
    }

    private boolean checkUnhandledCriticalExtensions(VOMSAttribute attributes, List<VOMSValidationErrorMessage> validationErrors) {
        List acExtensions = attributes.getVOMSAC().getExtensionOIDs();
        for (ASN1ObjectIdentifier extId : acExtensions) {
            if (VOMSConstants.VOMS_HANDLED_EXTENSIONS.contains(extId) || !attributes.getVOMSAC().getExtension(extId).isCritical()) continue;
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.other, "unknown critical extension found in VOMS AC: " + extId.getId()));
            return false;
        }
        return true;
    }

    @Override
    public VOMSValidationResult validateAC(VOMSAttribute attributes) {
        boolean valid = true;
        ArrayList<VOMSValidationErrorMessage> validationErrors = new ArrayList<VOMSValidationErrorMessage>();
        valid = this.checkACValidity(attributes, validationErrors);
        if (valid) {
            valid = this.checkSignature(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkTargets(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkAuthorityKeyIdentifierExtension(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkNoRevAvailExtension(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkUnhandledCriticalExtensions(attributes, validationErrors);
        }
        return new VOMSValidationResult(attributes, valid, validationErrors);
    }

    @Override
    public synchronized VOMSValidationResult validateAC(VOMSAttribute attributes, X509Certificate[] chain) {
        boolean valid = true;
        ArrayList<VOMSValidationErrorMessage> validationErrors = new ArrayList<VOMSValidationErrorMessage>();
        valid = this.checkACValidity(attributes, validationErrors);
        if (valid) {
            valid = this.checkSignature(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkACHolder(attributes, chain, validationErrors);
        }
        if (valid) {
            valid = this.checkTargets(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkAuthorityKeyIdentifierExtension(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkNoRevAvailExtension(attributes, validationErrors);
        }
        if (valid) {
            valid = this.checkUnhandledCriticalExtensions(attributes, validationErrors);
        }
        return new VOMSValidationResult(attributes, valid, validationErrors);
    }

    private boolean validateCertificate(X509Certificate c, List<VOMSValidationErrorMessage> validationErrors) {
        return this.validateCertificateChain(new X509Certificate[]{c}, validationErrors);
    }

    private boolean validateCertificateChain(X509Certificate[] chain, List<VOMSValidationErrorMessage> validationErrors) {
        ValidationResult result = this.certChainValidator.validate(chain);
        for (ValidationError e : result.getErrors()) {
            validationErrors.add(VOMSValidationErrorMessage.newErrorMessage(VOMSValidationErrorCode.canlError, e.getMessage()));
        }
        return result.isValid();
    }

    private boolean verifyACSignature(VOMSAttribute attributes, X509Certificate cert) {
        try {
            JcaX509CertificateHolder certHolder = new JcaX509CertificateHolder(cert);
            ContentVerifierProvider cvp = new BcRSAContentVerifierProviderBuilder((DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder()).build((X509CertificateHolder)certHolder);
            return attributes.getVOMSAC().isSignatureValid(cvp);
        }
        catch (Exception e) {
            throw new VOMSError("Error verifying AC signature: " + e.getMessage(), e);
        }
    }
}

