/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.request.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.italiangrid.voms.request.VOMSESLookupStrategy;

public class BaseVOMSESLookupStrategy
implements VOMSESLookupStrategy {
    private final List<String> checkedPaths;

    public BaseVOMSESLookupStrategy() {
        this.checkedPaths = new ArrayList<String>();
    }

    public BaseVOMSESLookupStrategy(List<String> checkedPaths) {
        if (checkedPaths == null) {
            throw new NullPointerException("Please provide a non-null list of paths.");
        }
        this.checkedPaths = checkedPaths;
    }

    @Override
    public List<File> lookupVomsesInfo() {
        ArrayList<File> vomsesPaths = new ArrayList<File>();
        for (String p : this.checkedPaths) {
            File f = new File(p);
            if (!f.exists()) continue;
            vomsesPaths.add(f);
        }
        return vomsesPaths;
    }

    @Override
    public List<String> searchedPaths() {
        return this.checkedPaths;
    }

    public void addPath(String vomsesPath) {
        this.checkedPaths.add(vomsesPath);
    }
}

