/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import sun.awt.shell.ShellFolderColumnInfo;
import sun.awt.shell.ShellFolderManager;

public abstract class ShellFolder
extends File {
    private static final String COLUMN_NAME = "FileChooser.fileNameHeaderText";
    private static final String COLUMN_SIZE = "FileChooser.fileSizeHeaderText";
    private static final String COLUMN_DATE = "FileChooser.fileDateHeaderText";
    protected ShellFolder parent;
    private static final ShellFolderManager shellFolderManager;
    private static final Invoker invoker;
    private static final Comparator DEFAULT_COMPARATOR;
    private static final Comparator<File> FILE_COMPARATOR;

    ShellFolder(ShellFolder parent, String pathname) {
        super(pathname != null ? pathname : "ShellFolder");
        this.parent = parent;
    }

    public boolean isFileSystem() {
        return !this.getPath().startsWith("ShellFolder");
    }

    protected abstract Object writeReplace() throws ObjectStreamException;

    @Override
    public String getParent() {
        if (this.parent == null && this.isFileSystem()) {
            return super.getParent();
        }
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    @Override
    public File getParentFile() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isFileSystem()) {
            return super.getParentFile();
        }
        return null;
    }

    @Override
    public File[] listFiles() {
        return this.listFiles(true);
    }

    public File[] listFiles(boolean includeHiddenFiles) {
        File[] files = super.listFiles();
        if (!includeHiddenFiles) {
            Vector<File> v = new Vector<File>();
            int nameCount = files == null ? 0 : files.length;
            for (int i = 0; i < nameCount; ++i) {
                if (files[i].isHidden()) continue;
                v.addElement(files[i]);
            }
            files = v.toArray(new File[v.size()]);
        }
        return files;
    }

    public abstract boolean isLink();

    public abstract ShellFolder getLinkLocation() throws FileNotFoundException;

    public abstract String getDisplayName();

    public abstract String getFolderType();

    public abstract String getExecutableType();

    @Override
    public int compareTo(File file2) {
        if (file2 == null || !(file2 instanceof ShellFolder) || file2 instanceof ShellFolder && ((ShellFolder)file2).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file2);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        return this.getName().compareTo(file2.getName());
    }

    public Image getIcon(boolean getLargeIcon) {
        return null;
    }

    public static ShellFolder getShellFolder(File file) throws FileNotFoundException {
        if (file instanceof ShellFolder) {
            return (ShellFolder)file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return shellFolderManager.createShellFolder(file);
    }

    public static Object get(String key) {
        return shellFolderManager.get(key);
    }

    public static boolean isComputerNode(File dir) {
        return shellFolderManager.isComputerNode(dir);
    }

    public static boolean isFileSystemRoot(File dir) {
        return shellFolderManager.isFileSystemRoot(dir);
    }

    public static File getNormalizedFile(File f) throws IOException {
        File canonical = f.getCanonicalFile();
        if (f.equals(canonical)) {
            return canonical;
        }
        return new File(f.toURI().normalize());
    }

    public static void sort(final List<? extends File> files) {
        if (files == null || files.size() <= 1) {
            return;
        }
        ShellFolder.invoke(new Callable<Void>(){

            @Override
            public Void call() {
                File commonParent = null;
                for (File file : files) {
                    File parent = file.getParentFile();
                    if (parent == null || !(file instanceof ShellFolder)) {
                        commonParent = null;
                        break;
                    }
                    if (commonParent == null) {
                        commonParent = parent;
                        continue;
                    }
                    if (commonParent == parent || commonParent.equals(parent)) continue;
                    commonParent = null;
                    break;
                }
                if (commonParent instanceof ShellFolder) {
                    ((ShellFolder)commonParent).sortChildren(files);
                } else {
                    Collections.sort(files, FILE_COMPARATOR);
                }
                return null;
            }
        });
    }

    public void sortChildren(final List<? extends File> files) {
        ShellFolder.invoke(new Callable<Void>(){

            @Override
            public Void call() {
                Collections.sort(files, FILE_COMPARATOR);
                return null;
            }
        });
    }

    @Override
    public boolean isAbsolute() {
        return !this.isFileSystem() || super.isAbsolute();
    }

    @Override
    public File getAbsoluteFile() {
        return this.isFileSystem() ? super.getAbsoluteFile() : this;
    }

    @Override
    public boolean canRead() {
        return this.isFileSystem() ? super.canRead() : true;
    }

    @Override
    public boolean canWrite() {
        return this.isFileSystem() ? super.canWrite() : false;
    }

    @Override
    public boolean exists() {
        return !this.isFileSystem() || ShellFolder.isFileSystemRoot(this) || super.exists();
    }

    @Override
    public boolean isDirectory() {
        return this.isFileSystem() ? super.isDirectory() : true;
    }

    @Override
    public boolean isFile() {
        return this.isFileSystem() ? super.isFile() : !this.isDirectory();
    }

    @Override
    public long lastModified() {
        return this.isFileSystem() ? super.lastModified() : 0L;
    }

    @Override
    public long length() {
        return this.isFileSystem() ? super.length() : 0L;
    }

    @Override
    public boolean createNewFile() throws IOException {
        return this.isFileSystem() ? super.createNewFile() : false;
    }

    @Override
    public boolean delete() {
        return this.isFileSystem() ? super.delete() : false;
    }

    @Override
    public void deleteOnExit() {
        if (this.isFileSystem()) {
            super.deleteOnExit();
        }
    }

    @Override
    public boolean mkdir() {
        return this.isFileSystem() ? super.mkdir() : false;
    }

    @Override
    public boolean mkdirs() {
        return this.isFileSystem() ? super.mkdirs() : false;
    }

    @Override
    public boolean renameTo(File dest) {
        return this.isFileSystem() ? super.renameTo(dest) : false;
    }

    @Override
    public boolean setLastModified(long time) {
        return this.isFileSystem() ? super.setLastModified(time) : false;
    }

    @Override
    public boolean setReadOnly() {
        return this.isFileSystem() ? super.setReadOnly() : false;
    }

    @Override
    public String toString() {
        return this.isFileSystem() ? super.toString() : this.getDisplayName();
    }

    public static ShellFolderColumnInfo[] getFolderColumns(File dir) {
        ShellFolderColumnInfo[] columns = null;
        if (dir instanceof ShellFolder) {
            columns = ((ShellFolder)dir).getFolderColumns();
        }
        if (columns == null) {
            columns = new ShellFolderColumnInfo[]{new ShellFolderColumnInfo(COLUMN_NAME, 150, 10, true, null, FILE_COMPARATOR), new ShellFolderColumnInfo(COLUMN_SIZE, 75, 4, true, null, DEFAULT_COMPARATOR, true), new ShellFolderColumnInfo(COLUMN_DATE, 130, 10, true, null, DEFAULT_COMPARATOR, true)};
        }
        return columns;
    }

    public ShellFolderColumnInfo[] getFolderColumns() {
        return null;
    }

    public static Object getFolderColumnValue(File file, int column) {
        Object value;
        if (file instanceof ShellFolder && (value = ((ShellFolder)file).getFolderColumnValue(column)) != null) {
            return value;
        }
        if (file == null || !file.exists()) {
            return null;
        }
        switch (column) {
            case 0: {
                return file;
            }
            case 1: {
                return file.isDirectory() ? null : Long.valueOf(file.length());
            }
            case 2: {
                if (ShellFolder.isFileSystemRoot(file)) {
                    return null;
                }
                long time = file.lastModified();
                return time == 0L ? null : new Date(time);
            }
        }
        return null;
    }

    public Object getFolderColumnValue(int column) {
        return null;
    }

    public static <T> T invoke(Callable<T> task) {
        try {
            return ShellFolder.invoke(task, RuntimeException.class);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static <T, E extends Throwable> T invoke(Callable<T> task, Class<E> exceptionClass) throws InterruptedException, E {
        try {
            return invoker.invoke(task);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof InterruptedException) {
                Thread.currentThread().interrupt();
                throw (InterruptedException)e;
            }
            if (exceptionClass.isInstance(e)) {
                throw (Throwable)exceptionClass.cast(e);
            }
            throw new RuntimeException("Unexpected error", e);
        }
    }

    static {
        String managerClassName = (String)Toolkit.getDefaultToolkit().getDesktopProperty("Shell.shellFolderManager");
        Class<Object> managerClass = null;
        try {
            managerClass = Class.forName(managerClassName, false, null);
            if (!ShellFolderManager.class.isAssignableFrom(managerClass)) {
                managerClass = null;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (managerClass == null) {
            managerClass = ShellFolderManager.class;
        }
        try {
            shellFolderManager = (ShellFolderManager)managerClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new Error("Could not instantiate Shell Folder Manager: " + managerClass.getName());
        }
        catch (IllegalAccessException e) {
            throw new Error("Could not access Shell Folder Manager: " + managerClass.getName());
        }
        invoker = shellFolderManager.createInvoker();
        DEFAULT_COMPARATOR = new Comparator(){

            public int compare(Object o1, Object o2) {
                int gt = o1 == null && o2 == null ? 0 : (o1 != null && o2 == null ? 1 : (o1 == null && o2 != null ? -1 : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : 0)));
                return gt;
            }
        };
        FILE_COMPARATOR = new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                String name2;
                ShellFolder sf1 = null;
                ShellFolder sf2 = null;
                if (f1 instanceof ShellFolder && (sf1 = (ShellFolder)f1).isFileSystem()) {
                    sf1 = null;
                }
                if (f2 instanceof ShellFolder && (sf2 = (ShellFolder)f2).isFileSystem()) {
                    sf2 = null;
                }
                if (sf1 != null && sf2 != null) {
                    return sf1.compareTo(sf2);
                }
                if (sf1 != null) {
                    return -1;
                }
                if (sf2 != null) {
                    return 1;
                }
                String name1 = f1.getName();
                int diff = name1.compareToIgnoreCase(name2 = f2.getName());
                if (diff != 0) {
                    return diff;
                }
                return name1.compareTo(name2);
            }
        };
    }

    public static interface Invoker {
        public <T> T invoke(Callable<T> var1) throws Exception;
    }
}

