/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch.sctp;

import com.sun.nio.sctp.AbstractNotificationHandler;
import com.sun.nio.sctp.Association;
import com.sun.nio.sctp.AssociationChangeNotification;
import com.sun.nio.sctp.HandlerResult;
import com.sun.nio.sctp.IllegalUnbindException;
import com.sun.nio.sctp.InvalidStreamException;
import com.sun.nio.sctp.MessageInfo;
import com.sun.nio.sctp.NotificationHandler;
import com.sun.nio.sctp.SctpChannel;
import com.sun.nio.sctp.SctpMultiChannel;
import com.sun.nio.sctp.SctpSocketOption;
import com.sun.nio.sctp.SctpStandardSocketOptions;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NotYetBoundException;
import java.nio.channels.spi.SelectorProvider;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import sun.nio.ch.DirectBuffer;
import sun.nio.ch.IOStatus;
import sun.nio.ch.IOUtil;
import sun.nio.ch.NativeThread;
import sun.nio.ch.Net;
import sun.nio.ch.SelChImpl;
import sun.nio.ch.SelectionKeyImpl;
import sun.nio.ch.Util;
import sun.nio.ch.sctp.AssociationChange;
import sun.nio.ch.sctp.AssociationImpl;
import sun.nio.ch.sctp.ResultContainer;
import sun.nio.ch.sctp.SctpChannelImpl;
import sun.nio.ch.sctp.SctpNet;
import sun.nio.ch.sctp.SctpNotification;

public class SctpMultiChannelImpl
extends SctpMultiChannel
implements SelChImpl {
    private final FileDescriptor fd;
    private final int fdVal;
    private volatile long receiverThread = 0L;
    private volatile long senderThread = 0L;
    private final Object receiveLock = new Object();
    private final Object sendLock = new Object();
    private final Object stateLock = new Object();
    private ChannelState state = ChannelState.UNINITIALIZED;
    int port = -1;
    private HashSet<InetSocketAddress> localAddresses = new HashSet();
    private boolean wildcard;
    private HashMap<SocketAddress, Association> addressMap = new HashMap();
    private HashMap<Association, Set<SocketAddress>> associationMap = new HashMap();
    private final ThreadLocal<Association> associationToRemove = new ThreadLocal<Association>(){

        @Override
        protected Association initialValue() {
            return null;
        }
    };
    private final ThreadLocal<Boolean> receiveInvoked = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return Boolean.FALSE;
        }
    };
    private InternalNotificationHandler internalNotificationHandler = new InternalNotificationHandler();

    public SctpMultiChannelImpl(SelectorProvider provider) throws IOException {
        super(provider);
        this.fd = SctpNet.socket(false);
        this.fdVal = IOUtil.fdVal(this.fd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpMultiChannel bind(SocketAddress local, int backlog) throws IOException {
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    this.ensureOpen();
                    if (this.isBound()) {
                        SctpNet.throwAlreadyBoundException();
                    }
                    InetSocketAddress isa = local == null ? new InetSocketAddress(0) : Net.checkAddress(local);
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkListen(isa.getPort());
                    }
                    Net.bind(this.fd, isa.getAddress(), isa.getPort());
                    InetSocketAddress boundIsa = Net.localAddress(this.fd);
                    this.port = boundIsa.getPort();
                    this.localAddresses.add(isa);
                    if (isa.getAddress().isAnyLocalAddress()) {
                        this.wildcard = true;
                    }
                    SctpNet.listen(this.fdVal, backlog < 1 ? 50 : backlog);
                }
            }
        }
        return this;
    }

    @Override
    public SctpMultiChannel bindAddress(InetAddress address) throws IOException {
        return this.bindUnbindAddress(address, true);
    }

    @Override
    public SctpMultiChannel unbindAddress(InetAddress address) throws IOException {
        return this.bindUnbindAddress(address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SctpMultiChannel bindUnbindAddress(InetAddress address, boolean add) throws IOException {
        if (address == null) {
            throw new IllegalArgumentException();
        }
        Object object = this.receiveLock;
        synchronized (object) {
            Object object2 = this.sendLock;
            synchronized (object2) {
                Object object3 = this.stateLock;
                synchronized (object3) {
                    if (!this.isOpen()) {
                        throw new ClosedChannelException();
                    }
                    if (!this.isBound()) {
                        throw new NotYetBoundException();
                    }
                    if (this.wildcard) {
                        throw new IllegalStateException("Cannot add or remove addresses from a channel that is bound to the wildcard address");
                    }
                    if (address.isAnyLocalAddress()) {
                        throw new IllegalArgumentException("Cannot add or remove the wildcard address");
                    }
                    if (add) {
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(address)) continue;
                            SctpNet.throwAlreadyBoundException();
                        }
                    } else {
                        if (this.localAddresses.size() <= 1) {
                            throw new IllegalUnbindException("Cannot remove address from a channel with only one address bound");
                        }
                        boolean foundAddress = false;
                        for (InetSocketAddress addr : this.localAddresses) {
                            if (!addr.getAddress().equals(address)) continue;
                            foundAddress = true;
                            break;
                        }
                        if (!foundAddress) {
                            throw new IllegalUnbindException("Cannot remove address from a channel that is not bound to that address");
                        }
                    }
                    SctpNet.bindx(this.fdVal, new InetAddress[]{address}, this.port, add);
                    if (add) {
                        this.localAddresses.add(new InetSocketAddress(address, this.port));
                    } else {
                        for (InetSocketAddress inetSocketAddress : this.localAddresses) {
                            if (!inetSocketAddress.getAddress().equals(address)) continue;
                            this.localAddresses.remove(inetSocketAddress);
                            break;
                        }
                    }
                }
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Association> associations() throws ClosedChannelException, NotYetBoundException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                throw new NotYetBoundException();
            }
            return Collections.unmodifiableSet(this.associationMap.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBound() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.port != -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiverCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.receiverThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void senderCleanup() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.senderThread = 0L;
            if (this.state == ChannelState.KILLPENDING) {
                this.kill();
            }
        }
    }

    @Override
    protected void implConfigureBlocking(boolean block) throws IOException {
        IOUtil.configureBlocking(this.fd, block);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void implCloseSelectableChannel() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            SctpNet.preClose(this.fdVal);
            if (this.receiverThread != 0L) {
                NativeThread.signal(this.receiverThread);
            }
            if (this.senderThread != 0L) {
                NativeThread.signal(this.senderThread);
            }
            if (!this.isRegistered()) {
                this.kill();
            }
        }
    }

    @Override
    public FileDescriptor getFD() {
        return this.fd;
    }

    @Override
    public int getFDVal() {
        return this.fdVal;
    }

    private boolean translateReadyOps(int ops, int initialOps, SelectionKeyImpl sk) {
        int intOps = sk.nioInterestOps();
        int oldOps = sk.nioReadyOps();
        int newOps = initialOps;
        if ((ops & Net.POLLNVAL) != 0) {
            return false;
        }
        if ((ops & (Net.POLLERR | Net.POLLHUP)) != 0) {
            newOps = intOps;
            sk.nioReadyOps(newOps);
            return (newOps & ~oldOps) != 0;
        }
        if ((ops & Net.POLLIN) != 0 && (intOps & 1) != 0) {
            newOps |= 1;
        }
        if ((ops & Net.POLLOUT) != 0 && (intOps & 4) != 0) {
            newOps |= 4;
        }
        sk.nioReadyOps(newOps);
        return (newOps & ~oldOps) != 0;
    }

    @Override
    public boolean translateAndUpdateReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, sk.nioReadyOps(), sk);
    }

    @Override
    public boolean translateAndSetReadyOps(int ops, SelectionKeyImpl sk) {
        return this.translateReadyOps(ops, 0, sk);
    }

    @Override
    public void translateAndSetInterestOps(int ops, SelectionKeyImpl sk) {
        int newOps = 0;
        if ((ops & 1) != 0) {
            newOps |= Net.POLLIN;
        }
        if ((ops & 4) != 0) {
            newOps |= Net.POLLOUT;
        }
        sk.selector.putEventOps(sk, newOps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void kill() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == ChannelState.KILLED) {
                return;
            }
            if (this.state == ChannelState.UNINITIALIZED) {
                this.state = ChannelState.KILLED;
                return;
            }
            assert (!this.isOpen() && !this.isRegistered());
            if (this.receiverThread == 0L && this.senderThread == 0L) {
                SctpNet.close(this.fdVal);
                this.state = ChannelState.KILLED;
            } else {
                this.state = ChannelState.KILLPENDING;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> SctpMultiChannel setOption(SctpSocketOption<T> name, T value, Association association) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (association != null && (name.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR) || name.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR))) {
                this.checkAssociation(association);
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int assocId = association == null ? 0 : association.associationID();
            SctpNet.setSocketOption(this.fdVal, name, value, assocId);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T getOption(SctpSocketOption<T> name, Association association) throws IOException {
        if (name == null) {
            throw new NullPointerException();
        }
        if (!this.supportedOptions().contains(name)) {
            throw new UnsupportedOperationException("'" + name + "' not supported");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (association != null && (name.equals(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR) || name.equals(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR))) {
                this.checkAssociation(association);
            }
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            int assocId = association == null ? 0 : association.associationID();
            return (T)SctpNet.getSocketOption(this.fdVal, name, assocId);
        }
    }

    @Override
    public final Set<SctpSocketOption<?>> supportedOptions() {
        return DefaultOptionsHolder.defaultOptions;
    }

    /*
     * Exception decompiling
     */
    @Override
    public <T> MessageInfo receive(ByteBuffer buffer, T attachment, NotificationHandler<T> handler) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int receive(int fd, ByteBuffer dst, ResultContainer resultContainer) throws IOException {
        int rem;
        int pos = dst.position();
        int lim = dst.limit();
        assert (pos <= lim);
        int n = rem = pos <= lim ? lim - pos : 0;
        if (dst instanceof DirectBuffer && rem > 0) {
            return this.receiveIntoNativeBuffer(fd, resultContainer, dst, rem, pos);
        }
        int newSize = Math.max(rem, 1);
        ByteBuffer bb = Util.getTemporaryDirectBuffer(newSize);
        try {
            int n2 = this.receiveIntoNativeBuffer(fd, resultContainer, bb, newSize, 0);
            bb.flip();
            if (n2 > 0 && rem > 0) {
                dst.put(bb);
            }
            int n3 = n2;
            return n3;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int receiveIntoNativeBuffer(int fd, ResultContainer resultContainer, ByteBuffer bb, int rem, int pos) throws IOException {
        int n = SctpMultiChannelImpl.receive0(fd, resultContainer, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem);
        if (n > 0) {
            bb.position(pos + n);
        }
        return n;
    }

    private void handleNotificationInternal(ResultContainer resultContainer) {
        this.invokeNotificationHandler(resultContainer, this.internalNotificationHandler, null);
    }

    private <T> HandlerResult invokeNotificationHandler(ResultContainer resultContainer, NotificationHandler<T> handler, T attachment) {
        Association assoc;
        HandlerResult result;
        SctpNotification notification = resultContainer.notification();
        notification.setAssociation(this.lookupAssociation(notification.assocId()));
        if (!(handler instanceof AbstractNotificationHandler)) {
            result = handler.handleNotification(notification, attachment);
        } else {
            AbstractNotificationHandler absHandler = (AbstractNotificationHandler)handler;
            switch (resultContainer.type()) {
                case 3: {
                    result = absHandler.handleNotification(resultContainer.getAssociationChanged(), attachment);
                    break;
                }
                case 4: {
                    result = absHandler.handleNotification(resultContainer.getPeerAddressChanged(), attachment);
                    break;
                }
                case 2: {
                    result = absHandler.handleNotification(resultContainer.getSendFailed(), attachment);
                    break;
                }
                case 5: {
                    result = absHandler.handleNotification(resultContainer.getShutdown(), attachment);
                    break;
                }
                default: {
                    result = absHandler.handleNotification(resultContainer.notification(), attachment);
                }
            }
        }
        if (!(handler instanceof InternalNotificationHandler) && (assoc = this.associationToRemove.get()) != null) {
            this.removeAssociation(assoc);
            this.associationToRemove.set(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Association lookupAssociation(int assocId) {
        Object object = this.stateLock;
        synchronized (object) {
            Set<Association> assocs = this.associationMap.keySet();
            for (Association a : assocs) {
                if (a.associationID() != assocId) continue;
                return a;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAssociation(Association association) {
        Object object = this.stateLock;
        synchronized (object) {
            int assocId = association.associationID();
            Set<SocketAddress> addresses = null;
            try {
                addresses = SctpNet.getRemoteAddresses(this.fdVal, assocId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.associationMap.put(association, addresses);
            if (addresses != null) {
                for (SocketAddress addr : addresses) {
                    this.addressMap.put(addr, association);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAssociation(Association association) {
        Object object = this.stateLock;
        synchronized (object) {
            int assocId = association.associationID();
            Set<SocketAddress> addresses = null;
            try {
                addresses = SctpNet.getRemoteAddresses(this.fdVal, assocId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Set<Association> assocs = this.associationMap.keySet();
            for (Association a : assocs) {
                if (a.associationID() != assocId) continue;
                this.associationMap.remove(a);
                break;
            }
            if (addresses != null) {
                for (SocketAddress addr : addresses) {
                    this.addressMap.remove(addr);
                }
            } else {
                Set<Map.Entry<SocketAddress, Association>> addrAssocs = this.addressMap.entrySet();
                Iterator<Map.Entry<SocketAddress, Association>> iterator = addrAssocs.iterator();
                while (iterator.hasNext()) {
                    Map.Entry<SocketAddress, Association> entry = iterator.next();
                    if (!entry.getValue().equals(association)) continue;
                    iterator.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAssociation(Association messageAssoc) {
        Object object = this.stateLock;
        synchronized (object) {
            for (Association association : this.associationMap.keySet()) {
                if (!messageAssoc.equals(association)) continue;
                return true;
            }
        }
        throw new IllegalArgumentException("Given Association is not controlled by this channel");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkStreamNumber(Association assoc, int streamNumber) {
        Object object = this.stateLock;
        synchronized (object) {
            if (streamNumber < 0 || streamNumber >= assoc.maxOutboundStreams()) {
                throw new InvalidStreamException();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int send(ByteBuffer buffer, MessageInfo messageInfo) throws IOException {
        int n;
        InetSocketAddress address;
        int assocId;
        int n2;
        block21: {
            if (buffer == null) {
                throw new IllegalArgumentException("buffer cannot be null");
            }
            if (messageInfo == null) {
                throw new IllegalArgumentException("messageInfo cannot be null");
            }
            Object object = this.sendLock;
            // MONITORENTER : object
            this.ensureOpen();
            if (!this.isBound()) {
                this.bind(null, 0);
            }
            n2 = 0;
            assocId = -1;
            address = null;
            this.begin();
            Object object2 = this.stateLock;
            // MONITORENTER : object2
            if (this.isOpen()) break block21;
            int n3 = 0;
            // MONITOREXIT : object2
            this.senderCleanup();
            this.end(n2 > 0 || n2 == -2);
            assert (IOStatus.check(n2));
            // MONITOREXIT : object
            return n3;
        }
        try {
            this.senderThread = NativeThread.current();
            Association assoc = messageInfo.association();
            InetSocketAddress addr = (InetSocketAddress)messageInfo.address();
            if (assoc != null) {
                this.checkAssociation(assoc);
                this.checkStreamNumber(assoc, messageInfo.streamNumber());
                assocId = assoc.associationID();
                if (addr != null) {
                    if (!assoc.equals(this.addressMap.get(addr))) {
                        throw new IllegalArgumentException("given preferred address is not part of this association");
                    }
                    address = addr;
                }
            } else {
                if (addr == null) throw new AssertionError((Object)"Both association and address cannot be null");
                address = addr;
                Association association = this.addressMap.get(addr);
                if (association != null) {
                    this.checkStreamNumber(association, messageInfo.streamNumber());
                    assocId = association.associationID();
                } else {
                    SecurityManager sm = System.getSecurityManager();
                    if (sm != null) {
                        sm.checkConnect(addr.getAddress().getHostAddress(), addr.getPort());
                    }
                }
            }
            // MONITOREXIT : object2
            while ((n2 = this.send(this.fdVal, buffer, assocId, address, messageInfo)) == -3 && this.isOpen()) {
            }
            n = IOStatus.normalize(n2);
        }
        catch (Throwable throwable) {
            this.senderCleanup();
            this.end(n2 > 0 || n2 == -2);
            if ($assertionsDisabled) throw throwable;
            if (IOStatus.check(n2)) throw throwable;
            throw new AssertionError();
        }
        this.senderCleanup();
        this.end(n2 > 0 || n2 == -2);
        assert (IOStatus.check(n2));
        // MONITOREXIT : object
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int send(int fd, ByteBuffer src, int assocId, SocketAddress target, MessageInfo messageInfo) throws IOException {
        int streamNumber = messageInfo.streamNumber();
        boolean unordered = messageInfo.isUnordered();
        int ppid = messageInfo.payloadProtocolID();
        if (src instanceof DirectBuffer) {
            return this.sendFromNativeBuffer(fd, src, target, assocId, streamNumber, unordered, ppid);
        }
        int pos = src.position();
        int lim = src.limit();
        assert (pos <= lim && streamNumber >= 0);
        int rem = pos <= lim ? lim - pos : 0;
        ByteBuffer bb = Util.getTemporaryDirectBuffer(rem);
        try {
            bb.put(src);
            bb.flip();
            src.position(pos);
            int n = this.sendFromNativeBuffer(fd, bb, target, assocId, streamNumber, unordered, ppid);
            if (n > 0) {
                src.position(pos + n);
            }
            int n2 = n;
            return n2;
        }
        finally {
            Util.releaseTemporaryDirectBuffer(bb);
        }
    }

    private int sendFromNativeBuffer(int fd, ByteBuffer bb, SocketAddress target, int assocId, int streamNumber, boolean unordered, int ppid) throws IOException {
        InetAddress addr = null;
        int port = 0;
        if (target != null) {
            InetSocketAddress isa = Net.checkAddress(target);
            addr = isa.getAddress();
            port = isa.getPort();
        }
        int pos = bb.position();
        int lim = bb.limit();
        assert (pos <= lim);
        int rem = pos <= lim ? lim - pos : 0;
        int written = SctpMultiChannelImpl.send0(fd, ((DirectBuffer)((Object)bb)).address() + (long)pos, rem, addr, port, assocId, streamNumber, unordered, ppid);
        if (written > 0) {
            bb.position(pos + written);
        }
        return written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpMultiChannel shutdown(Association association) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkAssociation(association);
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            SctpNet.shutdown(this.fdVal, association.associationID());
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getAllLocalAddresses() throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            if (!this.isBound()) {
                return Collections.emptySet();
            }
            return SctpNet.getLocalAddresses(this.fdVal);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SocketAddress> getRemoteAddresses(Association association) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkAssociation(association);
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            try {
                return SctpNet.getRemoteAddresses(this.fdVal, association.associationID());
            }
            catch (SocketException se) {
                Set<SocketAddress> addrs = this.associationMap.get(association);
                return addrs != null ? addrs : Collections.emptySet();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SctpChannel branch(Association association) throws IOException {
        Object object = this.stateLock;
        synchronized (object) {
            this.checkAssociation(association);
            if (!this.isOpen()) {
                throw new ClosedChannelException();
            }
            FileDescriptor bFd = SctpNet.branch(this.fdVal, association.associationID());
            this.removeAssociation(association);
            return new SctpChannelImpl(this.provider(), bFd, association);
        }
    }

    private static int receive0(int fd, ResultContainer resultContainer, long address, int length) throws IOException {
        return SctpChannelImpl.receive0(fd, resultContainer, address, length, false);
    }

    private static int send0(int fd, long address, int length, InetAddress addr, int port, int assocId, int streamNumber, boolean unordered, int ppid) throws IOException {
        return SctpChannelImpl.send0(fd, address, length, addr, port, assocId, streamNumber, unordered, ppid);
    }

    static {
        IOUtil.load();
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                System.loadLibrary("sctp");
                return null;
            }
        });
    }

    private class InternalNotificationHandler
    extends AbstractNotificationHandler<Object> {
        private InternalNotificationHandler() {
        }

        @Override
        public HandlerResult handleNotification(AssociationChangeNotification not, Object unused) {
            AssociationChange sac = (AssociationChange)not;
            switch (not.event()) {
                case COMM_UP: {
                    AssociationImpl newAssociation = new AssociationImpl(sac.assocId(), sac.maxInStreams(), sac.maxOutStreams());
                    SctpMultiChannelImpl.this.addAssociation(newAssociation);
                    break;
                }
                case SHUTDOWN: 
                case COMM_LOST: {
                    SctpMultiChannelImpl.this.associationToRemove.set(SctpMultiChannelImpl.this.lookupAssociation(sac.assocId()));
                }
            }
            return HandlerResult.CONTINUE;
        }
    }

    private static class DefaultOptionsHolder {
        static final Set<SctpSocketOption<?>> defaultOptions = DefaultOptionsHolder.defaultOptions();

        private DefaultOptionsHolder() {
        }

        private static Set<SctpSocketOption<?>> defaultOptions() {
            HashSet<SctpSocketOption<Object>> set = new HashSet<SctpSocketOption<Object>>(10);
            set.add(SctpStandardSocketOptions.SCTP_DISABLE_FRAGMENTS);
            set.add(SctpStandardSocketOptions.SCTP_EXPLICIT_COMPLETE);
            set.add(SctpStandardSocketOptions.SCTP_FRAGMENT_INTERLEAVE);
            set.add(SctpStandardSocketOptions.SCTP_INIT_MAXSTREAMS);
            set.add(SctpStandardSocketOptions.SCTP_NODELAY);
            set.add(SctpStandardSocketOptions.SCTP_PRIMARY_ADDR);
            set.add(SctpStandardSocketOptions.SCTP_SET_PEER_PRIMARY_ADDR);
            set.add(SctpStandardSocketOptions.SO_SNDBUF);
            set.add(SctpStandardSocketOptions.SO_RCVBUF);
            set.add(SctpStandardSocketOptions.SO_LINGER);
            return Collections.unmodifiableSet(set);
        }
    }

    private static enum ChannelState {
        UNINITIALIZED,
        KILLPENDING,
        KILLED;

    }
}

