/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients;

import eu.emi.security.authn.x509.proxy.ProxyType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.italiangrid.voms.VOMSError;
import org.italiangrid.voms.clients.AbstractCLI;
import org.italiangrid.voms.clients.ProxyInitParams;
import org.italiangrid.voms.clients.impl.DefaultVOMSCommandsParser;
import org.italiangrid.voms.clients.impl.DefaultVOMSProxyInitBehaviour;
import org.italiangrid.voms.clients.impl.ProxyInitListenerHelper;
import org.italiangrid.voms.clients.options.CLIOption;
import org.italiangrid.voms.clients.options.CommonOptions;
import org.italiangrid.voms.clients.options.ProxyInitOptions;
import org.italiangrid.voms.clients.strategies.ProxyInitStrategy;
import org.italiangrid.voms.clients.util.TimeUtils;
import org.italiangrid.voms.util.VOMSFQANNamingScheme;

public class VomsProxyInit
extends AbstractCLI {
    private static final String COMMAND_NAME = "voms-proxy-init";
    private static final int[] SUPPORTED_KEY_SIZES = new int[]{512, 1024, 2048, 4096};
    private static final int EXIT_ERROR_CODE = 1;
    private ProxyInitStrategy proxyInitBehaviour;
    private ProxyInitListenerHelper listenerHelper;

    public static void main(String[] args) {
        new VomsProxyInit(args);
    }

    public VomsProxyInit(String[] args) {
        super(COMMAND_NAME);
        try {
            this.initOptions();
            this.parseOptionsFromCommandLine(args);
            this.listenerHelper = new ProxyInitListenerHelper(this.logger);
            this.execute();
        }
        catch (Throwable t) {
            if (this.logger != null) {
                this.logger.error(t);
            } else {
                System.err.println(t.getMessage());
                t.printStackTrace(System.err);
            }
            System.exit(1);
        }
    }

    private ProxyInitStrategy getProxyInitBehaviour() {
        return new DefaultVOMSProxyInitBehaviour(new DefaultVOMSCommandsParser(), this.listenerHelper);
    }

    private int parseKeySize(String keySizeParam) {
        try {
            int keySize = Integer.parseInt(keySizeParam);
            if (Arrays.binarySearch(SUPPORTED_KEY_SIZES, keySize) < 0) {
                throw new VOMSError("Unsupported key size:" + keySize);
            }
            return keySize;
        }
        catch (NumberFormatException e) {
            throw new VOMSError("Invalid input for key size parameter. Please provide a valid key size value.", (Throwable)e);
        }
    }

    private ProxyInitParams getProxyInitParamsFromCommandLine(CommandLine line) {
        ProxyInitParams params = new ProxyInitParams();
        if (this.commandLineHasOption(ProxyInitOptions.KEY_SIZE)) {
            params.setKeySize(this.parseKeySize(this.getOptionValue(ProxyInitOptions.KEY_SIZE)));
        }
        if (this.commandLineHasOption(ProxyInitOptions.ENABLE_STDIN_PWD)) {
            params.setReadPasswordFromStdin(true);
        }
        if (this.commandLineHasOption(ProxyInitOptions.LIMITED_PROXY)) {
            params.setLimited(true);
        }
        if (this.commandLineHasOption(ProxyInitOptions.PATHLEN_CONSTRAINT)) {
            params.setPathLenConstraint(Integer.parseInt(this.getOptionValue(ProxyInitOptions.PATHLEN_CONSTRAINT)));
        }
        if (this.commandLineHasOption(ProxyInitOptions.CERT_LOCATION)) {
            params.setCertFile(this.getOptionValue(ProxyInitOptions.CERT_LOCATION));
        }
        if (this.commandLineHasOption(ProxyInitOptions.KEY_LOCATION)) {
            params.setKeyFile(this.getOptionValue(ProxyInitOptions.KEY_LOCATION));
        }
        if (this.commandLineHasOption(ProxyInitOptions.PROXY_LOCATION)) {
            params.setGeneratedProxyFile(this.getOptionValue(ProxyInitOptions.PROXY_LOCATION));
        }
        if (this.commandLineHasOption(ProxyInitOptions.VALIDITY)) {
            int lifetimeInSeconds = this.parseLifeTimeInHoursAndMinutesString(this.getOptionValue(ProxyInitOptions.VALIDITY), ProxyInitOptions.VALIDITY);
            params.setAcLifetimeInSeconds(lifetimeInSeconds);
            params.setProxyLifetimeInSeconds(lifetimeInSeconds);
        }
        if (this.commandLineHasOption(ProxyInitOptions.AC_LIFETIME)) {
            params.setAcLifetimeInSeconds(this.parseLifeTimeInHoursAndMinutesString(this.getOptionValue(ProxyInitOptions.AC_LIFETIME), ProxyInitOptions.AC_LIFETIME));
        }
        if (this.commandLineHasOption(ProxyInitOptions.PROXY_LIFETIME_IN_HOURS)) {
            params.setProxyLifetimeInSeconds(this.parseLifetimeInHoursString(this.getOptionValue(ProxyInitOptions.PROXY_LIFETIME_IN_HOURS), ProxyInitOptions.PROXY_LIFETIME_IN_HOURS));
        }
        if (this.commandLineHasOption(ProxyInitOptions.VOMS_COMMAND)) {
            params.setVomsCommands(this.getOptionValues(ProxyInitOptions.VOMS_COMMAND));
        }
        if (this.commandLineHasOption(ProxyInitOptions.VERIFY_CERT)) {
            params.setValidateUserCredential(true);
        }
        if (this.commandLineHasOption(ProxyInitOptions.PROXY_NOREGEN)) {
            params.setNoRegen(true);
        }
        if (this.commandLineHasOption(ProxyInitOptions.SKIP_AC_VERIFICATION)) {
            params.setVerifyAC(false);
        }
        if (this.commandLineHasOption(ProxyInitOptions.SKIP_INTEGRITY_CHECKS)) {
            params.setEnforcingChainIntegrity(false);
        }
        if (this.commandLineHasOption(ProxyInitOptions.FQANS_ORDERING)) {
            params.setFqanOrder(this.fqansSanityChecks(this.getOptionValues(ProxyInitOptions.FQANS_ORDERING)));
        }
        if (this.commandLineHasOption(ProxyInitOptions.LEGACY_PROXY)) {
            params.setProxyType(ProxyType.LEGACY);
        }
        if (this.commandLineHasOption(ProxyInitOptions.PROXY_VERSION)) {
            params.setProxyType(this.proxyTypeFromVersion(this.getOptionValue(ProxyInitOptions.PROXY_VERSION)));
        }
        if (this.commandLineHasOption(ProxyInitOptions.TARGET_HOSTNAME)) {
            params.setTargets(Arrays.asList(this.getOptionValue(ProxyInitOptions.TARGET_HOSTNAME)));
        }
        if (this.commandLineHasOption(ProxyInitOptions.VOMSES_LOCATION)) {
            params.setVomsesLocations(this.getOptionValues(ProxyInitOptions.VOMSES_LOCATION));
        }
        if (this.commandLineHasOption(ProxyInitOptions.IGNORE_WARNINGS)) {
            this.listenerHelper = new ProxyInitListenerHelper(this.logger, ProxyInitListenerHelper.WARNING_POLICY.ignoreWarnings);
        }
        if (this.commandLineHasOption(ProxyInitOptions.FAIL_ON_WARN)) {
            this.listenerHelper = new ProxyInitListenerHelper(this.logger, ProxyInitListenerHelper.WARNING_POLICY.failOnWarnings);
        }
        if (this.commandLineHasOption(ProxyInitOptions.TIMEOUT)) {
            params.setTimeoutInSeconds(this.parseConnectionTimeout(this.getOptionValue(ProxyInitOptions.TIMEOUT)));
        }
        if (this.commandLineHasOption(ProxyInitOptions.TRUSTED_CERT_LOCATION)) {
            params.setTrustAnchorsDir(this.getOptionValue(ProxyInitOptions.TRUSTED_CERT_LOCATION));
        }
        if (this.commandLineHasOption(ProxyInitOptions.VOMSDIR)) {
            params.setVomsdir(this.getOptionValue(ProxyInitOptions.VOMSDIR));
        }
        if (this.commandLineHasOption(ProxyInitOptions.SKIP_HOSTNAME_CHECKS)) {
            params.setSkipHostnameChecks(true);
        }
        return params;
    }

    private ProxyType proxyTypeFromVersion(String version) {
        try {
            int versionNumber = Integer.parseInt(version);
            if (versionNumber == 2) {
                return ProxyType.LEGACY;
            }
            if (versionNumber == 3) {
                return ProxyType.DRAFT_RFC;
            }
            if (versionNumber == 4) {
                return ProxyType.RFC3820;
            }
            throw new VOMSError("Please specify a valid value for proxyversion: (2-> legacy, 3-> draft rfc, 4-> rfc).");
        }
        catch (NumberFormatException e) {
            throw new VOMSError("Please specify a valid value for proxyversion.");
        }
    }

    private void initOptions() {
        ArrayList<CLIOption> options = new ArrayList<CLIOption>();
        options.addAll(Arrays.asList(CommonOptions.values()));
        options.addAll(Arrays.asList(ProxyInitOptions.values()));
        this.initOptions(options);
    }

    private List<String> fqansSanityChecks(List<String> fqans) {
        for (String f : fqans) {
            VOMSFQANNamingScheme.checkSyntax((String)f);
        }
        return fqans;
    }

    private int parseLifetimeInHoursString(String proxyLifetimeProperty, CLIOption option) {
        try {
            return TimeUtils.parseLifetimeInHours(proxyLifetimeProperty);
        }
        catch (ParseException e) {
            throw new VOMSError("Invalid format for the time interval option '" + option.getLongOptionName() + "'. It should follow the hh pattern.", (Throwable)e);
        }
    }

    private int parseLifeTimeInHoursAndMinutesString(String acLifetimeProperty, CLIOption option) {
        try {
            return TimeUtils.parseLifetimeInHoursAndMinutes(acLifetimeProperty);
        }
        catch (ParseException e) {
            throw new VOMSError("Invalid format for the time interval option '" + option.getLongOptionName() + "'. It should follow the hh:mm pattern.", (Throwable)e);
        }
    }

    private int parseConnectionTimeout(String timeoutStringValue) {
        int timeoutInSeconds = 0;
        try {
            timeoutInSeconds = Integer.parseInt(timeoutStringValue);
            if (timeoutInSeconds < 0) {
                throw new VOMSError("Invalid value for the timeout option. It should be a positive integer.");
            }
        }
        catch (NumberFormatException e) {
            throw new VOMSError("Invalid value for the timeout option. It should be a positive integer.");
        }
        return timeoutInSeconds;
    }

    @Override
    protected void execute() {
        ProxyInitParams params = this.getProxyInitParamsFromCommandLine(this.commandLine);
        try {
            this.proxyInitBehaviour = this.getProxyInitBehaviour();
            this.proxyInitBehaviour.initProxy(params);
            if (this.listenerHelper.hadValidationErrors()) {
                System.exit(1);
            }
        }
        catch (Throwable t) {
            this.logger.error(t);
            System.exit(1);
        }
    }
}

