/*
 * Decompiled with CFR 0.152.
 */
package org.italiangrid.voms.clients.util;

import eu.emi.security.authn.x509.X509CertChainValidatorExt;
import org.bouncycastle.cert.AttributeCertificateHolder;
import org.bouncycastle.x509.X509CertificatePair;
import org.italiangrid.voms.VOMSAttribute;
import org.italiangrid.voms.clients.strategies.ProxyInitStrategy;

public class VersionProvider {
    public static void displayVersionInfo(String command) {
        String version = ProxyInitStrategy.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "N/A";
        }
        System.out.format("%s v. %s (%s)\n", command, version, VersionProvider.getAPIVersionString());
    }

    public static String getAPIVersionString() {
        StringBuilder version = new StringBuilder();
        String vomsAPIVersion = VOMSAttribute.class.getPackage().getImplementationVersion();
        String canlVersion = X509CertChainValidatorExt.class.getPackage().getImplementationVersion();
        String bcVersion = X509CertificatePair.class.getPackage().getImplementationVersion();
        String bcMailVersion = AttributeCertificateHolder.class.getPackage().getImplementationVersion();
        version.append(String.format("voms-api-java/%s canl/%s", vomsAPIVersion, canlVersion));
        if (bcVersion != null) {
            version.append(String.format(" bouncycastle/%s", bcVersion));
        }
        if (bcMailVersion != null) {
            version.append(String.format(" bcmail/%s", bcMailVersion));
        }
        return version.toString();
    }
}

