/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KeyTransRecipientId;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class RecipientInformationStore {
    private final List all;
    private final Map table = new HashMap();

    public RecipientInformationStore(Collection recipientInfos) {
        for (RecipientInformation recipientInformation : recipientInfos) {
            RecipientId rid = recipientInformation.getRID();
            ArrayList<RecipientInformation> list = (ArrayList<RecipientInformation>)this.table.get(rid);
            if (list == null) {
                list = new ArrayList<RecipientInformation>(1);
                this.table.put(rid, list);
            }
            list.add(recipientInformation);
        }
        this.all = new ArrayList(recipientInfos);
    }

    public RecipientInformation get(RecipientId selector) {
        Collection list = this.getRecipients(selector);
        return list.size() == 0 ? null : (RecipientInformation)list.iterator().next();
    }

    public int size() {
        return this.all.size();
    }

    public Collection getRecipients() {
        return new ArrayList(this.all);
    }

    public Collection getRecipients(RecipientId selector) {
        ArrayList list;
        if (selector instanceof KeyTransRecipientId) {
            KeyTransRecipientId keyTrans = (KeyTransRecipientId)selector;
            X500Name issuer = keyTrans.getIssuer();
            byte[] subjectKeyId = keyTrans.getSubjectKeyIdentifier();
            if (issuer != null && subjectKeyId != null) {
                Collection match2;
                ArrayList results = new ArrayList();
                Collection match1 = this.getRecipients(new KeyTransRecipientId(issuer, keyTrans.getSerialNumber()));
                if (match1 != null) {
                    results.addAll(match1);
                }
                if ((match2 = this.getRecipients(new KeyTransRecipientId(subjectKeyId))) != null) {
                    results.addAll(match2);
                }
                return results;
            }
        }
        return (list = (ArrayList)this.table.get(selector)) == null ? new ArrayList() : new ArrayList(list);
    }
}

