/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openssl.jcajce;

import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.crypto.PBEParametersGenerator;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.generators.PKCS5S2ParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.jcajce.JcaJceHelper;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.util.Integers;

class PEMUtilities {
    private static final Map KEYSIZES = new HashMap();
    private static final Set PKCS5_SCHEME_1 = new HashSet();
    private static final Set PKCS5_SCHEME_2 = new HashSet();

    PEMUtilities() {
    }

    static int getKeySize(String algorithm) {
        if (!KEYSIZES.containsKey(algorithm)) {
            throw new IllegalStateException("no key size for algorithm: " + algorithm);
        }
        return (Integer)KEYSIZES.get(algorithm);
    }

    static boolean isPKCS5Scheme1(DERObjectIdentifier algOid) {
        return PKCS5_SCHEME_1.contains(algOid);
    }

    static boolean isPKCS5Scheme2(ASN1ObjectIdentifier algOid) {
        return PKCS5_SCHEME_2.contains(algOid);
    }

    public static boolean isPKCS12(DERObjectIdentifier algOid) {
        return algOid.getId().startsWith(PKCSObjectIdentifiers.pkcs_12PbeIds.getId());
    }

    public static SecretKey generateSecretKeyForPKCS5Scheme2(String algorithm, char[] password, byte[] salt, int iterationCount) {
        PKCS5S2ParametersGenerator generator = new PKCS5S2ParametersGenerator();
        generator.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt, iterationCount);
        return new SecretKeySpec(((KeyParameter)generator.generateDerivedParameters(PEMUtilities.getKeySize(algorithm))).getKey(), algorithm);
    }

    static byte[] crypt(boolean encrypt, JcaJceHelper helper, byte[] bytes, char[] password, String dekAlgName, byte[] iv) throws PEMException {
        SecretKey sKey;
        String alg;
        AlgorithmParameterSpec paramSpec = new IvParameterSpec(iv);
        String blockMode = "CBC";
        String padding = "PKCS5Padding";
        if (dekAlgName.endsWith("-CFB")) {
            blockMode = "CFB";
            padding = "NoPadding";
        }
        if (dekAlgName.endsWith("-ECB") || "DES-EDE".equals(dekAlgName) || "DES-EDE3".equals(dekAlgName)) {
            blockMode = "ECB";
            paramSpec = null;
        }
        if (dekAlgName.endsWith("-OFB")) {
            blockMode = "OFB";
            padding = "NoPadding";
        }
        if (dekAlgName.startsWith("DES-EDE")) {
            alg = "DESede";
            boolean des2 = !dekAlgName.startsWith("DES-EDE3");
            sKey = PEMUtilities.getKey(password, alg, 24, iv, des2);
        } else if (dekAlgName.startsWith("DES-")) {
            alg = "DES";
            sKey = PEMUtilities.getKey(password, alg, 8, iv);
        } else if (dekAlgName.startsWith("BF-")) {
            alg = "Blowfish";
            sKey = PEMUtilities.getKey(password, alg, 16, iv);
        } else if (dekAlgName.startsWith("RC2-")) {
            alg = "RC2";
            int keyBits = 128;
            if (dekAlgName.startsWith("RC2-40-")) {
                keyBits = 40;
            } else if (dekAlgName.startsWith("RC2-64-")) {
                keyBits = 64;
            }
            sKey = PEMUtilities.getKey(password, alg, keyBits / 8, iv);
            paramSpec = paramSpec == null ? new RC2ParameterSpec(keyBits) : new RC2ParameterSpec(keyBits, iv);
        } else if (dekAlgName.startsWith("AES-")) {
            int keyBits;
            alg = "AES";
            byte[] salt = iv;
            if (salt.length > 8) {
                salt = new byte[8];
                System.arraycopy(iv, 0, salt, 0, 8);
            }
            if (dekAlgName.startsWith("AES-128-")) {
                keyBits = 128;
            } else if (dekAlgName.startsWith("AES-192-")) {
                keyBits = 192;
            } else if (dekAlgName.startsWith("AES-256-")) {
                keyBits = 256;
            } else {
                throw new EncryptionException("unknown AES encryption with private key");
            }
            sKey = PEMUtilities.getKey(password, "AES", keyBits / 8, salt);
        } else {
            throw new EncryptionException("unknown encryption with private key");
        }
        String transformation = alg + "/" + blockMode + "/" + padding;
        try {
            int mode;
            Cipher c = helper.createCipher(transformation);
            int n = mode = encrypt ? 1 : 2;
            if (paramSpec == null) {
                c.init(mode, sKey);
            } else {
                c.init(mode, (Key)sKey, paramSpec);
            }
            return c.doFinal(bytes);
        }
        catch (Exception e) {
            throw new EncryptionException("exception using cipher - please check password and data.", (Throwable)e);
        }
    }

    private static SecretKey getKey(char[] password, String algorithm, int keyLength, byte[] salt) {
        return PEMUtilities.getKey(password, algorithm, keyLength, salt, false);
    }

    private static SecretKey getKey(char[] password, String algorithm, int keyLength, byte[] salt, boolean des2) {
        OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
        pGen.init(PBEParametersGenerator.PKCS5PasswordToBytes((char[])password), salt);
        KeyParameter keyParam = (KeyParameter)pGen.generateDerivedParameters(keyLength * 8);
        byte[] key = keyParam.getKey();
        if (des2 && key.length >= 24) {
            System.arraycopy(key, 0, key, 16, 8);
        }
        return new SecretKeySpec(key, algorithm);
    }

    static {
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD2AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithMD5AndRC2_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndDES_CBC);
        PKCS5_SCHEME_1.add(PKCSObjectIdentifiers.pbeWithSHA1AndRC2_CBC);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.id_PBES2);
        PKCS5_SCHEME_2.add(PKCSObjectIdentifiers.des_EDE3_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes128_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes192_CBC);
        PKCS5_SCHEME_2.add(NISTObjectIdentifiers.id_aes256_CBC);
        KEYSIZES.put(PKCSObjectIdentifiers.des_EDE3_CBC.getId(), Integers.valueOf((int)192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes128_CBC.getId(), Integers.valueOf((int)128));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes192_CBC.getId(), Integers.valueOf((int)192));
        KEYSIZES.put(NISTObjectIdentifiers.id_aes256_CBC.getId(), Integers.valueOf((int)256));
    }
}

