use strict;
use warnings FATAL => 'all';

# Test case for PR 33791.

use Apache::Test;
use Apache::TestUtil;
use Apache::TestRequest;

BEGIN {
   # prevent TestRequest from croaking on an HTTP/0.9 response
   $ENV{APACHE_TEST_HTTP_09_OK} = 1;
}

my $vars = Apache::Test::vars();

plan tests => 3, need $vars->{ssl_module_name}, need_lwp,
    qw(LWP::Protocol::https);

Apache::TestRequest::user_agent_keepalive(0);

my $config = Apache::Test::config();

Apache::TestRequest::module("ssl_pr33791");

my $hostport = Apache::TestRequest::hostport();

my $rurl = "http://" . $hostport . "/";

t_debug("URL is $rurl");

my $r = GET($rurl);

my $proto = $r->protocol;

ok $proto;

if (!$proto) {
    skip "server gave no response";
} else {
    if ($proto eq "HTTP/0.9") {
        skip "server gave HTTP/0.9 response";
    } elsif ($proto) {    
        ok t_cmp($r->code,
                 400,
                 "Expected bad request from 'GET $rurl'"
                 );
    }
}

ok t_cmp($r->content, qr/welcome to localhost/, "errordoc content was served");
