/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.Dimension;
import java.awt.Graphics2D;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.ForeignObjectHandler;
import org.apache.batik.bridge.ForeignObjectHandlerFactory;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.dom.AbstractDocument;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.gvt.CompositeGraphicsNode;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.gvt.RootGraphicsNode;
import org.apache.batik.svggen.SVGGraphics2D;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xhtmlrenderer.extend.FontContext;
import org.xhtmlrenderer.extend.OutputDevice;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.render.Java2DTextRenderer;
import org.xhtmlrenderer.simple.Graphics2DRenderer;
import org.xhtmlrenderer.swing.Java2DOutputDevice;

public class XHTMLForeignObjectHandlerFactory
implements ForeignObjectHandlerFactory {
    public String getNamespaceURI() {
        return "http://www.w3.org/1999/xhtml";
    }

    public ForeignObjectHandler createHandler() {
        return new Handler();
    }

    protected static class TextRenderer
    extends Java2DTextRenderer {
        protected TextRenderer() {
        }

        public void drawString(OutputDevice outputDevice, String string, float f, float f2) {
            Graphics2D graphics2D = ((Java2DOutputDevice)outputDevice).getGraphics();
            graphics2D.drawString(string, f, f2);
        }

        public void setup(FontContext fontContext) {
        }
    }

    protected static class Handler
    implements ForeignObjectHandler {
        public Handler() {
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
        }

        public GraphicsNode createGraphicsNode(BridgeContext bridgeContext, Element element, float f, float f2) {
            if (!element.getLocalName().equals("html")) {
                return null;
            }
            DOMImplementation dOMImplementation = GenericDOMImplementation.getDOMImplementation();
            Document document = dOMImplementation.createDocument("http://www.w3.org/1999/xhtml", "html", null);
            document.replaceChild(document.importNode(element, true), document.getDocumentElement());
            dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            Document document2 = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
            SVGGraphics2D sVGGraphics2D = new SVGGraphics2D(document2);
            Graphics2DRenderer graphics2DRenderer = new Graphics2DRenderer();
            graphics2DRenderer.getPanel().setOpaque(false);
            SharedContext sharedContext = graphics2DRenderer.getSharedContext();
            sharedContext.setTextRenderer((org.xhtmlrenderer.extend.TextRenderer)new TextRenderer());
            graphics2DRenderer.setDocument(document, AbstractDocument.getBaseURI((Node)bridgeContext.getDocument()));
            graphics2DRenderer.layout((Graphics2D)sVGGraphics2D, new Dimension(Math.round(f), Math.round(f2)));
            graphics2DRenderer.render((Graphics2D)sVGGraphics2D);
            sVGGraphics2D.getRoot(document2.getDocumentElement());
            BridgeContext bridgeContext2 = new BridgeContext(bridgeContext.getUserAgent());
            GVTBuilder gVTBuilder = new GVTBuilder();
            RootGraphicsNode rootGraphicsNode = (RootGraphicsNode)gVTBuilder.build(bridgeContext2, document2);
            Object[] objectArray = rootGraphicsNode.toArray();
            CompositeGraphicsNode compositeGraphicsNode = new CompositeGraphicsNode();
            for (int i = 0; i < objectArray.length; ++i) {
                compositeGraphicsNode.add(objectArray[i]);
                ((GraphicsNode)objectArray[i]).setClip(null);
            }
            return compositeGraphicsNode;
        }
    }
}

