static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <stdlib.h>                                                           \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"/tmp/gegl-logo.svg\")                \n"
"    description (_(\"Path of file to load.\"))                                \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE magick-load.c                                        \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"static void                                                                   \n"
"load_cache (GeglProperties *op_magick_load)                                   \n"
"{                                                                             \n"
"  if (!op_magick_load->user_data)                                             \n"
"    {                                                                         \n"
"      gchar    *filename;                                                     \n"
"      gchar    *cmd;                                                          \n"
"      GeglNode *graph, *sink;                                                 \n"
"      GeglBuffer *newbuf = NULL;                                              \n"
"                                                                              \n"
"      /* ImageMagick backed fallback FIXME: make this robust.                 \n"
"       * maybe use pipes in a manner similar to the raw loader,               \n"
"       * or at least use a properly unique filename  */                       \n"
"                                                                              \n"
"      filename = g_build_filename (g_get_tmp_dir (), \"gegl-magick.png\", NULL);\n"
"      cmd = g_strdup_printf (\"convert \\\"%s\\\"'[0]' \\\"%s\\\"\",          \n"
"                             op_magick_load->path, filename);                 \n"
"      if (system (cmd) == -1)                                                 \n"
"        g_warning (\"Error executing ImageMagick convert program\");          \n"
"                                                                              \n"
"      graph = gegl_graph (sink=gegl_node (\"gegl:buffer-sink\", \"buffer\", &newbuf, NULL,\n"
"                                          gegl_node (\"gegl:png-load\", \"path\", filename, NULL)));\n"
"      gegl_node_process (sink);                                               \n"
"      op_magick_load->user_data = (gpointer) newbuf;                          \n"
"      g_object_unref (graph);                                                 \n"
"      g_free (cmd);                                                           \n"
"      g_free (filename);                                                      \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result = {0,0,0,0};                                           \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  gint width, height;                                                         \n"
"                                                                              \n"
"  load_cache (o);                                                             \n"
"                                                                              \n"
"  g_object_get (o->user_data, \"width\", &width,                              \n"
"                               \"height\", &height, NULL);                    \n"
"  result.width  = width;                                                      \n"
"  result.height = height;                                                     \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation *operation,                                  \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation         *operation,                                    \n"
"         GeglOperationContext  *context,                                      \n"
"         const gchar           *output_pad,                                   \n"
"         const GeglRectangle   *result,                                       \n"
"         gint                   level)                                        \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  if (!o->user_data)                                                          \n"
"    return FALSE;                                                             \n"
"  /* overriding the predefined behavior */                                    \n"
"  g_object_ref (o->user_data);                                                \n"
"  gegl_operation_context_take_object (context, \"output\", G_OBJECT (o->user_data));\n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void finalize (GObject *object)                                        \n"
"{                                                                             \n"
"  GeglOperation *op = (void*) object;                                         \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  if (o->user_data)                                                           \n"
"    g_object_unref (o->user_data);                                            \n"
"  o->user_data = NULL;                                                        \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GObjectClass             *object_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  object_class    = G_OBJECT_CLASS (klass);                                   \n"
"                                                                              \n"
"  object_class->finalize = finalize;                                          \n"
"                                                                              \n"
"  operation_class->process = process;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;;                    \n"
"  operation_class->no_cache = FALSE;                                          \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"        \"name\"       , \"gegl:magick-load\",                                \n"
"        \"categories\" , \"hidden\",                                          \n"
"        \"description\",                                                      \n"
"        _(\"Image Magick wrapper using the png op.\"),                        \n"
"        NULL);                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
