static const char* op_c_source =
"                                                                              \n"
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2010 Danny Robson <danny@blubinc.net>                            \n"
" */                                                                           \n"
"                                                                              \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"   description (_(\"Path of file to load.\"))                                 \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE rgbe-load.c                                          \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include \"rgbe/rgbe.h\"                                                      \n"
"                                                                              \n"
"#include <errno.h>                                                            \n"
"#include <stdio.h>                                                            \n"
"                                                                              \n"
"                                                                              \n"
"static const gchar* FORMAT = \"RGBA float\";                                  \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_rgbe_load_get_bounding_box (GeglOperation *operation)                    \n"
"{                                                                             \n"
"  GeglProperties       *o        = GEGL_PROPERTIES (operation);               \n"
"  GeglRectangle     result   = {0,0,0,0};                                     \n"
"  rgbe_file        *file;                                                     \n"
"  guint             width, height;                                            \n"
"                                                                              \n"
"  gegl_operation_set_format (operation,                                       \n"
"                             \"output\",                                      \n"
"                             babl_format (FORMAT));                           \n"
"                                                                              \n"
"  file = rgbe_load_path (o->path);                                            \n"
"  if (!file)                                                                  \n"
"      goto cleanup;                                                           \n"
"                                                                              \n"
"  if (!rgbe_get_size (file, &width, &height))                                 \n"
"      goto cleanup;                                                           \n"
"                                                                              \n"
"  result.width  = width;                                                      \n"
"  result.height = height;                                                     \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  rgbe_file_free (file);                                                      \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static gboolean                                                               \n"
"gegl_rgbe_load_process (GeglOperation       *operation,                       \n"
"                        GeglBuffer          *output,                          \n"
"                        const GeglRectangle *result,                          \n"
"                        gint                 level)                           \n"
"{                                                                             \n"
"  GeglProperties       *o       = GEGL_PROPERTIES (operation);                \n"
"  gboolean          success = FALSE;                                          \n"
"  gfloat           *pixels  = NULL;                                           \n"
"  rgbe_file        *file;                                                     \n"
"  guint             width, height;                                            \n"
"                                                                              \n"
"  file = rgbe_load_path (o->path);                                            \n"
"  if (!file)                                                                  \n"
"      goto cleanup;                                                           \n"
"                                                                              \n"
"  if (!rgbe_get_size (file, &width, &height))                                 \n"
"      goto cleanup;                                                           \n"
"                                                                              \n"
"  if (width  != result->width  ||                                             \n"
"      height != result->height)                                               \n"
"      goto cleanup;                                                           \n"
"                                                                              \n"
"  pixels = rgbe_read_scanlines (file);                                        \n"
"  if (!pixels)                                                                \n"
"    goto cleanup;                                                             \n"
"                                                                              \n"
"  gegl_buffer_set (output, result, 0, babl_format (FORMAT), pixels,           \n"
"                   GEGL_AUTO_ROWSTRIDE);                                      \n"
"  success = TRUE;                                                             \n"
"                                                                              \n"
"cleanup:                                                                      \n"
"  g_free         (pixels);                                                    \n"
"  rgbe_file_free (file);                                                      \n"
"                                                                              \n"
"  return success;                                                             \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"gegl_rgbe_load_get_cached_region (GeglOperation *operation,                   \n"
"                                  const GeglRectangle *roi)                   \n"
"{                                                                             \n"
"  return gegl_rgbe_load_get_bounding_box (operation);                         \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = gegl_rgbe_load_process;                             \n"
"  operation_class->get_bounding_box  = gegl_rgbe_load_get_bounding_box;       \n"
"  operation_class->get_cached_region = gegl_rgbe_load_get_cached_region;      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:rgbe-load\",                                      \n"
"    \"title\",       _(\"RGBE File Loader\"),                                 \n"
"    \"categories\",  \"hidden\",                                              \n"
"    \"description\" , _(\"RGBE image loader (Radiance HDR format).\"),        \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".hdr\", \"gegl:rgbe-load\");             \n"
"  gegl_extension_handler_register (\".pic\", \"gegl:rgbe-load\");             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
