static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Kevin Cozens <kcozens@cvs.gimp.org>                         \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"File\"), \"\")                                  \n"
"    description    (_(\"Path to SVG file to load\"))                          \n"
"                                                                              \n"
"property_int (width,  _(\"Width\"),  -1)                                      \n"
"    description (_(\"Width for rendered image\"))                             \n"
"                                                                              \n"
"property_int (height, _(\"Height\"), -1)                                      \n"
"    description (_(\"Height for rendered image\"))                            \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_C_SOURCE svg-load.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <cairo.h>                                                            \n"
"#include <librsvg/rsvg.h>                                                     \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"R'G'B'A u8\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gint                                                                   \n"
"gegl_buffer_import_svg (GeglBuffer  *gegl_buffer,                             \n"
"                        const gchar *path,                                    \n"
"                        gint         width,                                   \n"
"                        gint         height)                                  \n"
"{                                                                             \n"
"    cairo_surface_t   *surface;                                               \n"
"    cairo_t           *cr;                                                    \n"
"    GError            *error = NULL;                                          \n"
"    RsvgDimensionData  svg_dimentions;                                        \n"
"    RsvgHandle        *handle;                                                \n"
"                                                                              \n"
"    handle = rsvg_handle_new_from_file (path, &error);                        \n"
"                                                                              \n"
"    if (!handle)                                                              \n"
"      return 1;                                                               \n"
"                                                                              \n"
"    rsvg_handle_get_dimensions (handle, &svg_dimentions);                     \n"
"                                                                              \n"
"    if (svg_dimentions.width == 0 || svg_dimentions.height == 0)              \n"
"      return 0;                                                               \n"
"                                                                              \n"
"    if (width < 1)                                                            \n"
"      width = svg_dimentions.width;                                           \n"
"                                                                              \n"
"    if (height < 1)                                                           \n"
"      height = svg_dimentions.height;                                         \n"
"                                                                              \n"
"    surface = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, width, height);\n"
"    cr = cairo_create (surface);                                              \n"
"                                                                              \n"
"    if (width  != svg_dimentions.width ||                                     \n"
"        height != svg_dimentions.height)                                      \n"
"      {                                                                       \n"
"        cairo_scale (cr,                                                      \n"
"                     (double)width / (double)svg_dimentions.width,            \n"
"                     (double)height / (double)svg_dimentions.height);         \n"
"      }                                                                       \n"
"                                                                              \n"
"    rsvg_handle_render_cairo (handle, cr);                                    \n"
"                                                                              \n"
"    cairo_surface_flush (surface);                                            \n"
"                                                                              \n"
"    gegl_buffer_set (gegl_buffer,                                             \n"
"                     GEGL_RECTANGLE (0, 0, width, height),                    \n"
"                     0,                                                       \n"
"                     babl_format (\"cairo-ARGB32\"),                          \n"
"                     cairo_image_surface_get_data (surface),                  \n"
"                     cairo_image_surface_get_stride (surface));               \n"
"                                                                              \n"
"    cairo_destroy (cr);                                                       \n"
"    cairo_surface_destroy (surface);                                          \n"
"    g_object_unref (handle);                                                  \n"
"                                                                              \n"
"    return 0;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglProperties   *o      = GEGL_PROPERTIES (operation);                     \n"
"  gint          width  = o->width;                                            \n"
"  gint          height = o->height;                                           \n"
"                                                                              \n"
"  if (!o->path || !strlen(o->path))                                           \n"
"    return *GEGL_RECTANGLE(0, 0, 0, 0);                                       \n"
"                                                                              \n"
"  if (width < 1 || height < 1)                                                \n"
"    {                                                                         \n"
"      RsvgDimensionData  svg_dimentions;                                      \n"
"      RsvgHandle        *handle;                                              \n"
"      GError            *error = NULL;                                        \n"
"                                                                              \n"
"      handle = rsvg_handle_new_from_file (o->path, &error);                   \n"
"                                                                              \n"
"      if (!handle)                                                            \n"
"        return *GEGL_RECTANGLE(0, 0, 0, 0);                                   \n"
"                                                                              \n"
"      rsvg_handle_get_dimensions (handle, &svg_dimentions);                   \n"
"                                                                              \n"
"      if (width < 1)                                                          \n"
"        width = svg_dimentions.width;                                         \n"
"                                                                              \n"
"      if (height < 1)                                                         \n"
"        height = svg_dimentions.height;                                       \n"
"                                                                              \n"
"      rsvg_handle_get_dimensions (handle, &svg_dimentions);                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  return *GEGL_RECTANGLE(0, 0, width, height);                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result_foo,                                     \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gint        result;                                                         \n"
"  gint        width, height;                                                  \n"
"                                                                              \n"
"  width  = o->width;                                                          \n"
"  height = o->height;                                                         \n"
"                                                                              \n"
"  result = gegl_buffer_import_svg (output, o->path, width, height);           \n"
"  if (result)                                                                 \n"
"    {                                                                         \n"
"      g_warning (\"%s failed to open file %s for reading.\",                  \n"
"        G_OBJECT_TYPE_NAME (operation), o->path);                             \n"
"      return  FALSE;                                                          \n"
"    }                                                                         \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:svg-load\",                                      \n"
"    \"title\",        _(\"SVG File Loader\"),                                 \n"
"    \"categories\"  , \"input\",   /* not hidden because it has extra API */  \n"
"    \"description\" , _(\"Load an SVG file using librsvg\"),                  \n"
"    NULL);                                                                    \n"
"                                                                              \n"
"  gegl_extension_handler_register (\".svg\", \"gegl:svg-load\");              \n"
"  gegl_extension_handler_register (\".svgz\", \"gegl:svg-load\");             \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
