#! /usr/bin/env python

# Genetic
# Copyright (C) 2001 Jean-Baptiste LAMY
#
# This program is free software. See README or LICENSE for the license terms.

import random, string, math
from genetic import organism, lifecycle


# Set the function to minimize. f(x) = x minimize in -infinity !

def FUNC(x): return x

class FUNCMinimizer(organism.Organism):
  characteristics = [
    organism.Characteristic("FUNC", FUNC, organism.RECESSIVE_PHENOTYPE)
    ]
  
  def __cmp__(self, other):
    return cmp(self.FUNC, other.FUNC)


# Create the initial set of organisms.

organismA = FUNCMinimizer([
  organism.Chromosom(x = 5.0),
  ])

organismB = FUNCMinimizer([
  organism.Chromosom(x = 1.0),
  ])

organisms = [organismA, organismB]


# Define some parameters

# True for elitism (= always keep the best organism)
ELITISM = 1

# Number of generation to run
NB_GENERATION = 10

# Number of children each generation made
NB_CHILDREN  = 100

# Number of organisms kept per generation (other children doesn't survive)
NB_ORGANISMS = 10


# Ready !

lifecycle.run(organisms, ELITISM, NB_GENERATION, NB_CHILDREN, NB_ORGANISMS)

# This time we see __mutation__ and __mutampl__ increasing quickly !
#
# Obviously the final result IS NOT the minimum, as we'll never obtain infinity. But, at the
# end of the experience, if you can see that __mutation__ and / or __mutampl__ are high,
# this clearly means that you are not arrived at the real minimum, since the organisms are
# not stable !
