/* 
 * Originally from BOGL - Ben's Own Graphics Library.
 * Written by Ben Pfaff <pfaffben@debian.org>.
 */
#include "device.h"

/* Symbol font definition. */

MWIMAGEBITS symbol_bits[] = {
/* Character 0x00:
   +--------------------------------+
   |                                |
   |                                |
   |*******                         |
   |*     *                         |
   |*     *                         |
   |*     *                         |
   |*     *                         |
   |*     *                         |
   |*******                         |
   |                                |
   |                                |
   |                                |
   +--------------------------------+ */
0x0000,
0x0000,
0xfe00,
0x8200,
0x8200,
0x8200,
0x8200,
0x8200,
0xfe00,
0x0000,
0x0000,
0x0000,

/* Character 0x01:
   +--------------------------------+
   |                                |
   |                                |
   |*******                         |
   |*     *                         |
   |* * * *                         |
   |*  *  *                         |
   |* * * *                         |
   |*     *                         |
   |*******                         |
   |                                |
   |                                |
   |                                |
   +--------------------------------+ */
0x0000,
0x0000,
0xfe00,
0x8200,
0xaa00,
0x9200,
0xaa00,
0x8200,
0xfe00,
0x0000,
0x0000,
0x0000,

/* Character 0x02:
   +--------------------------------+
   |                                |
   |                                |
   |  *                             |
   | ***                            |
   |*****                           |
   |  *                             |
   |  *                             |
   |  *                             |
   |  *                             |
   |                                |
   |                                |
   |                                |
   +--------------------------------+ */
0x0000,
0x0000,
0x2000,
0x7000,
0xf800,
0x2000,
0x2000,
0x2000,
0x2000,
0x0000,
0x0000,
0x0000,

/* Character 0x03:
   +--------------------------------+
   |                                |
   |                                |
   |  *                             |
   |  *                             |
   |  *                             |
   |  *                             |
   |*****                           |
   | ***                            |
   |  *                             |
   |                                |
   |                                |
   |                                |
   +--------------------------------+ */
0x0000,
0x0000,
0x2000,
0x2000,
0x2000,
0x2000,
0xf800,
0x7000,
0x2000,
0x0000,
0x0000,
0x0000,

};

static unsigned short symbol_offset[] = {
  0,	/* 0x00 */
  12,	/* 0x01 */
  24,	/* 0x02 */
  36,	/* 0x03 */
};

static unsigned char symbol_width[] = {
  8,	/* 0x00 */
  8,	/* 0x01 */
  5,	/* 0x02 */
  5,	/* 0x03 */
};

MWCFONT font_symbol = {
	"symbol",
	8,
	12,
	9,
	0,
	4,
	symbol_bits,
	symbol_offset,
	symbol_width,
};
