/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.compression;

import com.google.protobuf.GeneratedMessage;
import edu.cornell.med.icb.goby.compression.ChunkCodec;
import edu.cornell.med.icb.goby.compression.ChunkCodecHelper;
import edu.cornell.med.icb.goby.compression.ProtobuffCollectionHandler;
import edu.cornell.med.icb.goby.exception.GobyRuntimeException;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MessageChunksReader
implements Closeable {
    private static final Log LOG = LogFactory.getLog(MessageChunksReader.class);
    protected DataInputStream in;
    protected int entryIndex;
    long bytesRead = 0L;
    protected ChunkCodec chunkCodec;
    private int chunkIndex = 0;
    protected long streamPositionAtStart = 0L;
    protected byte[] compressedBytes;
    private ProtobuffCollectionHandler handler;

    public byte[] getCompressedBytes() {
        return this.compressedBytes;
    }

    protected MessageChunksReader() {
    }

    public MessageChunksReader(InputStream input) {
        assert (input != null) : "The input stream must not be null";
        this.in = new DataInputStream(input);
    }

    public boolean hasNext(GeneratedMessage collection, int collectionSize) {
        if (collection == null || this.entryIndex >= collectionSize) {
            if (this.in == null) {
                this.compressedBytes = null;
                return false;
            }
            try {
                int numRead;
                if (this.in.available() == 0) {
                    this.compressedBytes = null;
                    return false;
                }
                byte codecRegistrationCode = this.in.readByte();
                ++this.bytesRead;
                if (!this.confirmDelimiter(this.in)) {
                    this.compressedBytes = null;
                    return false;
                }
                if (this.chunkCodec == null || codecRegistrationCode != this.chunkCodec.registrationCode()) {
                    this.installCodec(codecRegistrationCode);
                }
                assert (this.chunkCodec != null) : "chunkCodec code must not be null";
                ++this.chunkIndex;
                int numBytes = this.in.readInt();
                if (numBytes < 0) {
                    LOG.error(String.format("Negative number of bytes at position %d was size=%X %n", this.bytesRead + this.streamPositionAtStart, numBytes));
                    return false;
                }
                this.bytesRead += 4L;
                if (numBytes == 0) {
                    this.compressedBytes = null;
                    return false;
                }
                byte[] bytes = new byte[numBytes];
                int totalRead = 0;
                int offset = 0;
                while (totalRead < numBytes && (numRead = this.in.read(bytes, offset, numBytes - totalRead)) != -1) {
                    this.bytesRead += (long)numBytes;
                    totalRead += numRead;
                    offset += numRead;
                }
                if (totalRead != numBytes) {
                    LOG.warn("Expected " + numBytes + " but got " + totalRead);
                }
                this.compressedBytes = bytes;
                this.entryIndex = 0;
                return true;
            }
            catch (IOException e) {
                throw new GobyRuntimeException(e);
            }
        }
        this.compressedBytes = null;
        return this.entryIndex < collectionSize;
    }

    private boolean confirmDelimiter(DataInputStream in) throws IOException {
        for (int i = 0; i < 7; ++i) {
            if (in.available() == 0) {
                return false;
            }
            byte b = in.readByte();
            ++this.bytesRead;
            if (b == -1) continue;
            return false;
        }
        return true;
    }

    private boolean installCodec(byte registrationCode) {
        this.chunkCodec = ChunkCodecHelper.withRegistrationCodeSilent(registrationCode);
        if (this.chunkCodec != null) {
            this.chunkCodec.setHandler(this.handler);
            return true;
        }
        return false;
    }

    public int incrementEntryIndex() {
        return this.entryIndex++;
    }

    public int getEntryIndex() {
        return this.entryIndex;
    }

    @Override
    public void close() {
        IOUtils.closeQuietly(this.in);
    }

    public long position() throws IOException {
        return this.bytesRead;
    }

    public void setChunkCodec(ChunkCodec chunkCodec) {
        this.chunkCodec = chunkCodec;
    }

    public void setHandler(ProtobuffCollectionHandler collectionParser) {
        this.handler = collectionParser;
        if (this.chunkCodec != null) {
            this.chunkCodec.setHandler(collectionParser);
        }
    }

    public ChunkCodec getChunkCodec() {
        if (this.chunkCodec != null) {
            this.chunkCodec.setHandler(this.handler);
        }
        return this.chunkCodec;
    }
}

