/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.text;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.broadinstitute.gatk.engine.datasources.reads.SAMReaderID;
import org.broadinstitute.gatk.engine.refdata.tracks.FeatureManager;
import org.broadinstitute.gatk.engine.refdata.utils.RMDTriplet;
import org.broadinstitute.gatk.utils.commandline.ParsingEngine;
import org.broadinstitute.gatk.utils.commandline.RodBinding;
import org.broadinstitute.gatk.utils.commandline.Tags;
import org.broadinstitute.gatk.utils.exceptions.UserException;
import org.broadinstitute.gatk.utils.text.XReadLines;

public class ListFileUtils {
    public static final String LIST_FILE_COMMENT_START = "#";
    protected static final StringConverter<String> IDENTITY_STRING_CONVERTER = new StringConverter<String>(){

        @Override
        public String convert(String value) {
            return value;
        }
    };

    public static List<SAMReaderID> unpackBAMFileList(List<String> samFiles, ParsingEngine parser) {
        ArrayList<SAMReaderID> unpackedReads = new ArrayList<SAMReaderID>();
        for (String inputFileName : samFiles) {
            Tags inputFileNameTags = parser.getTags(inputFileName);
            if ((inputFileName = ListFileUtils.expandFileName(inputFileName)).toLowerCase().endsWith(".list")) {
                try {
                    for (String fileName : new XReadLines(new File(inputFileName), true, LIST_FILE_COMMENT_START)) {
                        unpackedReads.add(new SAMReaderID(fileName, parser.getTags(inputFileName)));
                    }
                    continue;
                }
                catch (FileNotFoundException ex) {
                    throw new UserException.CouldNotReadInputFile(new File(inputFileName), "Unable to find file while unpacking reads", ex);
                }
            }
            if (inputFileName.toLowerCase().endsWith(".bam")) {
                unpackedReads.add(new SAMReaderID(inputFileName, inputFileNameTags));
                continue;
            }
            if (inputFileName.endsWith("stdin")) {
                unpackedReads.add(new SAMReaderID(inputFileName, inputFileNameTags));
                continue;
            }
            throw new UserException.CommandLineException(String.format("The GATK reads argument (-I, --input_file) supports only BAM files with the .bam extension and lists of BAM files with the .list extension, but the file %s has neither extension.  Please ensure that your BAM file or list of BAM files is in the correct format, update the extension, and try again.", inputFileName));
        }
        return unpackedReads;
    }

    @Deprecated
    public static Collection<RMDTriplet> unpackRODBindingsOldStyle(Collection<String> RODBindings, ParsingEngine parser) {
        ArrayList<RMDTriplet> rodBindings = new ArrayList<RMDTriplet>();
        for (String fileName : RODBindings) {
            Tags tags = parser.getTags(fileName);
            fileName = ListFileUtils.expandFileName(fileName);
            List<String> positionalTags = tags.getPositionalTags();
            if (positionalTags.size() != 2) {
                throw new UserException("Invalid syntax for -B (reference-ordered data) input flag.  Please use the following syntax when providing reference-ordered data: -B:<name>,<type> <filename>.");
            }
            String name = positionalTags.get(0);
            String type = positionalTags.get(1);
            RMDTriplet.RMDStorageType storageType = tags.getValue("storage") != null ? Enum.valueOf(RMDTriplet.RMDStorageType.class, tags.getValue("storage")) : (fileName.toLowerCase().endsWith("stdin") ? RMDTriplet.RMDStorageType.STREAM : RMDTriplet.RMDStorageType.FILE);
            rodBindings.add(new RMDTriplet(name, type, fileName, storageType, tags));
        }
        return rodBindings;
    }

    public static Collection<RMDTriplet> unpackRODBindings(Collection<RodBinding> RODBindings, ParsingEngine parser) {
        ArrayList<RMDTriplet> rodBindings = new ArrayList<RMDTriplet>();
        FeatureManager builderForValidation = new FeatureManager();
        for (RodBinding rodBinding : RODBindings) {
            RMDTriplet.RMDStorageType storageType;
            String type;
            String argValue = rodBinding.getSource();
            String fileName = ListFileUtils.expandFileName(argValue);
            String name = rodBinding.getName();
            RMDTriplet triplet = new RMDTriplet(name, type = rodBinding.getTribbleType(), fileName, storageType = rodBinding.getTags().getValue("storage") != null ? Enum.valueOf(RMDTriplet.RMDStorageType.class, rodBinding.getTags().getValue("storage")) : (fileName.toLowerCase().endsWith("stdin") ? RMDTriplet.RMDStorageType.STREAM : RMDTriplet.RMDStorageType.FILE), rodBinding.getTags());
            FeatureManager.FeatureDescriptor descriptor = builderForValidation.getByTriplet(triplet);
            if (descriptor == null) {
                throw new UserException.UnknownTribbleType(rodBinding.getTribbleType(), String.format("Field %s had provided type %s but there's no such Tribble type.  The compatible types are: %n%s", rodBinding.getName(), rodBinding.getTribbleType(), builderForValidation.userFriendlyListOfAvailableFeatures(rodBinding.getType())));
            }
            if (!rodBinding.getType().isAssignableFrom(descriptor.getFeatureClass())) {
                throw new UserException.BadArgumentValue(rodBinding.getName(), String.format("Field %s expects Features of type %s, but the input file produces Features of type %s. The compatible types are: %n%s", rodBinding.getName(), rodBinding.getType().getSimpleName(), descriptor.getSimpleFeatureName(), builderForValidation.userFriendlyListOfAvailableFeatures(rodBinding.getType())));
            }
            rodBindings.add(triplet);
        }
        return rodBindings;
    }

    private static String expandFileName(String argument) {
        if (argument.trim().equals("-")) {
            return "/dev/stdin";
        }
        return argument;
    }

    public static Set<String> unpackSet(Collection<String> values) {
        if (values == null) {
            throw new NullPointerException("values cannot be null");
        }
        LinkedHashSet<String> unpackedValues = new LinkedHashSet<String>();
        for (String value : values) {
            File file = new File(value);
            if (value.toLowerCase().endsWith(".list") && file.exists()) {
                try {
                    unpackedValues.addAll(new XReadLines(file, true, LIST_FILE_COMMENT_START).readLines());
                    continue;
                }
                catch (IOException e) {
                    throw new UserException.CouldNotReadInputFile(file, (Exception)e);
                }
            }
            unpackedValues.add(value);
        }
        return unpackedValues;
    }

    public static Set<String> includeMatching(Collection<String> values, Collection<String> filters, boolean exactMatch) {
        return ListFileUtils.includeMatching(values, IDENTITY_STRING_CONVERTER, filters, exactMatch);
    }

    public static <T> Set<T> includeMatching(Collection<T> values, StringConverter<T> converter, Collection<String> filters, boolean exactMatch) {
        if (values == null) {
            throw new NullPointerException("values cannot be null");
        }
        if (converter == null) {
            throw new NullPointerException("converter cannot be null");
        }
        if (filters == null) {
            throw new NullPointerException("filters cannot be null");
        }
        Set<String> unpackedFilters = ListFileUtils.unpackSet(filters);
        LinkedHashSet<T> filteredValues = new LinkedHashSet<T>();
        Collection<Pattern> patterns = null;
        if (!exactMatch) {
            patterns = ListFileUtils.compilePatterns(unpackedFilters);
        }
        for (T value : values) {
            String converted = converter.convert(value);
            if (unpackedFilters.contains(converted)) {
                filteredValues.add(value);
                continue;
            }
            if (exactMatch) continue;
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(converted).find()) continue;
                filteredValues.add(value);
            }
        }
        return filteredValues;
    }

    public static <T> Set<T> excludeMatching(Collection<T> values, StringConverter<T> converter, Collection<String> filters, boolean exactMatch) {
        if (values == null) {
            throw new NullPointerException("values cannot be null");
        }
        if (converter == null) {
            throw new NullPointerException("converter cannot be null");
        }
        if (filters == null) {
            throw new NullPointerException("filters cannot be null");
        }
        Set<String> unpackedFilters = ListFileUtils.unpackSet(filters);
        LinkedHashSet<T> filteredValues = new LinkedHashSet<T>();
        filteredValues.addAll(values);
        Collection<Pattern> patterns = null;
        if (!exactMatch) {
            patterns = ListFileUtils.compilePatterns(unpackedFilters);
        }
        for (T value : values) {
            String converted = converter.convert(value);
            if (unpackedFilters.contains(converted)) {
                filteredValues.remove(value);
                continue;
            }
            if (exactMatch) continue;
            for (Pattern pattern : patterns) {
                if (!pattern.matcher(converted).find()) continue;
                filteredValues.remove(value);
            }
        }
        return filteredValues;
    }

    private static Collection<Pattern> compilePatterns(Collection<String> filters) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String filter : filters) {
            patterns.add(Pattern.compile(filter));
        }
        return patterns;
    }

    public static interface StringConverter<T> {
        public String convert(T var1);
    }
}

